/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import java.util.HashMap;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.CpoOrderBy;
import org.synchronoss.cpo.jdbc.JdbcAttribute;
import org.synchronoss.cpo.jdbc.JdbcMetaClass;

public class JdbcCpoOrderBy
implements CpoOrderBy {
    private boolean ascending;
    private String attribute;
    private String function;
    private String name = "__CPO_ORDERBY__";

    private JdbcCpoOrderBy() {
    }

    public JdbcCpoOrderBy(String attr, boolean asc) {
        this.setAscending(asc);
        this.setAttribute(attr);
        this.setFunction(null);
    }

    public JdbcCpoOrderBy(String attr, boolean asc, String func) {
        this.setAscending(asc);
        this.setAttribute(attr);
        this.setFunction(func);
    }

    @Override
    public boolean getAscending() {
        return this.ascending;
    }

    @Override
    public void setAscending(boolean b) {
        this.ascending = b;
    }

    @Override
    public String getAttribute() {
        return this.attribute;
    }

    @Override
    public void setAttribute(String s) {
        this.attribute = s;
    }

    @Override
    public String getFunction() {
        return this.function;
    }

    @Override
    public void setFunction(String s) {
        this.function = s;
    }

    public String toString(JdbcMetaClass<?> jmc) throws CpoException {
        StringBuilder sb = new StringBuilder();
        String function = null;
        String attribute = null;
        String column = null;
        int attrOffset = 0;
        int fromIndex = 0;
        HashMap<String, JdbcAttribute> columnMap = jmc.getColumnMap();
        JdbcAttribute jdbcAttribute = null;
        attribute = this.getAttribute();
        function = this.getFunction();
        if (attribute != null && attribute.length() > 0) {
            jdbcAttribute = columnMap.get(attribute);
            if (jdbcAttribute == null) {
                throw new CpoException(attribute);
            }
            sb.append(" ");
            column = jdbcAttribute.getDbName();
            if (column != null && column.length() > 0) {
                if (function != null && function.length() > 0) {
                    while ((attrOffset = function.indexOf(attribute, fromIndex)) != -1) {
                        sb.append(function.substring(0, attrOffset));
                        sb.append(column);
                        fromIndex += attrOffset + attribute.length();
                    }
                    sb.append(function.substring(fromIndex));
                } else {
                    sb.append(column);
                }
            }
            if (this.getAscending()) {
                sb.append(" ASC");
            } else {
                sb.append(" DESC");
            }
        }
        return sb.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }
}

