/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.synchronoss.cpo.jdbc.JdbcDataSourceInfo;

public class JdbcDataSource
implements DataSource {
    private PrintWriter printWriter_ = null;
    private int timeout_ = 0;
    private JdbcDataSourceInfo dataSourceInfo = null;

    private JdbcDataSource() {
    }

    public JdbcDataSource(JdbcDataSourceInfo jdsi) throws SQLException {
        this.setDataSourceInfo(jdsi);
        try {
            Class.forName(this.getDataSourceInfo().getDriver());
        }
        catch (ClassNotFoundException cnfe) {
            throw new SQLException("Could Not Load Driver" + this.getDataSourceInfo().getDriver());
        }
    }

    @Override
    public Connection getConnection(String userName, String password) throws SQLException {
        throw new SQLException("Not Implemented");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.makeNewConnection();
    }

    private Connection makeNewConnection() throws SQLException {
        Connection connection = null;
        switch (this.getDataSourceInfo().getConnectionType()) {
            case 1: {
                connection = DriverManager.getConnection(this.getDataSourceInfo().getUrl());
                break;
            }
            case 2: {
                connection = DriverManager.getConnection(this.getDataSourceInfo().getUrl(), this.getDataSourceInfo().getProperties());
                break;
            }
            case 3: {
                connection = DriverManager.getConnection(this.getDataSourceInfo().getUrl(), this.getDataSourceInfo().getUserName(), this.getDataSourceInfo().getPassword());
                break;
            }
            default: {
                throw new SQLException("Invalid Connection Type");
            }
        }
        return connection;
    }

    public synchronized String toString() {
        StringBuilder info = new StringBuilder();
        info.append("JdbcDataSource(");
        info.append(this.getDataSourceInfo().getUrl());
        info.append(",");
        info.append(this.getDataSourceInfo().getUserName());
        info.append(")");
        return info.toString();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.printWriter_;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.printWriter_ = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.timeout_ = seconds;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.timeout_;
    }

    public JdbcDataSourceInfo getDataSourceInfo() {
        return this.dataSourceInfo;
    }

    public void setDataSourceInfo(JdbcDataSourceInfo dataSourceInfo) {
        this.dataSourceInfo = dataSourceInfo;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

