/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.CpoReleasible;
import org.synchronoss.cpo.helper.ExceptionHelper;
import org.synchronoss.cpo.jdbc.JdbcAttribute;
import org.synchronoss.cpo.jdbc.JdbcCpoAdapter;
import org.synchronoss.cpo.jdbc.JdbcParameter;
import org.synchronoss.cpo.jdbc.JdbcQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcCallableStatementFactory
implements CpoReleasible {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger((String)JdbcCallableStatementFactory.class.getName());
    private CallableStatement cs_ = null;
    private ArrayList<CpoReleasible> releasibles = new ArrayList();
    private ArrayList<JdbcParameter> outParameters = new ArrayList();

    private JdbcCallableStatementFactory() {
    }

    public JdbcCallableStatementFactory(Connection conn, JdbcCpoAdapter jca, JdbcQuery jq, Object obj) throws CpoException {
        CallableStatement cstmt = null;
        JdbcAttribute attribute = null;
        Logger localLogger = obj == null ? logger : LoggerFactory.getLogger((String)obj.getClass().getName());
        try {
            this.outParameters = jq.getParameterList();
            localLogger.debug("SQL = <" + jq.getText() + ">");
            cstmt = conn.prepareCall(jq.getText());
            this.setCallableStatement(cstmt);
            int j = 1;
            for (JdbcParameter parameter : this.outParameters) {
                attribute = parameter.getAttribute();
                if (parameter.isInParameter()) {
                    attribute.invokeGetter(this, obj, j);
                }
                if (parameter.isOutParameter()) {
                    localLogger.debug("Setting OUT parameter " + j + " as Type " + attribute.getJavaSqlType());
                    cstmt.registerOutParameter(j, attribute.getJavaSqlType());
                }
                ++j;
            }
        }
        catch (Exception e) {
            localLogger.error("Error Instantiating JdbcCallableStatementFactory" + ExceptionHelper.getLocalizedMessage(e));
            throw new CpoException(e);
        }
    }

    public CallableStatement getCallableStatement() {
        return this.cs_;
    }

    protected void setCallableStatement(CallableStatement cs) {
        this.cs_ = cs;
    }

    public ArrayList<JdbcParameter> getOutParameters() {
        return this.outParameters;
    }

    public void AddReleasible(CpoReleasible releasible) {
        if (releasible != null) {
            this.releasibles.add(releasible);
        }
    }

    @Override
    public void release() throws CpoException {
        for (CpoReleasible releasible : this.releasibles) {
            try {
                releasible.release();
            }
            catch (CpoException ce) {
                logger.error("Error Releasing Callable Statement Transform Object", (Throwable)ce);
                throw ce;
            }
        }
    }
}

