/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.transform.jdbc;

import java.sql.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.encrypt.Encryptor;
import org.synchronoss.cpo.encrypt.EncryptorFactory;
import org.synchronoss.cpo.jdbc.JdbcCallableStatementFactory;
import org.synchronoss.cpo.jdbc.JdbcPreparedStatementFactory;
import org.synchronoss.cpo.transform.Transform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformDateToEncryptedString
implements Transform<String, Timestamp> {
    private static Logger logger = LoggerFactory.getLogger((String)TransformDateToEncryptedString.class.getName());
    private static Encryptor encryptor = null;
    private static String encLock = "lock";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransformDateToEncryptedString() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String string = encLock;
        synchronized (string) {
            if (encryptor == null) {
                encryptor = EncryptorFactory.getEncryptor();
            }
        }
    }

    @Override
    public Timestamp transformIn(String inDateString) throws CpoException {
        logger.debug("ENTERING transformIn");
        Timestamp inDate = null;
        if (inDateString != null) {
            try {
                logger.debug("encrypted string from db is " + inDateString);
                String dbDateString = encryptor.decrypt(inDateString);
                logger.debug("decrypted string is " + dbDateString);
                inDate = Timestamp.valueOf(dbDateString);
                logger.debug("Timestamp is " + inDate);
            }
            catch (Exception e) {
                throw new CpoException(e.getMessage());
            }
        }
        return inDate;
    }

    @Override
    public String transformOut(JdbcPreparedStatementFactory jpsf, Timestamp tsOut) throws CpoException {
        String outString = null;
        logger.debug("ENTERING transformOut");
        if (tsOut != null) {
            try {
                String encString = tsOut.toString();
                logger.debug("String to encrypt is " + encString);
                outString = encryptor.encrypt(encString);
            }
            catch (Exception e) {
                throw new CpoException(e.getMessage());
            }
        }
        return outString;
    }

    @Override
    public String transformOut(JdbcCallableStatementFactory jpsf, Timestamp attributeObject) throws CpoException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

