/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import java.io.PrintWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.Vector;
import javax.sql.DataSource;
import org.synchronoss.cpo.jdbc.JdbcConnection;
import org.synchronoss.cpo.jdbc.JdbcDataSourceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcDataSource
implements DataSource {
    private PrintWriter printWriter_ = null;
    private int timeout_ = 0;
    private HashMap<Connection, HashMap<String, PreparedStatement>> connectionPSMap_ = new HashMap();
    private HashMap<Connection, HashMap<String, CallableStatement>> connectionCSMap_ = new HashMap();
    private JdbcDataSourceInfo dataSourceInfo = null;
    private Vector<Connection> availableConnections = null;
    private Vector<Connection> busyConnections = null;

    private JdbcDataSource() {
    }

    public JdbcDataSource(JdbcDataSourceInfo jdsi) throws SQLException {
        this.setDataSourceInfo(jdsi);
        this.InitializeConnections(jdsi.getInitialConnections());
    }

    private void InitializeConnections(int initialConnections) throws SQLException {
        int newConnections = initialConnections > this.getDataSourceInfo().getMaxConnections() ? this.getDataSourceInfo().getMaxConnections() : initialConnections;
        this.availableConnections = new Vector();
        this.busyConnections = new Vector();
        for (int i = 0; i < newConnections; ++i) {
            this.availableConnections.addElement(this.makeNewConnection());
        }
    }

    @Override
    public Connection getConnection(String userName, String password) throws SQLException {
        Connection connection = null;
        if (this.getDataSourceInfo().getConnectionType() == 3) {
            connection = userName == this.getDataSourceInfo().getUserName() && password == this.getDataSourceInfo().getPassword() ? this.getConnection() : DriverManager.getConnection(this.getDataSourceInfo().getUrl(), userName, password);
        } else {
            throw new SQLException("Unable to connect to DataSource");
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        Connection connection = null;
        block6: while (true) {
            Vector<Connection> vector = this.availableConnections;
            synchronized (vector) {
                while (!this.availableConnections.isEmpty()) {
                    connection = this.availableConnections.lastElement();
                    this.availableConnections.removeElement(connection);
                    if (connection.isClosed() || this.isConnectionInvalid(connection)) {
                        connection = null;
                        continue;
                    }
                    this.busyConnections.addElement(connection);
                    break;
                }
            }
            if (connection != null) break;
            vector = this.availableConnections;
            synchronized (vector) {
                if (this.getDataSourceInfo().getMaxConnections() < 0 || this.totalConnections() < this.getDataSourceInfo().getMaxConnections()) {
                    this.availableConnections.addElement(this.makeNewConnection());
                } else if (!this.getDataSourceInfo().getWaitIfBusy()) {
                    throw new SQLException("Connection limit reached");
                }
            }
            while (true) {
                if (!this.availableConnections.isEmpty()) continue block6;
                Thread.yield();
            }
            break;
        }
        return new JdbcConnection(this, connection);
    }

    private Connection makeNewConnection() throws SQLException {
        Connection connection = null;
        try {
            Class.forName(this.getDataSourceInfo().getDriver());
            switch (this.getDataSourceInfo().getConnectionType()) {
                case 1: {
                    connection = DriverManager.getConnection(this.getDataSourceInfo().getUrl());
                    break;
                }
                case 2: {
                    connection = DriverManager.getConnection(this.getDataSourceInfo().getUrl(), this.getDataSourceInfo().getProperties());
                    break;
                }
                case 3: {
                    connection = DriverManager.getConnection(this.getDataSourceInfo().getUrl(), this.getDataSourceInfo().getUserName(), this.getDataSourceInfo().getPassword());
                    break;
                }
                default: {
                    throw new SQLException("Invalid Connection Type");
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new SQLException("Could Not Load Driver" + this.getDataSourceInfo().getDriver());
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free(Connection connection) {
        Vector<Connection> vector = this.availableConnections;
        synchronized (vector) {
            boolean b = this.busyConnections.removeElement(connection);
            if (b) {
                this.availableConnections.addElement(connection);
            }
        }
    }

    protected synchronized int totalConnections() {
        return this.availableConnections.size() + this.busyConnections.size();
    }

    protected synchronized void closeAllConnections() {
        this.closeConnections(this.availableConnections);
        this.availableConnections = new Vector();
        this.closeConnections(this.busyConnections);
        this.busyConnections = new Vector();
    }

    private void closeConnections(Vector<Connection> connections) {
        try {
            for (Connection connection : connections) {
                if (connection.isClosed()) continue;
                connection.close();
            }
            connections.removeAllElements();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public synchronized String toString() {
        StringBuffer info = new StringBuffer();
        info.append("JdbcDataSource(");
        info.append(this.getDataSourceInfo().getUrl());
        info.append(",");
        info.append(this.getDataSourceInfo().getUserName());
        info.append(")");
        info.append(", available=");
        info.append(this.availableConnections.size());
        info.append(", busy=");
        info.append(this.busyConnections.size());
        info.append(", max=");
        info.append(this.getDataSourceInfo().getMaxConnections());
        return info.toString();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.printWriter_;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.printWriter_ = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.timeout_ = seconds;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.timeout_;
    }

    private boolean isConnectionInvalid(Connection conn) {
        boolean invalid = true;
        try {
            conn.getMetaData();
            invalid = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return invalid;
    }

    public CallableStatement getCachedCallableStatement(Connection c, String sql, String key) throws SQLException {
        CallableStatement cs = null;
        HashMap<String, CallableStatement> csMap = this.connectionCSMap_.get(c);
        if (csMap != null) {
            cs = csMap.get(key);
        } else {
            csMap = new HashMap();
            this.connectionCSMap_.put(c, csMap);
        }
        if (cs == null) {
            cs = c.prepareCall(sql);
            csMap.put(key, cs);
        } else {
            cs.clearWarnings();
            cs.clearParameters();
            try {
                cs.clearBatch();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return cs;
    }

    public PreparedStatement getCachedPreparedStatement(Connection c, String sql, String key) throws SQLException {
        PreparedStatement ps = null;
        HashMap<String, PreparedStatement> psMap = this.connectionPSMap_.get(c);
        if (psMap != null) {
            ps = psMap.get(key);
        } else {
            psMap = new HashMap();
            this.connectionPSMap_.put(c, psMap);
        }
        if (ps == null) {
            ps = c.prepareStatement(sql);
            psMap.put(key, ps);
        } else {
            ps.clearWarnings();
            try {
                ps.clearBatch();
            }
            catch (Exception e) {
                // empty catch block
            }
            ps.clearParameters();
        }
        return ps;
    }

    public PreparedStatement getCachedPreparedStatement(Connection c, String sql) throws SQLException {
        return this.getCachedPreparedStatement(c, sql, sql);
    }

    public PreparedStatement getCachedPreparedStatement(Connection c, String sql, int autoGeneratedKeys) throws SQLException {
        String key = sql + "|" + autoGeneratedKeys;
        return this.getCachedPreparedStatement(c, sql, key);
    }

    public PreparedStatement getCachedPreparedStatement(Connection c, String sql, int[] columns) throws SQLException {
        return this.getCachedPreparedStatement(c, sql, this.buildStatement(sql, columns));
    }

    public PreparedStatement getCachedPreparedStatement(Connection c, String sql, String[] columns) throws SQLException {
        return this.getCachedPreparedStatement(c, sql, this.buildStatement(sql, columns));
    }

    public PreparedStatement getCachedPreparedStatement(Connection c, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String key = sql + "|" + resultSetType + "|" + resultSetConcurrency;
        return this.getCachedPreparedStatement(c, sql, key);
    }

    public PreparedStatement getCachedPreparedStatement(Connection c, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String key = sql + "|" + resultSetType + "|" + resultSetConcurrency + "|" + resultSetHoldability;
        return this.getCachedPreparedStatement(c, sql, key);
    }

    public CallableStatement getCachedCallableStatement(Connection c, String sql) throws SQLException {
        return this.getCachedCallableStatement(c, sql, sql);
    }

    public CallableStatement getCachedCallableStatement(Connection c, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String key = sql + "|" + resultSetType + "|" + resultSetConcurrency;
        return this.getCachedCallableStatement(c, sql, key);
    }

    public CallableStatement getCachedCallableStatement(Connection c, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String key = sql + "|" + resultSetType + "|" + resultSetConcurrency + "|" + resultSetHoldability;
        return this.getCachedCallableStatement(c, sql, key);
    }

    private String buildStatement(String sql, int[] columnIdx) {
        StringBuffer stmnt = new StringBuffer(sql);
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        for (int i = 0; i < columnIdx.length; ++i) {
            Integer col = new Integer(columnIdx[i]);
            treeMap.put(col, col);
        }
        for (Integer i : treeMap.values()) {
            stmnt.append("|");
            stmnt.append(i);
        }
        return stmnt.toString();
    }

    private String buildStatement(String sql, String[] columnNames) {
        StringBuffer stmnt = new StringBuffer(sql);
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (int i = 0; i < columnNames.length; ++i) {
            treeMap.put(columnNames[i], columnNames[i]);
        }
        for (String s : treeMap.values()) {
            stmnt.append("|");
            stmnt.append(s);
        }
        return stmnt.toString();
    }

    public JdbcDataSourceInfo getDataSourceInfo() {
        return this.dataSourceInfo;
    }

    public void setDataSourceInfo(JdbcDataSourceInfo dataSourceInfo) {
        this.dataSourceInfo = dataSourceInfo;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

