/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoException;

public class JavaSqlMethod<T>
implements Serializable,
Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(JavaSqlMethod.class);
    private static final long serialVersionUID = 1L;
    public static final int METHOD_TYPE_BASIC = 0;
    public static final int METHOD_TYPE_STREAM = 1;
    public static final int METHOD_TYPE_READER = 2;
    private Class<T> javaClass_ = null;
    private Class<T> javaSqlMethodClass_ = null;
    private Method rsGetter_ = null;
    private Method psSetter_ = null;
    private Method csGetter_ = null;
    private Method csSetter_ = null;
    private int methodType_ = 0;
    private static final Class<PreparedStatement> psc = PreparedStatement.class;
    private static final Class<ResultSet> rsc = ResultSet.class;
    private static final Class<CallableStatement> csc = CallableStatement.class;

    private JavaSqlMethod() {
    }

    public JavaSqlMethod(int methodType, Class<T> javaClass, Class<T> javaSqlMethodClass, String getterName, String setterName) {
        try {
            this.methodType_ = methodType;
            this.javaClass_ = javaClass;
            this.javaSqlMethodClass_ = javaSqlMethodClass;
            this.setRsGetter(getterName);
            this.setPsSetter(setterName);
            this.setCsGetter(getterName);
            this.setCsSetter(setterName);
        }
        catch (CpoException ce) {
            logger.error("Error In JavaSqlMethod", (Throwable)ce);
        }
    }

    public void setPsSetter(String setterName) throws CpoException {
        try {
            this.psSetter_ = this.getMethodType() == 0 ? psc.getMethod(setterName, Integer.TYPE, this.getJavaSqlMethodClass()) : psc.getMethod(setterName, Integer.TYPE, this.getJavaSqlMethodClass(), Integer.TYPE);
        }
        catch (NoSuchMethodException nsme) {
            logger.error("Error loading Setter" + setterName, (Throwable)nsme);
            throw new CpoException((Throwable)nsme);
        }
    }

    public void setRsGetter(String getterName) throws CpoException {
        try {
            this.rsGetter_ = rsc.getMethod(getterName, Integer.TYPE);
        }
        catch (NoSuchMethodException nsme) {
            logger.error("Error loading Getter" + getterName, (Throwable)nsme);
            throw new CpoException((Throwable)nsme);
        }
    }

    public void setCsSetter(String setterName) throws CpoException {
        try {
            this.csSetter_ = this.getMethodType() == 0 ? csc.getMethod(setterName, Integer.TYPE, this.getJavaSqlMethodClass()) : csc.getMethod(setterName, Integer.TYPE, this.getJavaSqlMethodClass(), Integer.TYPE);
        }
        catch (NoSuchMethodException nsme) {
            logger.error("Error loading Setter" + setterName, (Throwable)nsme);
            throw new CpoException((Throwable)nsme);
        }
    }

    public void setCsGetter(String getterName) throws CpoException {
        try {
            this.csGetter_ = csc.getMethod(getterName, Integer.TYPE);
        }
        catch (NoSuchMethodException nsme) {
            logger.error("Error loading Getter" + getterName, (Throwable)nsme);
            throw new CpoException((Throwable)nsme);
        }
    }

    public Class<T> getJavaClass() {
        return this.javaClass_;
    }

    public Class<T> getJavaSqlMethodClass() {
        return this.javaSqlMethodClass_;
    }

    public Method getRsGetter() {
        return this.rsGetter_;
    }

    public Method getPsSetter() {
        return this.psSetter_;
    }

    public Method getCsGetter() {
        return this.csGetter_;
    }

    public Method getCsSetter() {
        return this.csSetter_;
    }

    public int getMethodType() {
        return this.methodType_;
    }
}

