/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.CpoReleasible;
import org.synchronoss.cpo.helper.ExceptionHelper;
import org.synchronoss.cpo.jdbc.CallableStatementCpoData;
import org.synchronoss.cpo.jdbc.JdbcCpoAdapter;
import org.synchronoss.cpo.jdbc.JdbcCpoArgument;
import org.synchronoss.cpo.jdbc.JdbcCpoAttribute;
import org.synchronoss.cpo.meta.domain.CpoArgument;
import org.synchronoss.cpo.meta.domain.CpoAttribute;
import org.synchronoss.cpo.meta.domain.CpoFunction;

public class JdbcCallableStatementFactory
implements CpoReleasible {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(JdbcCallableStatementFactory.class);
    private CallableStatement cs_ = null;
    private List<CpoReleasible> releasibles = new ArrayList<CpoReleasible>();
    private List<CpoArgument> outArguments = new ArrayList<CpoArgument>();

    private JdbcCallableStatementFactory() {
    }

    public JdbcCallableStatementFactory(Connection conn, JdbcCpoAdapter jca, CpoFunction function, Object obj) throws CpoException {
        Logger localLogger = obj == null ? logger : LoggerFactory.getLogger(obj.getClass());
        try {
            this.outArguments = function.getArguments();
            localLogger.debug("SQL = <" + function.getExpression() + ">");
            CallableStatement cstmt = conn.prepareCall(function.getExpression());
            this.setCallableStatement(cstmt);
            int j = 1;
            for (CpoArgument argument : this.outArguments) {
                JdbcCpoArgument jdbcArgument = (JdbcCpoArgument)argument;
                JdbcCpoAttribute attribute = (JdbcCpoAttribute)argument.getAttribute();
                if (jdbcArgument.isInParameter()) {
                    CallableStatementCpoData cpoData = new CallableStatementCpoData(this, (CpoAttribute)attribute, j);
                    cpoData.invokeSetter(obj);
                }
                if (jdbcArgument.isOutParameter()) {
                    localLogger.debug("Setting OUT parameter " + j + " as Type " + attribute.getJavaSqlType());
                    if (jdbcArgument.getTypeInfo() != null) {
                        cstmt.registerOutParameter(j, attribute.getJavaSqlType(), jdbcArgument.getTypeInfo());
                    } else {
                        cstmt.registerOutParameter(j, attribute.getJavaSqlType());
                    }
                }
                ++j;
            }
        }
        catch (Exception e) {
            localLogger.error("Error Instantiating JdbcCallableStatementFactory" + ExceptionHelper.getLocalizedMessage((Throwable)e));
            throw new CpoException((Throwable)e);
        }
    }

    public CallableStatement getCallableStatement() {
        return this.cs_;
    }

    protected void setCallableStatement(CallableStatement cs) {
        this.cs_ = cs;
    }

    public List<CpoArgument> getOutArguments() {
        return this.outArguments;
    }

    public void AddReleasible(CpoReleasible releasible) {
        if (releasible != null) {
            this.releasibles.add(releasible);
        }
    }

    public void release() throws CpoException {
        for (CpoReleasible releasible : this.releasibles) {
            try {
                releasible.release();
            }
            catch (CpoException ce) {
                logger.error("Error Releasing Callable Statement Transform Object", (Throwable)ce);
                throw ce;
            }
        }
    }
}

