/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.jdbc.meta.JdbcCpoMetaDescriptor;
import org.synchronoss.cpo.meta.CpoMetaDescriptor;
import org.synchronoss.cpo.meta.domain.CpoAttribute;
import org.synchronoss.cpo.transform.jdbc.JdbcCpoTransform;

public class JdbcCpoAttribute
extends CpoAttribute
implements Serializable,
Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(JdbcCpoAttribute.class);
    private static final long serialVersionUID = 1L;
    private String dbTable_ = null;
    private String dbColumn_ = null;
    private int javaSqlType_ = 0;
    private JdbcCpoTransform jdbcTransform = null;
    private Method transformPSOutMethod = null;
    private Method transformCSOutMethod = null;

    public void setDbTable(String dbTable) {
        this.dbTable_ = dbTable;
    }

    public void setDbColumn(String dbColumn) {
        this.dbColumn_ = dbColumn;
    }

    public String getDbTable() {
        return this.dbTable_;
    }

    public String getDbColumn() {
        return this.dbColumn_;
    }

    protected void setJavaSqlType(int type) {
        this.javaSqlType_ = type;
    }

    protected int getJavaSqlType() {
        return this.javaSqlType_;
    }

    protected void initTransformClass(CpoMetaDescriptor metaDescriptor) throws CpoException {
        super.initTransformClass(metaDescriptor);
        if (this.getCpoTransform() != null && this.getCpoTransform() instanceof JdbcCpoTransform) {
            this.jdbcTransform = (JdbcCpoTransform)this.getCpoTransform();
            for (Method m : JdbcCpoAttribute.findMethods(this.jdbcTransform.getClass(), (String)"transformOut", (int)2, (boolean)true)) {
                if (m.getParameterTypes()[0].getName().equals("org.synchronoss.cpo.jdbc.JdbcPreparedStatementFactory")) {
                    this.transformPSOutMethod = m;
                    continue;
                }
                if (!m.getParameterTypes()[0].getName().equals("org.synchronoss.cpo.jdbc.JdbcCallableStatementFactory")) continue;
                this.transformCSOutMethod = m;
            }
        }
        this.setJavaSqlType(((JdbcCpoMetaDescriptor)metaDescriptor).getJavaSqlType(this.getDataName()));
    }
}

