/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.CpoOrderBy;
import org.synchronoss.cpo.meta.domain.CpoAttribute;
import org.synchronoss.cpo.meta.domain.CpoClass;

public class JdbcCpoOrderBy
implements CpoOrderBy {
    private boolean ascending;
    private String attribute;
    private String function;
    private String marker = "__CPO_ORDERBY__";

    private JdbcCpoOrderBy() {
    }

    public JdbcCpoOrderBy(String attr, boolean asc) {
        this.ascending = asc;
        this.attribute = attr;
        this.function = null;
    }

    public JdbcCpoOrderBy(String marker, String attr, boolean asc) {
        this.marker = marker;
        this.ascending = asc;
        this.attribute = attr;
        this.function = null;
    }

    public JdbcCpoOrderBy(String attr, boolean asc, String func) {
        this.ascending = asc;
        this.attribute = attr;
        this.function = func;
    }

    public JdbcCpoOrderBy(String marker, String attr, boolean asc, String func) {
        this.marker = marker;
        this.ascending = asc;
        this.attribute = attr;
        this.function = func;
    }

    public boolean getAscending() {
        return this.ascending;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public String getFunction() {
        return this.function;
    }

    public String toString(CpoClass cpoClass) throws CpoException {
        StringBuilder sb = new StringBuilder();
        int fromIndex = 0;
        if (this.attribute != null && this.attribute.length() > 0) {
            CpoAttribute jdbcAttribute = cpoClass.getAttributeJava(this.attribute);
            if (jdbcAttribute == null) {
                throw new CpoException(this.attribute);
            }
            sb.append(" ");
            String column = jdbcAttribute.getDataName();
            if (column != null && column.length() > 0) {
                if (this.function != null && this.function.length() > 0) {
                    int attrOffset;
                    while ((attrOffset = this.function.indexOf(this.attribute, fromIndex)) != -1) {
                        sb.append(this.function.substring(0, attrOffset));
                        sb.append(column);
                        fromIndex += attrOffset + this.attribute.length();
                    }
                    sb.append(this.function.substring(fromIndex));
                } else {
                    sb.append(column);
                }
            }
            if (this.getAscending()) {
                sb.append(" ASC");
            } else {
                sb.append(" DESC");
            }
        }
        return sb.toString();
    }

    public String getMarker() {
        return this.marker;
    }
}

