/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import java.util.Collection;
import org.synchronoss.cpo.ChildNodeException;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.CpoWhere;
import org.synchronoss.cpo.Node;
import org.synchronoss.cpo.jdbc.JdbcCpoAttribute;
import org.synchronoss.cpo.meta.domain.CpoAttribute;
import org.synchronoss.cpo.meta.domain.CpoClass;

public class JdbcCpoWhere
extends Node
implements CpoWhere {
    private static final long serialVersionUID = 1L;
    static final String[] comparisons = new String[]{"=", "<", ">", "<>", "IN", "LIKE", "<=", ">=", "EXISTS", "IS NULL"};
    static final String[] logicals = new String[]{"AND", "OR"};
    private int comparison = -1;
    private int logical = -1;
    private String attribute = null;
    private String rightAttribute = null;
    private Object value = null;
    private String attributeFunction = null;
    private String rightAttributeFunction = null;
    private String valueFunction = null;
    private boolean not = false;
    private String staticValue_ = null;
    private String name = "__CPO_WHERE__";

    public <T> JdbcCpoWhere(int logical, String attr, int comp, T value) {
        this.setLogical(logical);
        this.setAttribute(attr);
        this.setComparison(comp);
        this.setValue(value);
    }

    public <T> JdbcCpoWhere(int logical, String attr, int comp, T value, boolean not) {
        this.setLogical(logical);
        this.setAttribute(attr);
        this.setComparison(comp);
        this.setValue(value);
        this.setNot(not);
    }

    public JdbcCpoWhere() {
    }

    public void setComparison(int i) {
        this.comparison = i < 0 || i >= comparisons.length ? -1 : i;
    }

    public int getComparison() {
        return this.comparison;
    }

    public void setLogical(int i) {
        this.logical = i < 0 || i >= logicals.length ? -1 : i;
    }

    public int getLogical() {
        return this.logical;
    }

    public void setAttribute(String s) {
        this.attribute = s;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setRightAttribute(String s) {
        this.rightAttribute = s;
    }

    public String getRightAttribute() {
        return this.rightAttribute;
    }

    public void setValue(Object s) {
        this.value = s;
    }

    public Object getValue() {
        return this.value;
    }

    public void setStaticValue(String staticValue) {
        this.staticValue_ = staticValue;
    }

    public String getStaticValue() {
        return this.staticValue_;
    }

    public boolean getNot() {
        return this.not;
    }

    public void setNot(boolean b) {
        this.not = b;
    }

    public String toString(CpoClass cpoClass) throws CpoException {
        String fullyQualifiedColumn;
        StringBuilder sb = new StringBuilder();
        JdbcCpoAttribute jdbcAttribute = null;
        if (this.getLogical() != -1) {
            sb.append(" ");
            sb.append(logicals[this.getLogical()]);
        } else if (!this.hasParent()) {
            sb.append("WHERE");
        }
        if (this.getNot()) {
            sb.append(" NOT");
        }
        if (this.getAttribute() != null) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            fullyQualifiedColumn = (jdbcAttribute = (JdbcCpoAttribute)cpoClass.getAttributeJava(this.getAttribute())) == null ? this.getAttribute() : this.buildColumnName(jdbcAttribute);
            if (this.getAttributeFunction() != null) {
                if (jdbcAttribute != null) {
                    sb.append(this.buildFunction(this.getAttributeFunction(), jdbcAttribute.getJavaName(), fullyQualifiedColumn.toString()));
                } else {
                    sb.append(this.getAttributeFunction());
                }
            } else {
                sb.append(fullyQualifiedColumn);
            }
        }
        if (this.getComparison() != -1) {
            sb.append(" ");
            sb.append(comparisons[this.getComparison()]);
        }
        if (this.getComparison() != 9 && (this.getValue() != null || this.getRightAttribute() != null || this.getStaticValue() != null)) {
            sb.append(" ");
            if (this.getValue() != null) {
                if (this.getValueFunction() != null) {
                    if (jdbcAttribute == null) {
                        jdbcAttribute = (JdbcCpoAttribute)cpoClass.getAttributeJava(this.getRightAttribute());
                    }
                    sb.append(this.buildFunction(this.getValueFunction(), this.getAttributeName(jdbcAttribute, this.getAttribute(), this.getRightAttribute()), "?"));
                } else if (this.getComparison() == 4 && this.getValue() instanceof Collection) {
                    Collection coll = (Collection)this.getValue();
                    sb.append("(");
                    if (coll.size() > 0) {
                        sb.append("?");
                        for (int i = 1; i < coll.size(); ++i) {
                            sb.append(", ?");
                        }
                    }
                    sb.append(")");
                } else {
                    sb.append("?");
                }
            } else if (this.getRightAttribute() != null) {
                jdbcAttribute = (JdbcCpoAttribute)cpoClass.getAttributeJava(this.getRightAttribute());
                fullyQualifiedColumn = jdbcAttribute == null ? this.getRightAttribute() : this.buildColumnName(jdbcAttribute);
                if (this.getRightAttributeFunction() != null) {
                    sb.append(this.buildFunction(this.getRightAttributeFunction(), this.getAttributeName(jdbcAttribute, this.getAttribute(), this.getRightAttribute()), fullyQualifiedColumn));
                } else {
                    sb.append(fullyQualifiedColumn);
                }
            } else if (this.getStaticValue() != null) {
                sb.append(this.getStaticValue());
            }
        }
        return sb.toString();
    }

    private String getAttributeName(CpoAttribute jdbcAttribute, String leftAttribute, String rightAttribute) {
        String attrName = null;
        if (jdbcAttribute != null) {
            attrName = jdbcAttribute.getJavaName();
        }
        if (attrName == null && leftAttribute != null) {
            attrName = leftAttribute;
        }
        if (attrName == null && rightAttribute != null) {
            attrName = rightAttribute;
        }
        return attrName;
    }

    public void addWhere(CpoWhere cw) throws CpoException {
        try {
            this.addChild((Node)cw);
        }
        catch (ChildNodeException cne) {
            throw new CpoException("Error Adding Where Statement");
        }
    }

    public void setAttributeFunction(String s) {
        this.attributeFunction = s;
    }

    public String getAttributeFunction() {
        return this.attributeFunction;
    }

    public void setValueFunction(String s) {
        this.valueFunction = s;
    }

    public String getValueFunction() {
        return this.valueFunction;
    }

    public void setRightAttributeFunction(String s) {
        this.rightAttributeFunction = s;
    }

    public String getRightAttributeFunction() {
        return this.rightAttributeFunction;
    }

    private String buildFunction(String function, String match, String value) {
        StringBuilder sb = new StringBuilder();
        int fromIndex = 0;
        if (function != null && function.length() > 0) {
            int attrOffset;
            while ((attrOffset = function.indexOf(match, fromIndex)) != -1) {
                sb.append(function.substring(0, attrOffset));
                sb.append(value);
                fromIndex += attrOffset + match.length();
            }
            sb.append(function.substring(fromIndex));
        }
        return sb.toString();
    }

    private String buildColumnName(JdbcCpoAttribute attribute) {
        StringBuilder columnName = new StringBuilder();
        if (attribute.getDbTable() != null) {
            columnName.append(attribute.getDbTable());
            columnName.append(".");
        }
        if (attribute.getDbColumn() != null) {
            columnName.append(attribute.getDbColumn());
        } else {
            columnName.append(attribute.getDataName());
        }
        return columnName.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

