/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import java.util.ArrayList;
import java.util.Collection;
import org.synchronoss.cpo.Node;
import org.synchronoss.cpo.NodeVisitor;
import org.synchronoss.cpo.jdbc.BindAttribute;
import org.synchronoss.cpo.jdbc.JdbcCpoAttribute;
import org.synchronoss.cpo.jdbc.JdbcCpoWhere;
import org.synchronoss.cpo.meta.domain.CpoClass;

public class JdbcWhereBuilder<T>
implements NodeVisitor {
    private StringBuilder whereClause = new StringBuilder();
    private CpoClass cpoClass = null;
    private Collection<BindAttribute> bindValues = new ArrayList<BindAttribute>();

    public String getWhereClause() {
        return this.whereClause.toString();
    }

    public Collection<BindAttribute> getBindValues() {
        return this.bindValues;
    }

    private JdbcWhereBuilder() {
    }

    public JdbcWhereBuilder(CpoClass cpoClass) {
        this.cpoClass = cpoClass;
    }

    public boolean visitBegin(Node node) throws Exception {
        JdbcCpoWhere jcw = (JdbcCpoWhere)node;
        this.whereClause.append(jcw.toString(this.cpoClass));
        if (jcw.hasParent() || jcw.getLogical() != -1) {
            this.whereClause.append(" (");
        } else {
            this.whereClause.append(" ");
        }
        return true;
    }

    public boolean visitMiddle(Node node) throws Exception {
        return true;
    }

    public boolean visitEnd(Node node) throws Exception {
        JdbcCpoWhere jcw = (JdbcCpoWhere)node;
        if (jcw.hasParent() || jcw.getLogical() != -1) {
            this.whereClause.append(")");
        }
        return true;
    }

    public boolean visit(Node node) throws Exception {
        JdbcCpoWhere jcw = (JdbcCpoWhere)node;
        this.whereClause.append(jcw.toString(this.cpoClass));
        if (jcw.getValue() != null) {
            JdbcCpoAttribute attribute = (JdbcCpoAttribute)this.cpoClass.getAttributeJava(jcw.getAttribute());
            if (attribute == null) {
                attribute = (JdbcCpoAttribute)this.cpoClass.getAttributeJava(jcw.getRightAttribute());
            }
            if (attribute == null) {
                this.bindValues.add(new BindAttribute(jcw.getAttribute() == null ? jcw.getRightAttribute() : jcw.getAttribute(), jcw.getValue(), jcw.getComparison() == 4));
            } else {
                this.bindValues.add(new BindAttribute(attribute, jcw.getValue(), jcw.getComparison() == 4));
            }
        }
        return true;
    }
}

