/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import java.io.InputStream;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoByteArrayInputStream;
import org.synchronoss.cpo.CpoCharArrayReader;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.helper.ExceptionHelper;
import org.synchronoss.cpo.jdbc.AbstractJdbcCpoData;
import org.synchronoss.cpo.jdbc.JavaSqlMethod;
import org.synchronoss.cpo.jdbc.JavaSqlMethods;
import org.synchronoss.cpo.jdbc.JdbcPreparedStatementFactory;
import org.synchronoss.cpo.meta.domain.CpoAttribute;
import org.synchronoss.cpo.transform.CpoTransform;
import org.synchronoss.cpo.transform.jdbc.JdbcCpoTransform;

public class PreparedStatementCpoData
extends AbstractJdbcCpoData {
    private static final Logger logger = LoggerFactory.getLogger(PreparedStatementCpoData.class);
    private JdbcPreparedStatementFactory jpsf = null;
    private int index = -1;

    public PreparedStatementCpoData(JdbcPreparedStatementFactory jpsf, CpoAttribute cpoAttribute, int index) {
        super(cpoAttribute, index);
        this.jpsf = jpsf;
    }

    public void invokeSetter(Object instanceObject) throws CpoException {
        Logger localLogger = instanceObject == null ? logger : LoggerFactory.getLogger(instanceObject.getClass());
        CpoAttribute cpoAttribute = this.getCpoAttribute();
        Object param = this.transformOut(cpoAttribute.invokeGetter(instanceObject));
        JavaSqlMethod<?> javaSqlMethod = JavaSqlMethods.getJavaSqlMethod(this.getDataSetterParamType());
        if (javaSqlMethod == null) {
            throw new CpoException("Error Retrieveing Jdbc Method for type: " + this.getDataSetterParamType().getName());
        }
        localLogger.info(cpoAttribute.getDataName() + "=" + param);
        try {
            switch (javaSqlMethod.getMethodType()) {
                case 0: {
                    javaSqlMethod.getPsSetter().invoke((Object)this.jpsf.getPreparedStatement(), new Integer(this.getIndex()), param);
                    break;
                }
                case 1: {
                    CpoByteArrayInputStream cbais = CpoByteArrayInputStream.getCpoStream((InputStream)((InputStream)param));
                    javaSqlMethod.getPsSetter().invoke((Object)this.jpsf.getPreparedStatement(), new Integer(this.getIndex()), cbais, new Integer(cbais.getLength()));
                    break;
                }
                case 2: {
                    CpoCharArrayReader ccar = CpoCharArrayReader.getCpoReader((Reader)((Reader)param));
                    javaSqlMethod.getPsSetter().invoke((Object)this.jpsf.getPreparedStatement(), new Integer(this.getIndex()), ccar, new Integer(ccar.getLength()));
                }
            }
        }
        catch (Exception e) {
            throw new CpoException("Error Invoking Jdbc Method: " + javaSqlMethod.getPsSetter().getName() + ":" + ExceptionHelper.getLocalizedMessage((Throwable)e));
        }
    }

    public Object transformOut(Object attributeObject) throws CpoException {
        Object retObj = attributeObject;
        CpoTransform cpoTransform = this.getCpoAttribute().getCpoTransform();
        if (cpoTransform != null) {
            retObj = cpoTransform instanceof JdbcCpoTransform ? ((JdbcCpoTransform)cpoTransform).transformOut(this.jpsf, attributeObject) : cpoTransform.transformOut(attributeObject);
        }
        return retObj;
    }
}

