/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc.parser;

import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.parser.ExpressionParser;

public class SQLExpressionParser
implements ExpressionParser {
    private static final Logger logger = LoggerFactory.getLogger(SQLExpressionParser.class);
    private static final String COMPARE_CHARS = " =<>!()";
    private static final String SEPARATOR_CHARS = " .,()\n";
    private String expression;

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public int countArguments() {
        return this.getArgumentIndexes().size();
    }

    private Collection<Integer> getArgumentIndexes() {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        if (this.expression != null) {
            StringReader reader = new StringReader(this.expression);
            try {
                int idx = 0;
                int rc = -1;
                boolean inDoubleQuotes = false;
                boolean inSingleQuotes = false;
                do {
                    if ((char)(rc = reader.read()) == '\'') {
                        inSingleQuotes = !inSingleQuotes;
                    } else if ((char)rc == '\"') {
                        inDoubleQuotes = !inDoubleQuotes;
                    } else if (!inSingleQuotes && !inDoubleQuotes && (char)rc == '?') {
                        indexes.add(idx);
                    }
                    ++idx;
                } while (rc != -1);
            }
            catch (Exception e) {
                logger.error("error counting bind markers");
            }
        }
        return indexes;
    }

    public List<String> parse() throws ParseException {
        if (this.expression == null) {
            throw new ParseException("The expression is null", -1);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Expression: " + this.expression);
        }
        if (this.expression.length() < 1) {
            return null;
        }
        if (!this.expression.contains("?")) {
            return null;
        }
        this.expression = this.expression.toUpperCase();
        ArrayList<String> colList = new ArrayList<String>();
        if (this.expression.startsWith("INSERT")) {
            int colParenStart = this.expression.indexOf("(");
            if (colParenStart == -1) {
                throw new ParseException("Unable to locate starting parenthesis for the column names.", -1);
            }
            int colParenEnd = this.expression.indexOf(")", colParenStart);
            if (colParenEnd == -1) {
                throw new ParseException("Unable to locate ending parenthesis for the column names.", -1);
            }
            int valParenStart = this.expression.indexOf("(", colParenEnd);
            if (valParenStart == -1) {
                throw new ParseException("Unable to locate starting parenthesis for the column values.", -1);
            }
            int valParenEnd = this.expression.lastIndexOf(")");
            if (valParenEnd == -1) {
                throw new ParseException("Unable to locate ending parenthesis for the column values.", -1);
            }
            String[] cols = this.expression.substring(colParenStart + 1, colParenEnd).split(",");
            String[] vals = this.expression.substring(valParenStart + 1, valParenEnd).split(",");
            if (cols == null || vals == null) {
                return null;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Found cols: " + cols.length);
                logger.debug("Found vals: " + vals.length);
            }
            if (cols.length != vals.length) {
                throw new ParseException("You seem to have " + cols.length + " columns, and " + vals.length + " values.\n\nThose numbers should be equal.", -1);
            }
            for (int i = 0; i < vals.length; ++i) {
                String val = vals[i];
                if (val.trim().equals("?")) {
                    colList.add(cols[i].trim());
                    continue;
                }
                if (!val.contains("?")) continue;
                SQLExpressionParser qp = new SQLExpressionParser();
                qp.setExpression(val);
                colList.addAll(qp.parse());
            }
        } else {
            int startIdx = 0;
            Collection<Integer> indexes = this.getArgumentIndexes();
            for (int qIdx : indexes) {
                String chunk = this.expression.substring(startIdx, qIdx);
                if (logger.isDebugEnabled()) {
                    logger.debug("Chunk [" + chunk + "]");
                }
                int fieldStartIdx = -1;
                int fieldEndIdx = -1;
                boolean found = false;
                boolean inFunction = false;
                for (int idx = chunk.length() - 1; !found && idx >= 0; --idx) {
                    char c = chunk.charAt(idx);
                    if (fieldEndIdx == -1) {
                        if (!inFunction && c == '(') {
                            inFunction = true;
                        } else if (inFunction && COMPARE_CHARS.indexOf(c) != -1) {
                            inFunction = false;
                        }
                        if (inFunction || COMPARE_CHARS.indexOf(c) != -1) continue;
                        fieldEndIdx = idx;
                        continue;
                    }
                    if (SEPARATOR_CHARS.indexOf(c) < 0) continue;
                    fieldStartIdx = idx + 1;
                    found = true;
                }
                if (found) {
                    String col = chunk.substring(fieldStartIdx, fieldEndIdx + 1);
                    colList.add(col);
                }
                startIdx = qIdx + 1;
            }
        }
        return colList;
    }
}

