/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.transform.jdbc;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import oracle.sql.BLOB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoByteArrayInputStream;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.jdbc.JdbcCallableStatementFactory;
import org.synchronoss.cpo.jdbc.JdbcPreparedStatementFactory;
import org.synchronoss.cpo.transform.jdbc.JdbcCpoTransform;
import org.synchronoss.cpo.transform.jdbc.OracleTemporaryBlob;

public class TransformGZipBlob
implements JdbcCpoTransform<Blob, byte[]> {
    private static final Logger logger = LoggerFactory.getLogger(TransformGZipBlob.class);

    public byte[] transformIn(Blob blob) throws CpoException {
        byte[] buffBytes = new byte[1024];
        byte[] retBytes = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (blob != null) {
            try {
                InputStream bis = blob.getBinaryStream();
                if (bis != null) {
                    CpoByteArrayInputStream cbais = CpoByteArrayInputStream.getCpoStream((InputStream)bis);
                    if (cbais.getLength() > 0) {
                        int length;
                        GZIPInputStream gzis = new GZIPInputStream((InputStream)cbais);
                        while ((length = gzis.read(buffBytes)) != -1) {
                            bos.write(buffBytes, 0, length);
                        }
                        bos.flush();
                        bos.close();
                        gzis.close();
                        cbais.close();
                        retBytes = bos.toByteArray();
                    } else {
                        retBytes = new byte[]{};
                    }
                }
            }
            catch (Exception e) {
                logger.error("Error in transform GZipBlob", (Throwable)e);
                throw new CpoException((Throwable)e);
            }
        }
        return retBytes;
    }

    @Override
    public Blob transformOut(JdbcPreparedStatementFactory jpsf, byte[] attributeObject) throws CpoException {
        BLOB newBlob = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            if (attributeObject != null) {
                GZIPOutputStream os = new GZIPOutputStream(baos);
                os.write(attributeObject);
                os.flush();
                os.close();
                newBlob = BLOB.createTemporary((Connection)jpsf.getPreparedStatement().getConnection(), (boolean)false, (int)10);
                jpsf.AddReleasible(new OracleTemporaryBlob(newBlob));
                OutputStream bos = newBlob.setBinaryStream(0L);
                bos.write(baos.toByteArray());
                bos.close();
            }
        }
        catch (Exception e) {
            String msg = "Error GZipping Byte Array";
            logger.error(msg, (Throwable)e);
            throw new CpoException(msg, (Throwable)e);
        }
        return newBlob;
    }

    @Override
    public Blob transformOut(JdbcCallableStatementFactory jpsf, byte[] attributeObject) throws CpoException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Blob transformOut(byte[] j) throws CpoException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

