/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.sql.DataSource;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.DataSourceInfo;

public abstract class AbstractDataSourceInfo
implements DataSourceInfo {
    private DataSource dataSource = null;
    private String dataSourceName = null;
    private final Object LOCK = new Object();
    private final String PASSWORD = "password";
    private final String PASSWD = "passwd";
    private final String PWD = "pwd";

    public AbstractDataSourceInfo(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public AbstractDataSourceInfo(String className, SortedMap<String, String> properties) {
        this.dataSourceName = this.BuildDataSourceName(className, properties);
    }

    public AbstractDataSourceInfo(String className, Properties properties) {
        this.dataSourceName = this.BuildDataSourceName(className, properties);
    }

    protected abstract DataSource createDataSource() throws CpoException;

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource getDataSource() throws CpoException {
        if (this.dataSource == null) {
            Object object = this.LOCK;
            synchronized (object) {
                try {
                    this.dataSource = this.createDataSource();
                }
                catch (Exception e) {
                    throw new CpoException("Error instantiating DataSource", (Throwable)e);
                }
            }
        }
        return this.dataSource;
    }

    private String BuildDataSourceName(String s, Properties properties) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (Object key : properties.keySet()) {
            map.put((String)key, properties.getProperty((String)key));
        }
        return this.BuildDataSourceName(s, map);
    }

    private String BuildDataSourceName(String s, SortedMap<String, String> map) {
        StringBuilder dsName = new StringBuilder(s);
        for (String obj : map.keySet()) {
            String key = obj;
            if ("password".equalsIgnoreCase(key) || "passwd".equalsIgnoreCase(key) || "pwd".equalsIgnoreCase(key)) continue;
            dsName.append(key);
            dsName.append("=");
            dsName.append((String)map.get(key));
        }
        return dsName.toString();
    }
}

