/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.sql.CallableStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoByteArrayInputStream;
import org.synchronoss.cpo.CpoCharArrayReader;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.helper.ExceptionHelper;
import org.synchronoss.cpo.jdbc.AbstractJdbcCpoData;
import org.synchronoss.cpo.jdbc.JavaSqlMethod;
import org.synchronoss.cpo.jdbc.JavaSqlMethods;
import org.synchronoss.cpo.jdbc.JdbcCallableStatementFactory;
import org.synchronoss.cpo.meta.domain.CpoAttribute;
import org.synchronoss.cpo.transform.CpoTransform;
import org.synchronoss.cpo.transform.jdbc.JdbcCpoTransform;

public class CallableStatementCpoData
extends AbstractJdbcCpoData {
    private static final Logger logger = LoggerFactory.getLogger(CallableStatementCpoData.class);
    private CallableStatement cs = null;
    JdbcCallableStatementFactory jcsf = null;

    public CallableStatementCpoData(CallableStatement cs, CpoAttribute cpoAttribute, int index) {
        super(cpoAttribute, index);
        this.cs = cs;
    }

    public CallableStatementCpoData(JdbcCallableStatementFactory jcsf, CpoAttribute cpoAttribute, int index) {
        super(cpoAttribute, index);
        this.jcsf = jcsf;
    }

    public Object invokeGetter() throws CpoException {
        Object javaObject;
        JavaSqlMethod<?> javaSqlMethod = JavaSqlMethods.getJavaSqlMethod(this.getDataGetterReturnType());
        if (javaSqlMethod == null) {
            throw new CpoException("Error Retrieveing Jdbc Method for type: " + this.getDataGetterReturnType().getName());
        }
        try {
            javaObject = this.transformIn(javaSqlMethod.getCsGetter().invoke((Object)this.cs, new Integer(this.getIndex())));
        }
        catch (IllegalAccessException iae) {
            logger.debug("Error Invoking CallableStatement Method: " + ExceptionHelper.getLocalizedMessage((Throwable)iae));
            throw new CpoException((Throwable)iae);
        }
        catch (InvocationTargetException ite) {
            logger.debug("Error Invoking CallableStatement Method: " + ExceptionHelper.getLocalizedMessage((Throwable)ite));
            throw new CpoException(ite.getCause());
        }
        return javaObject;
    }

    public void invokeSetter(Object instanceObject) throws CpoException {
        Logger localLogger = instanceObject == null ? logger : LoggerFactory.getLogger(instanceObject.getClass());
        CpoAttribute cpoAttribute = this.getCpoAttribute();
        Object param = this.transformOut(cpoAttribute.invokeGetter(instanceObject));
        JavaSqlMethod<?> javaSqlMethod = JavaSqlMethods.getJavaSqlMethod(this.getDataSetterParamType());
        if (javaSqlMethod == null) {
            throw new CpoException("Error Retrieveing Jdbc Method for type: " + this.getDataSetterParamType().getName());
        }
        localLogger.info(cpoAttribute.getDataName() + "=" + param);
        try {
            switch (javaSqlMethod.getMethodType()) {
                case 0: {
                    javaSqlMethod.getCsSetter().invoke((Object)this.jcsf.getCallableStatement(), new Integer(this.getIndex()), param);
                    break;
                }
                case 1: {
                    CpoByteArrayInputStream cbais = CpoByteArrayInputStream.getCpoStream((InputStream)((InputStream)param));
                    javaSqlMethod.getCsSetter().invoke((Object)this.jcsf.getCallableStatement(), new Integer(this.getIndex()), cbais, new Integer(cbais.getLength()));
                    break;
                }
                case 2: {
                    CpoCharArrayReader ccar = CpoCharArrayReader.getCpoReader((Reader)((Reader)param));
                    javaSqlMethod.getCsSetter().invoke((Object)this.jcsf.getCallableStatement(), new Integer(this.getIndex()), ccar, new Integer(ccar.getLength()));
                }
            }
        }
        catch (Exception e) {
            throw new CpoException("Error Invoking Jdbc Method: " + javaSqlMethod.getPsSetter().getName() + ":" + ExceptionHelper.getLocalizedMessage((Throwable)e));
        }
    }

    public Object transformOut(Object attributeObject) throws CpoException {
        Object retObj = attributeObject;
        CpoTransform cpoTransform = this.getCpoAttribute().getCpoTransform();
        if (cpoTransform != null) {
            retObj = cpoTransform instanceof JdbcCpoTransform ? ((JdbcCpoTransform)cpoTransform).transformOut(this.jcsf, attributeObject) : cpoTransform.transformOut(attributeObject);
        }
        return retObj;
    }
}

