/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.CpoNativeFunction;
import org.synchronoss.cpo.CpoOrderBy;
import org.synchronoss.cpo.CpoReleasible;
import org.synchronoss.cpo.CpoWhere;
import org.synchronoss.cpo.helper.ExceptionHelper;
import org.synchronoss.cpo.jdbc.BindAttribute;
import org.synchronoss.cpo.jdbc.JavaSqlMethod;
import org.synchronoss.cpo.jdbc.JavaSqlMethods;
import org.synchronoss.cpo.jdbc.JdbcCpoAdapter;
import org.synchronoss.cpo.jdbc.JdbcCpoAttribute;
import org.synchronoss.cpo.jdbc.JdbcCpoOrderBy;
import org.synchronoss.cpo.jdbc.JdbcCpoWhere;
import org.synchronoss.cpo.jdbc.JdbcWhereBuilder;
import org.synchronoss.cpo.jdbc.PreparedStatementCpoData;
import org.synchronoss.cpo.meta.domain.CpoArgument;
import org.synchronoss.cpo.meta.domain.CpoClass;
import org.synchronoss.cpo.meta.domain.CpoFunction;

public class JdbcPreparedStatementFactory
implements CpoReleasible {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(JdbcPreparedStatementFactory.class);
    private Logger localLogger = null;
    private PreparedStatement ps_ = null;
    private List<CpoReleasible> releasibles = new ArrayList<CpoReleasible>();
    private static final String WHERE_MARKER = "__CPO_WHERE__";
    private static final String ORDERBY_MARKER = "__CPO_ORDERBY__";

    private JdbcPreparedStatementFactory() {
    }

    public <T> JdbcPreparedStatementFactory(Connection conn, JdbcCpoAdapter jca, CpoClass criteria, CpoFunction function, T obj, Collection<CpoWhere> wheres, Collection<CpoOrderBy> orderBy, Collection<CpoNativeFunction> nativeQueries) throws CpoException {
        List<BindAttribute> bindValues = this.getBindValues(function, obj);
        String sql = this.buildSql(criteria, function.getExpression(), wheres, orderBy, nativeQueries, bindValues);
        this.localLogger = obj == null ? logger : LoggerFactory.getLogger(obj.getClass());
        this.localLogger.debug("CpoFunction SQL = <" + sql + ">");
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
        }
        catch (SQLException se) {
            this.localLogger.error("Error Instantiating JdbcPreparedStatementFactory SQL=<" + sql + ">" + ExceptionHelper.getLocalizedMessage((Throwable)se));
            throw new CpoException((Throwable)se);
        }
        this.setPreparedStatement(pstmt);
        this.setBindValues(bindValues);
    }

    private <T> String buildSql(CpoClass cpoClass, String sql, Collection<CpoWhere> wheres, Collection<CpoOrderBy> orderBy, Collection<CpoNativeFunction> nativeQueries, List<BindAttribute> bindValues) throws CpoException {
        StringBuilder sqlText = new StringBuilder();
        sqlText.append(sql);
        if (wheres != null) {
            for (CpoWhere where : wheres) {
                JdbcWhereBuilder jwb = new JdbcWhereBuilder(cpoClass);
                JdbcCpoWhere jcw = (JdbcCpoWhere)where;
                try {
                    jcw.acceptDFVisitor(jwb);
                }
                catch (Exception e) {
                    throw new CpoException("Unable to build WHERE clause", (Throwable)e);
                }
                if (sqlText.indexOf(jcw.getName()) == -1) {
                    sqlText.append(" ");
                    sqlText.append(jwb.getWhereClause());
                    bindValues.addAll(jwb.getBindValues());
                    continue;
                }
                sqlText = this.replaceMarker(sqlText, jcw.getName(), jwb, bindValues);
            }
        }
        if (orderBy != null) {
            HashMap<String, StringBuilder> mapOrderBy = new HashMap<String, StringBuilder>();
            try {
                for (CpoOrderBy ob : orderBy) {
                    StringBuilder sb = (StringBuilder)mapOrderBy.get(ob.getMarker());
                    if (sb == null) {
                        sb = new StringBuilder(" ORDER BY ");
                        mapOrderBy.put(ob.getMarker(), sb);
                    } else {
                        sb.append(",");
                    }
                    sb.append(((JdbcCpoOrderBy)ob).toString(cpoClass));
                }
            }
            catch (CpoException ce) {
                throw new CpoException("Error Processing OrderBy Attribute<" + ExceptionHelper.getLocalizedMessage((Throwable)ce) + "> not Found. JDBC Expression=<" + sqlText.toString() + ">");
            }
            Set entries = mapOrderBy.entrySet();
            for (Map.Entry entry : entries) {
                if (sqlText.indexOf((String)entry.getKey()) == -1) {
                    sqlText.append(((StringBuilder)entry.getValue()).toString());
                    continue;
                }
                sqlText = this.replaceMarker(sqlText, (String)entry.getKey(), ((StringBuilder)entry.getValue()).toString());
            }
        }
        if (nativeQueries != null) {
            for (CpoNativeFunction cnq : nativeQueries) {
                if (cnq.getMarker() == null || sqlText.indexOf(cnq.getMarker()) == -1) {
                    if (cnq.getExpression() == null || cnq.getExpression().length() <= 0) continue;
                    sqlText.append(" ");
                    sqlText.append(cnq.getExpression());
                    continue;
                }
                sqlText = this.replaceMarker(sqlText, cnq.getMarker(), cnq.getExpression());
            }
        }
        sqlText = this.replaceMarker(sqlText, WHERE_MARKER, "");
        sqlText = this.replaceMarker(sqlText, ORDERBY_MARKER, "");
        return sqlText.toString();
    }

    private StringBuilder replaceMarker(StringBuilder source, String marker, String replace) {
        int fromIndex = 0;
        int mLength = marker.length();
        String replaceText = replace == null ? "" : replace;
        int rLength = replaceText.length();
        if (source != null && source.length() > 0) {
            int attrOffset;
            while ((attrOffset = source.indexOf(marker, fromIndex)) != -1) {
                source.replace(attrOffset, attrOffset + mLength, replaceText);
                fromIndex = attrOffset + rLength;
            }
        }
        return source;
    }

    private <T> StringBuilder replaceMarker(StringBuilder source, String marker, JdbcWhereBuilder<T> jwb, List<BindAttribute> bindValues) {
        int fromIndex = 0;
        int mLength = marker.length();
        String replace = jwb.getWhereClause();
        int rLength = replace.length();
        Collection<BindAttribute> jwbBindValues = jwb.getBindValues();
        if (source != null && source.length() > 0) {
            int attrOffset;
            while ((attrOffset = source.indexOf(marker, fromIndex)) != -1) {
                source.replace(attrOffset, attrOffset + mLength, replace);
                fromIndex = attrOffset + rLength;
                bindValues.addAll(this.countBindMarkers(source.substring(0, attrOffset)), jwbBindValues);
            }
        }
        return source;
    }

    private int countBindMarkers(String source) {
        int qMarks = 0;
        boolean inDoubleQuotes = false;
        boolean inSingleQuotes = false;
        if (source != null) {
            StringReader reader = new StringReader(source);
            try {
                int rc;
                do {
                    if ((char)(rc = reader.read()) == '\'') {
                        inSingleQuotes = !inSingleQuotes;
                        continue;
                    }
                    if ((char)rc == '\"') {
                        inDoubleQuotes = !inDoubleQuotes;
                        continue;
                    }
                    if (inSingleQuotes || inDoubleQuotes || (char)rc != '?') continue;
                    ++qMarks;
                } while (rc != -1);
            }
            catch (Exception e) {
                logger.error("error counting bind markers");
            }
        }
        return qMarks;
    }

    public PreparedStatement getPreparedStatement() {
        return this.ps_;
    }

    protected void setPreparedStatement(PreparedStatement ps) {
        this.ps_ = ps;
    }

    public void AddReleasible(CpoReleasible releasible) {
        if (releasible != null) {
            this.releasibles.add(releasible);
        }
    }

    public void release() throws CpoException {
        for (CpoReleasible releasible : this.releasibles) {
            try {
                releasible.release();
            }
            catch (CpoException ce) {
                this.localLogger.error("Error Releasing Prepared Statement Transform Object", (Throwable)ce);
                throw ce;
            }
        }
    }

    protected List<BindAttribute> getBindValues(CpoFunction function, Object obj) throws CpoException {
        ArrayList<BindAttribute> bindValues = new ArrayList<BindAttribute>();
        List arguments = function.getArguments();
        for (CpoArgument argument : arguments) {
            if (argument == null) {
                throw new CpoException("CpoArgument is null!");
            }
            bindValues.add(new BindAttribute((JdbcCpoAttribute)argument.getAttribute(), obj));
        }
        return bindValues;
    }

    protected void setBindValues(Collection<BindAttribute> bindValues) throws CpoException {
        if (bindValues != null) {
            int index = 1;
            for (BindAttribute bindAttr : bindValues) {
                Object bindObject = bindAttr.getBindObject();
                JdbcCpoAttribute ja = bindAttr.getJdbcAttribute();
                JavaSqlMethod<?> jsm = null;
                if (bindAttr.isIn() && bindObject instanceof Collection) {
                    Iterator i$ = ((Collection)bindObject).iterator();
                    if (i$.hasNext()) {
                        Object obj = i$.next();
                        jsm = JavaSqlMethods.getJavaSqlMethod(obj.getClass());
                    }
                } else {
                    jsm = JavaSqlMethods.getJavaSqlMethod(bindObject.getClass());
                }
                if (jsm != null) {
                    try {
                        if (ja == null) {
                            this.localLogger.debug(bindAttr.getName() + "=" + bindObject);
                        } else {
                            this.localLogger.debug(ja.getDataName() + "=" + bindObject);
                        }
                        if (bindAttr.isIn() && bindObject instanceof Collection) {
                            for (Object obj : (Collection)bindObject) {
                                jsm.getPsSetter().invoke((Object)this.getPreparedStatement(), index++, obj);
                            }
                            continue;
                        }
                        jsm.getPsSetter().invoke((Object)this.getPreparedStatement(), index++, bindObject);
                        continue;
                    }
                    catch (IllegalAccessException iae) {
                        this.localLogger.error("Error Accessing Prepared Statement Setter: " + ExceptionHelper.getLocalizedMessage((Throwable)iae));
                        throw new CpoException((Throwable)iae);
                    }
                    catch (InvocationTargetException ite) {
                        this.localLogger.error("Error Invoking Prepared Statement Setter: " + ExceptionHelper.getLocalizedMessage((Throwable)ite));
                        throw new CpoException(ite.getCause());
                    }
                }
                PreparedStatementCpoData cpoData = new PreparedStatementCpoData(this, ja, index++);
                cpoData.invokeSetter(bindObject);
            }
        }
    }
}

