/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.jdbc.AbstractDataSourceInfo;

public class JndiDataSourceInfo
extends AbstractDataSourceInfo {
    private String jndiName = null;
    private Context jndiCtx = null;

    public JndiDataSourceInfo(String jndiName) {
        super(jndiName);
        this.jndiName = jndiName;
    }

    public JndiDataSourceInfo(String jndiName, Context ctx) {
        super(jndiName);
        this.jndiName = jndiName;
        this.jndiCtx = ctx;
    }

    @Override
    protected DataSource createDataSource() throws CpoException {
        DataSource datasource = null;
        try {
            if (this.jndiCtx == null) {
                this.jndiCtx = new InitialContext();
            }
            datasource = (DataSource)this.jndiCtx.lookup(this.jndiName);
        }
        catch (Exception e) {
            throw new CpoException("Error instantiating DataSource", (Throwable)e);
        }
        return datasource;
    }
}

