/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.helper.ExceptionHelper;
import org.synchronoss.cpo.jdbc.AbstractJdbcCpoData;
import org.synchronoss.cpo.jdbc.CallableStatementCpoData;
import org.synchronoss.cpo.jdbc.JavaSqlMethod;
import org.synchronoss.cpo.jdbc.JavaSqlMethods;
import org.synchronoss.cpo.meta.domain.CpoAttribute;

public class ResultSetCpoData
extends AbstractJdbcCpoData {
    private static final Logger logger = LoggerFactory.getLogger(CallableStatementCpoData.class);
    private ResultSet rs = null;
    private int index = -1;

    public ResultSetCpoData(ResultSet rs, CpoAttribute cpoAttribute, int index) {
        super(cpoAttribute, index);
        this.rs = rs;
    }

    public Object invokeGetter() throws CpoException {
        Object javaObject;
        JavaSqlMethod<?> javaSqlMethod = JavaSqlMethods.getJavaSqlMethod(this.getDataGetterReturnType());
        if (javaSqlMethod == null) {
            throw new CpoException("Error Retrieveing Jdbc Method for type: " + this.getDataGetterReturnType().getName());
        }
        try {
            javaObject = this.transformIn(javaSqlMethod.getRsGetter().invoke((Object)this.rs, new Integer(this.getIndex())));
        }
        catch (IllegalAccessException iae) {
            logger.debug("Error Invoking ResultSet Method: " + ExceptionHelper.getLocalizedMessage((Throwable)iae));
            throw new CpoException((Throwable)iae);
        }
        catch (InvocationTargetException ite) {
            logger.debug("Error Invoking ResultSet Method: " + ExceptionHelper.getLocalizedMessage((Throwable)ite));
            throw new CpoException(ite.getCause());
        }
        return javaObject;
    }
}

