/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc.meta;

import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.synchronoss.cpo.core.cpoCoreMeta.CtArgument;
import org.synchronoss.cpo.core.cpoCoreMeta.CtAttribute;
import org.synchronoss.cpo.jdbc.JavaSqlType;
import org.synchronoss.cpo.jdbc.JdbcCpoArgument;
import org.synchronoss.cpo.jdbc.JdbcCpoAttribute;
import org.synchronoss.cpo.jdbc.cpoJdbcMeta.CtJdbcArgument;
import org.synchronoss.cpo.jdbc.cpoJdbcMeta.CtJdbcAttribute;
import org.synchronoss.cpo.jdbc.parser.SQLExpressionParser;
import org.synchronoss.cpo.meta.AbstractCpoMetaAdapter;
import org.synchronoss.cpo.meta.domain.CpoArgument;
import org.synchronoss.cpo.meta.domain.CpoAttribute;
import org.synchronoss.cpo.parser.ExpressionParser;

public class JdbcCpoMetaAdapter
extends AbstractCpoMetaAdapter {
    private static final JavaSqlType<?>[] jdbcTypes = new JavaSqlType[]{new JavaSqlType<String>(1, "CHAR", String.class), new JavaSqlType<String>(-1, "LONGVARCHAR", String.class), new JavaSqlType<String>(12, "VARCHAR", String.class), new JavaSqlType<BigDecimal>(3, "DECIMAL", BigDecimal.class), new JavaSqlType<BigDecimal>(2, "NUMERIC", BigDecimal.class), new JavaSqlType<Byte>(-6, "TINYINT", Byte.TYPE), new JavaSqlType<Short>(5, "SMALLINT", Short.TYPE), new JavaSqlType<Integer>(4, "INTEGER", Integer.TYPE), new JavaSqlType<Long>(-5, "BIGINT", Long.TYPE), new JavaSqlType<Float>(7, "REAL", Float.TYPE), new JavaSqlType<Double>(6, "FLOAT", Double.TYPE), new JavaSqlType<Double>(8, "DOUBLE", Double.TYPE), new JavaSqlType<byte[]>(-2, "BINARY", byte[].class), new JavaSqlType<byte[]>(-3, "VARBINARY", byte[].class), new JavaSqlType<byte[]>(-4, "LONGVARBINARY", byte[].class), new JavaSqlType<Date>(91, "DATE", Date.class), new JavaSqlType<Time>(92, "TIME", Time.class), new JavaSqlType<Timestamp>(93, "TIMESTAMP", Timestamp.class), new JavaSqlType<Clob>(2005, "CLOB", Clob.class), new JavaSqlType<Blob>(2004, "BLOB", Blob.class), new JavaSqlType<Array>(2003, "ARRAY", Array.class), new JavaSqlType<Ref>(2006, "REF", Ref.class), new JavaSqlType<Object>(2001, "DISTINCT", Object.class), new JavaSqlType<Object>(2002, "STRUCT", Object.class), new JavaSqlType<Object>(1111, "OTHER", Object.class), new JavaSqlType<Object>(2000, "JAVA_OBJECT", Object.class), new JavaSqlType<URL>(70, "DATALINK", URL.class), new JavaSqlType<Boolean>(-7, "BIT", Boolean.TYPE), new JavaSqlType<Boolean>(16, "BOOLEAN", Boolean.TYPE), new JavaSqlType<String>(100, "VARCHAR_IGNORECASE", String.class)};
    private static HashMap<Integer, JavaSqlType<?>> javaSqlTypeMap = null;
    private static HashMap<String, JavaSqlType<?>> javaSqlTypeNameMap = null;

    protected void loadCpoAttribute(CpoAttribute cpoAttribute, CtAttribute ctAttribute) {
        super.loadCpoAttribute(cpoAttribute, ctAttribute);
        JdbcCpoAttribute jdbcAttribute = (JdbcCpoAttribute)cpoAttribute;
        CtJdbcAttribute ctJdbcAttribute = (CtJdbcAttribute)ctAttribute;
        jdbcAttribute.setDbTable(ctJdbcAttribute.getDbTable());
        jdbcAttribute.setDbColumn(ctJdbcAttribute.getDbColumn());
    }

    protected void loadCpoArgument(CpoArgument cpoArgument, CtArgument ctArgument) {
        super.loadCpoArgument(cpoArgument, ctArgument);
        JdbcCpoArgument jdbcArgument = (JdbcCpoArgument)cpoArgument;
        CtJdbcArgument ctJdbcArgument = (CtJdbcArgument)ctArgument;
        jdbcArgument.setScope(ctJdbcArgument.getScope().toString());
        jdbcArgument.setTypeInfo(ctJdbcArgument.getTypeInfo());
    }

    protected CpoAttribute createCpoAttribute() {
        return new JdbcCpoAttribute();
    }

    protected CpoArgument createCpoArgument() {
        return new JdbcCpoArgument();
    }

    public ExpressionParser getExpressionParser() {
        return new SQLExpressionParser();
    }

    public String getJavaTypeName(CpoAttribute attribute) {
        String clazzName = this.getJavaTypeClass(attribute).getName();
        byte[] b = new byte[]{};
        char[] c = new char[]{};
        if (b.getClass().getName().equals(clazzName)) {
            clazzName = "byte[]";
        } else if (c.getClass().getName().equals(clazzName)) {
            clazzName = "char[]";
        }
        return clazzName;
    }

    public Class<?> getJavaTypeClass(CpoAttribute attribute) {
        Class clazz = String.class;
        JavaSqlType<?> jdbcType = JdbcCpoMetaAdapter.getJdbcTypeNameMap().get(attribute.getDataType());
        if (attribute.getTransformInMethod() != null) {
            clazz = attribute.getTransformInMethod().getReturnType();
        } else if (jdbcType != null) {
            clazz = jdbcType.getJavaClass();
        }
        return clazz;
    }

    public List<String> getAllowableDataTypes() {
        return this.getSqlTypes();
    }

    public JavaSqlType<?> getJavaSqlType(int javaSqlType) {
        JavaSqlType<?> jdbcType = JdbcCpoMetaAdapter.getJdbcTypeMap().get(javaSqlType);
        if (jdbcType == null) {
            return JdbcCpoMetaAdapter.getJdbcTypeMap().get(12);
        }
        return jdbcType;
    }

    public int getJavaSqlType(String javaSqlTypeName) {
        JavaSqlType<?> jdbcType = JdbcCpoMetaAdapter.getJdbcTypeNameMap().get(javaSqlTypeName);
        if (jdbcType == null) {
            return 12;
        }
        return jdbcType.getJavaSqlType();
    }

    public Class<?> getSqlTypeClass(int javaSqlType) {
        return this.getSqlTypeClass(new Integer(javaSqlType));
    }

    public Class<?> getSqlTypeClass(Integer javaSqlType) {
        JavaSqlType<?> jdbcType = JdbcCpoMetaAdapter.getJdbcTypeMap().get(javaSqlType);
        if (jdbcType == null) {
            jdbcType = JdbcCpoMetaAdapter.getJdbcTypeMap().get(12);
        }
        return jdbcType.getJavaClass();
    }

    public Class<?> getSqlTypeClass(String javaSqlTypeName) {
        JavaSqlType<?> jdbcType = JdbcCpoMetaAdapter.getJdbcTypeNameMap().get(javaSqlTypeName);
        if (jdbcType == null) {
            jdbcType = JdbcCpoMetaAdapter.getJdbcTypeMap().get(12);
        }
        return jdbcType.getJavaClass();
    }

    private List<String> getSqlTypes() {
        ArrayList<String> al = new ArrayList<String>();
        al.addAll(JdbcCpoMetaAdapter.getJdbcTypeNameMap().keySet());
        return al;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initMaps() {
        JavaSqlType<?>[] javaSqlTypeArray = jdbcTypes;
        synchronized (jdbcTypes) {
            if (javaSqlTypeNameMap == null) {
                javaSqlTypeMap = new HashMap();
                javaSqlTypeNameMap = new HashMap();
                for (JavaSqlType<?> jst : jdbcTypes) {
                    javaSqlTypeMap.put(new Integer(jst.getJavaSqlType()), jst);
                    javaSqlTypeNameMap.put(jst.getJavaSqlTypeName(), jst);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static HashMap<Integer, JavaSqlType<?>> getJdbcTypeMap() {
        if (javaSqlTypeMap == null) {
            JdbcCpoMetaAdapter.initMaps();
        }
        return javaSqlTypeMap;
    }

    private static HashMap<String, JavaSqlType<?>> getJdbcTypeNameMap() {
        if (javaSqlTypeNameMap == null) {
            JdbcCpoMetaAdapter.initMaps();
        }
        return javaSqlTypeNameMap;
    }
}

