/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.SortedMap;
import javax.sql.CommonDataSource;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.helper.CpoClassLoader;
import org.synchronoss.cpo.helper.ExceptionHelper;
import org.synchronoss.cpo.jdbc.AbstractJdbcDataSource;

public class ClassJdbcDataSourceInfo
extends AbstractJdbcDataSource
implements ConnectionEventListener {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ConnectionPoolDataSource poolDataSource = null;
    private String className = null;
    private SortedMap<String, String> properties = null;
    private final Object LOCK = new Object();
    private Queue<PooledConnection> freeConnections = new LinkedList<PooledConnection>();
    private Queue<PooledConnection> usedConnections = new LinkedList<PooledConnection>();

    public ClassJdbcDataSourceInfo(String className, SortedMap<String, String> properties) throws CpoException {
        super(className, properties);
        this.className = className;
        this.properties = properties;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getPooledConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getPooledConnection() throws SQLException {
        PooledConnection pooledConn;
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.freeConnections.isEmpty()) {
                pooledConn = this.freeConnections.poll();
            } else {
                pooledConn = this.poolDataSource.getPooledConnection();
                pooledConn.addConnectionEventListener(this);
            }
            this.usedConnections.add(pooledConn);
        }
        return pooledConn.getConnection();
    }

    public synchronized String toString() {
        StringBuilder info = new StringBuilder();
        info.append("JdbcDataSource(");
        info.append(this.getDataSourceName());
        info.append(")");
        return info.toString();
    }

    protected DataSource createDataSource() throws CpoException {
        DataSource dataSource = null;
        try {
            Class dsClass = CpoClassLoader.forName((String)this.className);
            CommonDataSource ds = (CommonDataSource)dsClass.newInstance();
            if (ds instanceof ConnectionPoolDataSource) {
                this.poolDataSource = (ConnectionPoolDataSource)ds;
                dataSource = this;
            } else if (ds instanceof DataSource) {
                dataSource = (DataSource)ds;
            } else {
                throw new CpoException(this.className + "is not a DataSource");
            }
            if (this.properties != null) {
                this.setClassProperties(ds, this.properties);
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new CpoException("Could Not Find Class: " + this.className, (Throwable)cnfe);
        }
        catch (InstantiationException ie) {
            throw new CpoException("Could Not Instantiate Class: " + this.className + ":" + ExceptionHelper.getLocalizedMessage((Throwable)ie));
        }
        catch (IllegalAccessException iae) {
            throw new CpoException("Could Not Access Class: " + this.className, (Throwable)iae);
        }
        return dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionClosed(ConnectionEvent ce) {
        Object object = this.LOCK;
        synchronized (object) {
            PooledConnection pc = (PooledConnection)ce.getSource();
            if (this.usedConnections.remove(pc)) {
                this.freeConnections.add(pc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionErrorOccurred(ConnectionEvent ce) {
        Object object = this.LOCK;
        synchronized (object) {
            PooledConnection pc = (PooledConnection)ce.getSource();
            if (!this.usedConnections.remove(pc)) {
                this.freeConnections.remove(pc);
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        for (PooledConnection pc : this.freeConnections) {
            pc.removeConnectionEventListener(this);
            try {
                pc.close();
            }
            catch (SQLException se) {}
        }
        for (PooledConnection pc : this.usedConnections) {
            pc.removeConnectionEventListener(this);
            try {
                pc.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    private void setClassProperties(CommonDataSource ds, SortedMap<String, String> properties) {
        for (String key : properties.keySet()) {
            this.setObjectProperty(ds, key, (String)properties.get(key));
        }
    }

    private void setObjectProperty(Object obj, String key, String value) {
        String methodName = "set" + key.substring(0, 1).toUpperCase() + key.substring(1);
        this.logger.debug("Calling " + methodName + "(" + value + ")");
        try {
            Method setter = obj.getClass().getMethod(methodName, String.class);
            setter.invoke(obj, value);
        }
        catch (NoSuchMethodException nsme) {
            this.logger.error("=========>>> Could not find setter Method:" + methodName + " for property:" + key + " please check the java docs for " + obj.getClass().getName());
        }
        catch (InvocationTargetException ite) {
            this.logger.error("Error Invoking setter Method:" + methodName, (Throwable)ite);
        }
        catch (IllegalAccessException iae) {
            this.logger.error("Error accessing setter Method:" + methodName, (Throwable)iae);
        }
    }
}

