/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc.meta;

import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.core.cpoCoreMeta.CtArgument;
import org.synchronoss.cpo.core.cpoCoreMeta.CtAttribute;
import org.synchronoss.cpo.jdbc.JdbcCpoArgument;
import org.synchronoss.cpo.jdbc.JdbcCpoAttribute;
import org.synchronoss.cpo.jdbc.cpoJdbcMeta.CtJdbcArgument;
import org.synchronoss.cpo.jdbc.cpoJdbcMeta.CtJdbcAttribute;
import org.synchronoss.cpo.meta.AbstractCpoMetaAdapter;
import org.synchronoss.cpo.meta.DataTypeMapEntry;
import org.synchronoss.cpo.meta.DataTypeMapper;
import org.synchronoss.cpo.meta.domain.CpoArgument;
import org.synchronoss.cpo.meta.domain.CpoAttribute;
import org.synchronoss.cpo.parser.BoundExpressionParser;
import org.synchronoss.cpo.parser.ExpressionParser;

public class JdbcCpoMetaAdapter
extends AbstractCpoMetaAdapter {
    private static final Logger logger = LoggerFactory.getLogger(JdbcCpoMetaAdapter.class);
    private static final DataTypeMapEntry<String> defaultDataTypeMapEntry = new DataTypeMapEntry(12, "VARCHAR", String.class);
    private static final DataTypeMapper dataTypeMapper = JdbcCpoMetaAdapter.initDataTypeMapper();

    protected DataTypeMapper getDataTypeMapper() {
        return dataTypeMapper;
    }

    protected void loadCpoAttribute(CpoAttribute cpoAttribute, CtAttribute ctAttribute) {
        super.loadCpoAttribute(cpoAttribute, ctAttribute);
        JdbcCpoAttribute jdbcAttribute = (JdbcCpoAttribute)cpoAttribute;
        CtJdbcAttribute ctJdbcAttribute = (CtJdbcAttribute)ctAttribute;
        jdbcAttribute.setDbTable(ctJdbcAttribute.getDbTable());
        jdbcAttribute.setDbColumn(ctJdbcAttribute.getDbColumn());
    }

    protected void loadCpoArgument(CpoArgument cpoArgument, CtArgument ctArgument) {
        super.loadCpoArgument(cpoArgument, ctArgument);
        JdbcCpoArgument jdbcArgument = (JdbcCpoArgument)cpoArgument;
        CtJdbcArgument ctJdbcArgument = (CtJdbcArgument)ctArgument;
        jdbcArgument.setScope(ctJdbcArgument.getScope().toString());
        jdbcArgument.setTypeInfo(ctJdbcArgument.getTypeInfo());
    }

    protected CpoAttribute createCpoAttribute() {
        return new JdbcCpoAttribute();
    }

    protected CpoArgument createCpoArgument() {
        return new JdbcCpoArgument();
    }

    public ExpressionParser getExpressionParser() {
        return new BoundExpressionParser();
    }

    public List<String> getAllowableDataTypes() {
        return dataTypeMapper.getDataTypeNames();
    }

    private static DataTypeMapper initDataTypeMapper() {
        logger.debug("Initializing the DataMapper");
        DataTypeMapper dataTypeMapper = new DataTypeMapper(defaultDataTypeMapEntry);
        dataTypeMapper.addDataTypeEntry(new DataTypeMapEntry(1, "CHAR", String.class));
        dataTypeMapper.addDataTypeEntry(new DataTypeMapEntry(-1, "LONGVARCHAR", String.class));
        dataTypeMapper.addDataTypeEntry(defaultDataTypeMapEntry);
        dataTypeMapper.addDataTypeEntry(new DataTypeMapEntry(3, "DECIMAL", BigDecimal.class));
        dataTypeMapper.addDataTypeEntry(new DataTypeMapEntry(2, "NUMERIC", BigDecimal.class));
        dataTypeMapper.addDataTypeEntry(new DataTypeMapEntry(-6, "TINYINT", Byte.TYPE));
        dataTypeMapper.addDataTypeEntry(new DataTypeMapEntry(5, "SMALLINT", Short.TYPE));
        dataTypeMapper.addDataTypeEntry(new DataTypeMapEntry(4, "INTEGER", Integer.TYPE));
        dataTypeMapper.addDataTypeEntry(new DataTypeMapEntry(-5, "BIGINT", Long.TYPE));
        dataTypeMapper.addDataTypeEntry(new DataTypeMapEntry(7, "REAL", Float.TYPE));
        dataTypeMapper.addDataTypeEntry(new DataTypeMapEntry(6, "FLOAT", Double.TYPE));
        dataTypeMapper.addDataTypeEntry(new DataTypeMapEntry(8, "DOUBLE", Double.TYPE));
        dataTypeMapper.addDataTypeEntry(new DataTypeMapEntry(-2, "BINARY", byte[].class));
        dataTypeMapper.addDataTypeEntry(new DataTypeMapEntry(-3, "VARBINARY", byte[].class));
        dataTypeMapper.addDataTypeEntry(new DataTypeMapEntry(-4, "LONGVARBINARY", byte[].class));
        dataTypeMapper.addDataTypeEntry(new DataTypeMapEntry(91, "DATE", Date.class));
        dataTypeMapper.addDataTypeEntry(new DataTypeMapEntry(92, "TIME", Time.class));
        dataTypeMapper.addDataTypeEntry(new DataTypeMapEntry(93, "TIMESTAMP", Timestamp.class));
        dataTypeMapper.addDataTypeEntry(new DataTypeMapEntry(2005, "CLOB", Clob.class));
        dataTypeMapper.addDataTypeEntry(new DataTypeMapEntry(2004, "BLOB", Blob.class));
        dataTypeMapper.addDataTypeEntry(new DataTypeMapEntry(2003, "ARRAY", Array.class));
        dataTypeMapper.addDataTypeEntry(new DataTypeMapEntry(2006, "REF", Ref.class));
        dataTypeMapper.addDataTypeEntry(new DataTypeMapEntry(2001, "DISTINCT", Object.class));
        dataTypeMapper.addDataTypeEntry(new DataTypeMapEntry(2002, "STRUCT", Object.class));
        dataTypeMapper.addDataTypeEntry(new DataTypeMapEntry(1111, "OTHER", Object.class));
        dataTypeMapper.addDataTypeEntry(new DataTypeMapEntry(2000, "JAVA_OBJECT", Object.class));
        dataTypeMapper.addDataTypeEntry(new DataTypeMapEntry(70, "DATALINK", URL.class));
        dataTypeMapper.addDataTypeEntry(new DataTypeMapEntry(-7, "BIT", Boolean.TYPE));
        dataTypeMapper.addDataTypeEntry(new DataTypeMapEntry(16, "BOOLEAN", Boolean.TYPE));
        dataTypeMapper.addDataTypeEntry(new DataTypeMapEntry(100, "VARCHAR_IGNORECASE", String.class));
        logger.debug("Returning the DataMapper");
        return dataTypeMapper;
    }
}

