/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.BindableCpoOrderBy;
import org.synchronoss.cpo.CpoAdapter;
import org.synchronoss.cpo.CpoArrayResultSet;
import org.synchronoss.cpo.CpoBaseAdapter;
import org.synchronoss.cpo.CpoBlockingResultSet;
import org.synchronoss.cpo.CpoData;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.CpoNativeFunction;
import org.synchronoss.cpo.CpoOrderBy;
import org.synchronoss.cpo.CpoResultSet;
import org.synchronoss.cpo.CpoTrxAdapter;
import org.synchronoss.cpo.CpoWhere;
import org.synchronoss.cpo.DataSourceInfo;
import org.synchronoss.cpo.helper.ExceptionHelper;
import org.synchronoss.cpo.jdbc.CallableStatementCpoData;
import org.synchronoss.cpo.jdbc.JdbcCallableStatementFactory;
import org.synchronoss.cpo.jdbc.JdbcCpoArgument;
import org.synchronoss.cpo.jdbc.JdbcCpoAttribute;
import org.synchronoss.cpo.jdbc.JdbcCpoTrxAdapter;
import org.synchronoss.cpo.jdbc.JdbcCpoWhere;
import org.synchronoss.cpo.jdbc.JdbcPreparedStatementFactory;
import org.synchronoss.cpo.jdbc.meta.JdbcCpoMetaDescriptor;
import org.synchronoss.cpo.jdbc.meta.JdbcMethodMapper;
import org.synchronoss.cpo.meta.CpoMetaDescriptor;
import org.synchronoss.cpo.meta.DataTypeMapEntry;
import org.synchronoss.cpo.meta.ResultSetCpoData;
import org.synchronoss.cpo.meta.domain.CpoArgument;
import org.synchronoss.cpo.meta.domain.CpoAttribute;
import org.synchronoss.cpo.meta.domain.CpoClass;
import org.synchronoss.cpo.meta.domain.CpoFunction;

public class JdbcCpoAdapter
extends CpoBaseAdapter<DataSource> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(JdbcCpoAdapter.class);
    private Context context_ = null;
    private boolean invalidReadConnection_ = false;
    private boolean batchUpdatesSupported_ = false;
    private JdbcCpoMetaDescriptor metaDescriptor = null;

    protected JdbcCpoAdapter() {
    }

    protected JdbcCpoAdapter(JdbcCpoMetaDescriptor metaDescriptor, DataSourceInfo<DataSource> jdsiTrx) throws CpoException {
        this.metaDescriptor = metaDescriptor;
        this.setWriteDataSource(jdsiTrx.getDataSource());
        this.setReadDataSource(jdsiTrx.getDataSource());
        this.setDataSourceName(jdsiTrx.getDataSourceName());
        this.processDatabaseMetaData();
    }

    protected JdbcCpoAdapter(JdbcCpoMetaDescriptor metaDescriptor, DataSourceInfo<DataSource> jdsiWrite, DataSourceInfo<DataSource> jdsiRead) throws CpoException {
        this.metaDescriptor = metaDescriptor;
        this.setWriteDataSource(jdsiWrite.getDataSource());
        this.setReadDataSource(jdsiRead.getDataSource());
        this.setDataSourceName(jdsiWrite.getDataSourceName());
        this.processDatabaseMetaData();
    }

    protected JdbcCpoAdapter(JdbcCpoMetaDescriptor metaDescriptor, boolean batchSupported, String dataSourceName) throws CpoException {
        this.metaDescriptor = metaDescriptor;
        this.batchUpdatesSupported_ = batchSupported;
        this.setDataSourceName(dataSourceName);
    }

    private void processDatabaseMetaData() throws CpoException {
        Connection c = null;
        try {
            c = this.getWriteConnection();
            DatabaseMetaData dmd = c.getMetaData();
            this.batchUpdatesSupported_ = dmd.supportsBatchUpdates();
            this.closeConnection(c);
        }
        catch (Throwable t) {
            logger.error(ExceptionHelper.getLocalizedMessage((Throwable)t), t);
            throw new CpoException("Could Not Retrieve Database Meta Data", t);
        }
        finally {
            this.closeConnection(c);
        }
    }

    public static JdbcCpoAdapter getInstance(JdbcCpoMetaDescriptor metaDescriptor, DataSourceInfo jdsiTrx) throws CpoException {
        String adapterKey = (Object)((Object)metaDescriptor) + ":" + jdsiTrx.getDataSourceName();
        JdbcCpoAdapter adapter = (JdbcCpoAdapter)JdbcCpoAdapter.findCpoAdapter((String)adapterKey);
        if (adapter == null) {
            adapter = new JdbcCpoAdapter(metaDescriptor, (DataSourceInfo<DataSource>)jdsiTrx);
            JdbcCpoAdapter.addCpoAdapter((String)adapterKey, (CpoAdapter)adapter);
        }
        return adapter;
    }

    public static JdbcCpoAdapter getInstance(JdbcCpoMetaDescriptor metaDescriptor, DataSourceInfo jdsiWrite, DataSourceInfo jdsiRead) throws CpoException {
        String adapterKey = (Object)((Object)metaDescriptor) + ":" + jdsiWrite.getDataSourceName() + ":" + jdsiRead.getDataSourceName();
        JdbcCpoAdapter adapter = (JdbcCpoAdapter)JdbcCpoAdapter.findCpoAdapter((String)adapterKey);
        if (adapter == null) {
            adapter = new JdbcCpoAdapter(metaDescriptor, (DataSourceInfo<DataSource>)jdsiWrite, (DataSourceInfo<DataSource>)jdsiRead);
            JdbcCpoAdapter.addCpoAdapter((String)adapterKey, (CpoAdapter)adapter);
        }
        return adapter;
    }

    public <T> long insertObject(T obj) throws CpoException {
        return this.processUpdateGroup(obj, CREATE_GROUP, null, null, null, null);
    }

    public <T> long insertObject(String name, T obj) throws CpoException {
        return this.processUpdateGroup(obj, CREATE_GROUP, name, null, null, null);
    }

    public <T> long insertObject(String name, T obj, Collection<CpoWhere> wheres, Collection<CpoOrderBy> orderBy, Collection<CpoNativeFunction> nativeExpressions) throws CpoException {
        return this.processUpdateGroup(obj, CREATE_GROUP, name, wheres, orderBy, nativeExpressions);
    }

    public <T> long insertObjects(Collection<T> coll) throws CpoException {
        return this.processUpdateGroup(coll, CREATE_GROUP, (String)null, (Collection<CpoWhere>)null, (Collection<CpoOrderBy>)null, (Collection<CpoNativeFunction>)null);
    }

    public <T> long insertObjects(String name, Collection<T> coll) throws CpoException {
        return this.processUpdateGroup(coll, CREATE_GROUP, name, (Collection<CpoWhere>)null, (Collection<CpoOrderBy>)null, (Collection<CpoNativeFunction>)null);
    }

    public <T> long insertObjects(String name, Collection<T> coll, Collection<CpoWhere> wheres, Collection<CpoOrderBy> orderBy, Collection<CpoNativeFunction> nativeExpressions) throws CpoException {
        return this.processUpdateGroup(coll, CREATE_GROUP, name, wheres, orderBy, nativeExpressions);
    }

    public <T> long deleteObject(T obj) throws CpoException {
        return this.processUpdateGroup(obj, DELETE_GROUP, null, null, null, null);
    }

    public <T> long deleteObject(String name, T obj) throws CpoException {
        return this.processUpdateGroup(obj, DELETE_GROUP, name, null, null, null);
    }

    public <T> long deleteObject(String name, T obj, Collection<CpoWhere> wheres, Collection<CpoOrderBy> orderBy, Collection<CpoNativeFunction> nativeExpressions) throws CpoException {
        return this.processUpdateGroup(obj, DELETE_GROUP, name, wheres, orderBy, nativeExpressions);
    }

    public <T> long deleteObjects(Collection<T> coll) throws CpoException {
        return this.processUpdateGroup(coll, DELETE_GROUP, (String)null, (Collection<CpoWhere>)null, (Collection<CpoOrderBy>)null, (Collection<CpoNativeFunction>)null);
    }

    public <T> long deleteObjects(String name, Collection<T> coll) throws CpoException {
        return this.processUpdateGroup(coll, DELETE_GROUP, name, (Collection<CpoWhere>)null, (Collection<CpoOrderBy>)null, (Collection<CpoNativeFunction>)null);
    }

    public <T> long deleteObjects(String name, Collection<T> coll, Collection<CpoWhere> wheres, Collection<CpoOrderBy> orderBy, Collection<CpoNativeFunction> nativeExpressions) throws CpoException {
        return this.processUpdateGroup(coll, DELETE_GROUP, name, wheres, orderBy, nativeExpressions);
    }

    public <T> T executeObject(T object) throws CpoException {
        return this.processExecuteGroup(null, object, object);
    }

    public <T> T executeObject(String name, T object) throws CpoException {
        return this.processExecuteGroup(name, object, object);
    }

    public <T, C> T executeObject(String name, C criteria, T result) throws CpoException {
        return this.processExecuteGroup(name, criteria, result);
    }

    public <T> long existsObject(T obj) throws CpoException {
        return this.existsObject(null, obj);
    }

    public <T> long existsObject(String name, T obj) throws CpoException {
        return this.existsObject(name, obj, null);
    }

    public <T> long existsObject(String name, T obj, Collection<CpoWhere> wheres) throws CpoException {
        Connection c = null;
        long objCount = -1L;
        try {
            c = this.getReadConnection();
            objCount = this.existsObject(name, obj, c, wheres);
        }
        catch (Exception e) {
            throw new CpoException("existsObjects(String, Object) failed", (Throwable)e);
        }
        finally {
            this.closeConnection(c);
        }
        return objCount;
    }

    protected <T> long existsObject(String name, T obj, Connection con, Collection<CpoWhere> wheres) throws CpoException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        long objCount = 0L;
        Logger localLogger = logger;
        if (obj == null) {
            throw new CpoException("NULL Object passed into existsObject");
        }
        try {
            CpoClass cpoClass = this.metaDescriptor.getMetaClass(obj);
            List cpoFunctions = cpoClass.getFunctionGroup(EXIST_GROUP, name).getFunctions();
            localLogger = LoggerFactory.getLogger((Class)cpoClass.getMetaClass());
            for (CpoFunction cpoFunction : cpoFunctions) {
                localLogger.info(cpoFunction.getExpression());
                JdbcPreparedStatementFactory jpsf = new JdbcPreparedStatementFactory(con, this, cpoClass, cpoFunction, obj, wheres, null, null);
                ps = jpsf.getPreparedStatement();
                long qCount = 0L;
                rs = ps.executeQuery();
                jpsf.release();
                ResultSetMetaData rsmd = rs.getMetaData();
                if (rsmd.getColumnCount() == 1 && rs.next()) {
                    try {
                        qCount = rs.getLong(1);
                    }
                    catch (Exception e) {
                        qCount = 1L;
                    }
                    if (rs.next()) {
                        qCount = 2L;
                    }
                }
                while (rs.next()) {
                    ++qCount;
                }
                objCount += qCount;
                rs.close();
                ps.close();
                rs = null;
                ps = null;
            }
        }
        catch (SQLException e) {
            String msg = "existsObject(name, obj, con) failed:";
            localLogger.error(msg, (Throwable)e);
            throw new CpoException(msg, (Throwable)e);
        }
        finally {
            this.resultSetClose(rs);
            this.statementClose(ps);
        }
        return objCount;
    }

    public CpoOrderBy newOrderBy(String attribute, boolean ascending) throws CpoException {
        return new BindableCpoOrderBy(attribute, ascending);
    }

    public CpoOrderBy newOrderBy(String marker, String attribute, boolean ascending) throws CpoException {
        return new BindableCpoOrderBy(marker, attribute, ascending);
    }

    public CpoOrderBy newOrderBy(String attribute, boolean ascending, String function) throws CpoException {
        return new BindableCpoOrderBy(attribute, ascending, function);
    }

    public CpoOrderBy newOrderBy(String marker, String attribute, boolean ascending, String function) throws CpoException {
        return new BindableCpoOrderBy(marker, attribute, ascending, function);
    }

    public CpoWhere newWhere() throws CpoException {
        return new JdbcCpoWhere();
    }

    public <T> CpoWhere newWhere(int logical, String attr, int comp, T value) throws CpoException {
        return new JdbcCpoWhere(logical, attr, comp, value);
    }

    public <T> CpoWhere newWhere(int logical, String attr, int comp, T value, boolean not) throws CpoException {
        return new JdbcCpoWhere(logical, attr, comp, value, not);
    }

    public <T> long persistObject(T obj) throws CpoException {
        return this.processUpdateGroup(obj, PERSIST_GROUP, null, null, null, null);
    }

    public <T> long persistObject(String name, T obj) throws CpoException {
        return this.processUpdateGroup(obj, PERSIST_GROUP, name, null, null, null);
    }

    public <T> long persistObjects(Collection<T> coll) throws CpoException {
        return this.processUpdateGroup(coll, PERSIST_GROUP, (String)null, (Collection<CpoWhere>)null, (Collection<CpoOrderBy>)null, (Collection<CpoNativeFunction>)null);
    }

    public <T> long persistObjects(String name, Collection<T> coll) throws CpoException {
        return this.processUpdateGroup(coll, PERSIST_GROUP, name, (Collection<CpoWhere>)null, (Collection<CpoOrderBy>)null, (Collection<CpoNativeFunction>)null);
    }

    public <T> T retrieveBean(T bean) throws CpoException {
        T o = this.processSelectGroup(bean, null, null, null, null);
        return o;
    }

    public <T> T retrieveBean(String name, T bean) throws CpoException {
        T o = this.processSelectGroup(bean, name, null, null, null);
        return o;
    }

    public <T> T retrieveBean(String name, T bean, Collection<CpoWhere> wheres, Collection<CpoOrderBy> orderBy, Collection<CpoNativeFunction> nativeExpressions) throws CpoException {
        T o = this.processSelectGroup(bean, name, wheres, orderBy, nativeExpressions);
        return o;
    }

    public <T, C> T retrieveBean(String name, C criteria, T result, Collection<CpoWhere> wheres, Collection<CpoOrderBy> orderBy) throws CpoException {
        return this.retrieveBean(name, criteria, result, wheres, orderBy, null);
    }

    public <T, C> T retrieveBean(String name, C criteria, T result, Collection<CpoWhere> wheres, Collection<CpoOrderBy> orderBy, Collection<CpoNativeFunction> nativeExpressions) throws CpoException {
        Iterator<T> it = this.processSelectGroup(name, criteria, result, wheres, orderBy, nativeExpressions, true).iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public <C> List<C> retrieveBeans(String name, C criteria) throws CpoException {
        return this.processSelectGroup(name, criteria, criteria, null, null, null, false);
    }

    public <C> List<C> retrieveBeans(String name, C criteria, CpoWhere where, Collection<CpoOrderBy> orderBy) throws CpoException {
        ArrayList<CpoWhere> wheres = null;
        if (where != null) {
            wheres = new ArrayList<CpoWhere>();
            wheres.add(where);
        }
        return this.processSelectGroup(name, criteria, criteria, wheres, orderBy, null, false);
    }

    public <C> List<C> retrieveBeans(String name, C criteria, Collection<CpoWhere> wheres, Collection<CpoOrderBy> orderBy) throws CpoException {
        return this.processSelectGroup(name, criteria, criteria, wheres, orderBy, null, false);
    }

    public <C> List<C> retrieveBeans(String name, C criteria, Collection<CpoOrderBy> orderBy) throws CpoException {
        return this.processSelectGroup(name, criteria, criteria, null, orderBy, null, false);
    }

    public <T, C> List<T> retrieveBeans(String name, C criteria, T result) throws CpoException {
        return this.processSelectGroup(name, criteria, result, null, null, null, false);
    }

    public <T, C> List<T> retrieveBeans(String name, C criteria, T result, CpoWhere where, Collection<CpoOrderBy> orderBy) throws CpoException {
        ArrayList<CpoWhere> wheres = null;
        if (where != null) {
            wheres = new ArrayList<CpoWhere>();
            wheres.add(where);
        }
        return this.processSelectGroup(name, criteria, result, wheres, orderBy, null, false);
    }

    public <T, C> List<T> retrieveBeans(String name, C criteria, T result, Collection<CpoWhere> wheres, Collection<CpoOrderBy> orderBy) throws CpoException {
        return this.processSelectGroup(name, criteria, result, wheres, orderBy, null, false);
    }

    public <T, C> List<T> retrieveBeans(String name, C criteria, T result, Collection<CpoWhere> wheres, Collection<CpoOrderBy> orderBy, Collection<CpoNativeFunction> nativeExpressions) throws CpoException {
        return this.processSelectGroup(name, criteria, result, wheres, orderBy, nativeExpressions, false);
    }

    public <T, C> CpoResultSet<T> retrieveBeans(String name, C criteria, T result, Collection<CpoWhere> wheres, Collection<CpoOrderBy> orderBy, Collection<CpoNativeFunction> nativeExpressions, int queueSize) throws CpoException {
        CpoBlockingResultSet resultSet = new CpoBlockingResultSet(queueSize);
        CpoBaseAdapter.RetrieverThread retrieverThread = new CpoBaseAdapter.RetrieverThread((CpoBaseAdapter)this, name, criteria, result, wheres, orderBy, nativeExpressions, false, resultSet);
        retrieverThread.start();
        return resultSet;
    }

    public <T> long updateObject(T obj) throws CpoException {
        return this.processUpdateGroup(obj, UPDATE_GROUP, null, null, null, null);
    }

    public <T> long updateObject(String name, T obj) throws CpoException {
        return this.processUpdateGroup(obj, UPDATE_GROUP, name, null, null, null);
    }

    public <T> long updateObject(String name, T obj, Collection<CpoWhere> wheres, Collection<CpoOrderBy> orderBy, Collection<CpoNativeFunction> nativeExpressions) throws CpoException {
        return this.processUpdateGroup(obj, UPDATE_GROUP, name, wheres, orderBy, nativeExpressions);
    }

    public <T> long updateObjects(Collection<T> coll) throws CpoException {
        return this.processUpdateGroup(coll, UPDATE_GROUP, (String)null, (Collection<CpoWhere>)null, (Collection<CpoOrderBy>)null, (Collection<CpoNativeFunction>)null);
    }

    public <T> long updateObjects(String name, Collection<T> coll) throws CpoException {
        return this.processUpdateGroup(coll, UPDATE_GROUP, name, (Collection<CpoWhere>)null, (Collection<CpoOrderBy>)null, (Collection<CpoNativeFunction>)null);
    }

    public <T> long updateObjects(String name, Collection<T> coll, Collection<CpoWhere> wheres, Collection<CpoOrderBy> orderBy, Collection<CpoNativeFunction> nativeExpressions) throws CpoException {
        return this.processUpdateGroup(coll, UPDATE_GROUP, name, wheres, orderBy, nativeExpressions);
    }

    protected void setContext(Context context) throws CpoException {
        try {
            this.context_ = context == null ? new InitialContext() : context;
        }
        catch (NamingException e) {
            throw new CpoException("Error setting Context", (Throwable)e);
        }
    }

    protected Context getContext() {
        return this.context_;
    }

    protected <T> String getGroupType(T obj, String type, String name, Connection c) throws CpoException {
        String retType = type;
        if (PERSIST_GROUP.equals(retType)) {
            long objCount = this.existsObject(name, obj, c, null);
            if (objCount == 0L) {
                retType = CREATE_GROUP;
            } else if (objCount == 1L) {
                retType = UPDATE_GROUP;
            } else {
                throw new CpoException("Persist can only UPDATE one record. Your EXISTS function returned 2 or more.");
            }
        }
        return retType;
    }

    protected Connection getReadConnection() throws CpoException {
        Connection connection = this.getStaticConnection();
        if (connection == null) {
            try {
                connection = !this.invalidReadConnection_ ? ((DataSource)this.getReadDataSource()).getConnection() : ((DataSource)this.getWriteDataSource()).getConnection();
                connection.setAutoCommit(false);
            }
            catch (Exception e) {
                this.invalidReadConnection_ = true;
                String msg = "getReadConnection(): failed";
                logger.error(msg, (Throwable)e);
                try {
                    connection = ((DataSource)this.getWriteDataSource()).getConnection();
                    connection.setAutoCommit(false);
                }
                catch (SQLException e2) {
                    msg = "getWriteConnection(): failed";
                    logger.error(msg, (Throwable)e2);
                    throw new CpoException(msg, (Throwable)e2);
                }
            }
        }
        return connection;
    }

    protected Connection getWriteConnection() throws CpoException {
        Connection connection = this.getStaticConnection();
        if (connection == null) {
            try {
                connection = ((DataSource)this.getWriteDataSource()).getConnection();
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                String msg = "getWriteConnection(): failed";
                logger.error(msg, (Throwable)e);
                throw new CpoException(msg, (Throwable)e);
            }
        }
        return connection;
    }

    protected Connection getStaticConnection() throws CpoException {
        return null;
    }

    protected boolean isStaticConnection(Connection c) {
        return false;
    }

    protected void setStaticConnection(Connection c) {
    }

    protected void closeConnection(Connection connection) {
        block3: {
            try {
                this.clearConnectionBusy(connection);
                if (connection != null && !this.isStaticConnection(connection) && !connection.isClosed()) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                if (!logger.isTraceEnabled()) break block3;
                logger.trace(e.getMessage());
            }
        }
    }

    protected void commitConnection(Connection connection) {
        block3: {
            try {
                if (connection != null && !this.isStaticConnection(connection)) {
                    connection.commit();
                }
            }
            catch (SQLException e) {
                if (!logger.isTraceEnabled()) break block3;
                logger.trace(e.getMessage());
            }
        }
    }

    protected void rollbackConnection(Connection connection) {
        block5: {
            try {
                if (connection != null && !this.isStaticConnection(connection)) {
                    connection.rollback();
                }
            }
            catch (SQLException se) {
                if (logger.isTraceEnabled()) {
                    logger.trace(se.getMessage());
                }
            }
            catch (Exception e) {
                if (!logger.isTraceEnabled()) break block5;
                logger.trace(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T, C> T processExecuteGroup(String name, C criteria, T result) throws CpoException {
        Connection c = null;
        T obj = null;
        try {
            c = this.getWriteConnection();
            obj = this.processExecuteGroup(name, criteria, result, c);
            this.commitConnection(c);
        }
        catch (Exception e) {
            this.rollbackConnection(c);
            ExceptionHelper.reThrowCpoException((Throwable)e, (String)"processExecuteGroup(String name, Object criteria, Object result) failed");
        }
        finally {
            this.closeConnection(c);
        }
        return obj;
    }

    protected <T, C> T processExecuteGroup(String name, C criteria, T result, Connection conn) throws CpoException {
        CallableStatement cstmt = null;
        T returnObject = null;
        Logger localLogger = criteria == null ? logger : LoggerFactory.getLogger(criteria.getClass());
        JdbcCallableStatementFactory jcsf = null;
        if (criteria == null || result == null) {
            throw new CpoException("NULL Object passed into executeObject");
        }
        try {
            CpoClass criteriaClass = this.metaDescriptor.getMetaClass(criteria);
            List functions = criteriaClass.getFunctionGroup(EXECUTE_GROUP, name).getFunctions();
            localLogger.info("===================processExecuteGroup (" + name + ") Count<" + functions.size() + ">=========================");
            try {
                returnObject = (T)result.getClass().newInstance();
            }
            catch (IllegalAccessException iae) {
                throw new CpoException("Unable to access the constructor of the Return Object", (Throwable)iae);
            }
            catch (InstantiationException iae) {
                throw new CpoException("Unable to instantiate Return Object", (Throwable)iae);
            }
            for (CpoFunction function : functions) {
                localLogger.debug("Executing Call:" + criteriaClass.getName() + ":" + name);
                jcsf = new JdbcCallableStatementFactory(conn, this, function, criteria);
                cstmt = jcsf.getCallableStatement();
                cstmt.execute();
                jcsf.release();
                localLogger.debug("Processing Call:" + criteriaClass.getName() + ":" + name);
                int j = 1;
                for (CpoArgument cpoArgument : jcsf.getOutArguments()) {
                    JdbcCpoArgument jdbcArgument = (JdbcCpoArgument)cpoArgument;
                    if (jdbcArgument.isOutParameter()) {
                        JdbcCpoAttribute jdbcAttribute = jdbcArgument.getAttribute();
                        jdbcAttribute.invokeSetter(returnObject, (CpoData)new CallableStatementCpoData(cstmt, (CpoAttribute)jdbcAttribute, j));
                    }
                    ++j;
                }
                cstmt.close();
            }
        }
        catch (Throwable t) {
            String msg = "ProcessExecuteGroup(String name, Object criteria, Object result, Connection conn) failed. SQL=";
            localLogger.error(msg, t);
            throw new CpoException(msg, t);
        }
        finally {
            this.statementClose(cstmt);
            if (jcsf != null) {
                jcsf.release();
            }
        }
        return returnObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T processSelectGroup(T obj, String groupName, Collection<CpoWhere> wheres, Collection<CpoOrderBy> orderBy, Collection<CpoNativeFunction> nativeExpressions) throws CpoException {
        Connection c = null;
        T result = null;
        try {
            c = this.getReadConnection();
            result = this.processSelectGroup(obj, groupName, wheres, orderBy, nativeExpressions, c);
            this.commitConnection(c);
        }
        catch (Exception e) {
            this.rollbackConnection(c);
            ExceptionHelper.reThrowCpoException((Throwable)e, (String)"processSelectGroup(Object obj, String groupName) failed");
        }
        finally {
            this.closeConnection(c);
        }
        return result;
    }

    protected <T> T processSelectGroup(T obj, String groupName, Collection<CpoWhere> wheres, Collection<CpoOrderBy> orderBy, Collection<CpoNativeFunction> nativeExpressions, Connection con) throws CpoException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        T criteriaObj = obj;
        boolean recordsExist = false;
        Logger localLogger = obj == null ? logger : LoggerFactory.getLogger(obj.getClass());
        int recordCount = 0;
        int attributesSet = 0;
        T rObj = null;
        if (obj == null) {
            throw new CpoException("NULL Object passed into retrieveBean");
        }
        try {
            CpoClass cpoClass = this.metaDescriptor.getMetaClass(criteriaObj);
            List functions = cpoClass.getFunctionGroup(RETRIEVE_GROUP, groupName).getFunctions();
            localLogger.info("=================== Class=<" + criteriaObj.getClass() + "> Type=<" + RETRIEVE_GROUP + "> Name=<" + groupName + "> =========================");
            try {
                rObj = (T)obj.getClass().newInstance();
            }
            catch (IllegalAccessException iae) {
                if (obj != null) {
                    localLogger.error("=================== Could not access default constructor for Class=<" + obj.getClass() + "> ==================");
                } else {
                    localLogger.error("=================== Could not access default constructor for class ==================");
                }
                throw new CpoException("Unable to access the constructor of the Return Object", (Throwable)iae);
            }
            catch (InstantiationException iae) {
                throw new CpoException("Unable to instantiate Return Object", (Throwable)iae);
            }
            for (CpoFunction cpoFunction : functions) {
                JdbcPreparedStatementFactory jpsf = new JdbcPreparedStatementFactory(con, this, cpoClass, cpoFunction, criteriaObj, wheres, orderBy, nativeExpressions);
                ps = jpsf.getPreparedStatement();
                rs = ps.executeQuery();
                jpsf.release();
                if (rs.isBeforeFirst()) {
                    JdbcCpoAttribute attribute;
                    ResultSetMetaData rsmd = rs.getMetaData();
                    if (rsmd.getColumnCount() == 2 && "CPO_ATTRIBUTE".equalsIgnoreCase(rsmd.getColumnLabel(1)) && "CPO_VALUE".equalsIgnoreCase(rsmd.getColumnLabel(2))) {
                        while (rs.next()) {
                            recordsExist = true;
                            ++recordCount;
                            attribute = (JdbcCpoAttribute)cpoClass.getAttributeData(rs.getString(1));
                            if (attribute == null) continue;
                            attribute.invokeSetter(rObj, (CpoData)new ResultSetCpoData(JdbcMethodMapper.getMethodMapper(), (Object)rs, (CpoAttribute)attribute, 2));
                            ++attributesSet;
                        }
                    } else if (rs.next()) {
                        recordsExist = true;
                        ++recordCount;
                        for (int k = 1; k <= rsmd.getColumnCount(); ++k) {
                            attribute = (JdbcCpoAttribute)cpoClass.getAttributeData(rsmd.getColumnLabel(k));
                            if (attribute == null) continue;
                            attribute.invokeSetter(rObj, (CpoData)new ResultSetCpoData(JdbcMethodMapper.getMethodMapper(), (Object)rs, (CpoAttribute)attribute, k));
                            ++attributesSet;
                        }
                        if (rs.next()) {
                            String msg = "ProcessSelectGroup(Object, String) failed: Multiple Records Returned";
                            localLogger.error(msg);
                            throw new CpoException(msg);
                        }
                    }
                    criteriaObj = rObj;
                }
                rs.close();
                rs = null;
                ps.close();
                ps = null;
            }
            if (!recordsExist) {
                rObj = null;
                localLogger.info("=================== 0 Records - 0 Attributes - Class=<" + criteriaObj.getClass() + "> Type=<" + RETRIEVE_GROUP + "> Name=<" + groupName + "> =========================");
            } else {
                localLogger.info("=================== " + recordCount + " Records - " + attributesSet + " Attributes - Class=<" + criteriaObj.getClass() + ">  Type=<" + RETRIEVE_GROUP + "> Name=<" + groupName + "> =========================");
            }
            this.resultSetClose(rs);
            this.statementClose(ps);
        }
        catch (Throwable t) {
            try {
                String msg = "ProcessSeclectGroup(Object) failed: " + ExceptionHelper.getLocalizedMessage((Throwable)t);
                localLogger.error(msg, t);
                rObj = null;
                throw new CpoException(msg, t);
            }
            catch (Throwable throwable) {
                this.resultSetClose(rs);
                this.statementClose(ps);
                throw throwable;
            }
        }
        return rObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T, C> List<T> processSelectGroup(String name, C criteria, T result, Collection<CpoWhere> wheres, Collection<CpoOrderBy> orderBy, Collection<CpoNativeFunction> nativeExpressions, boolean useRetrieve) throws CpoException {
        Connection con = null;
        CpoArrayResultSet resultSet = new CpoArrayResultSet();
        try {
            con = this.getReadConnection();
            this.processSelectGroup(name, criteria, result, wheres, orderBy, nativeExpressions, con, useRetrieve, (CpoResultSet<T>)resultSet);
            this.commitConnection(con);
        }
        catch (Exception e) {
            this.rollbackConnection(con);
            ExceptionHelper.reThrowCpoException((Throwable)e, (String)"processSelectGroup(String name, Object criteria, Object result,CpoWhere where, Collection orderBy, boolean useRetrieve) failed");
        }
        finally {
            this.closeConnection(con);
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T, C> void processSelectGroup(String name, C criteria, T result, Collection<CpoWhere> wheres, Collection<CpoOrderBy> orderBy, Collection<CpoNativeFunction> nativeExpressions, boolean useRetrieve, CpoResultSet<T> resultSet) throws CpoException {
        Connection con = null;
        try {
            con = this.getReadConnection();
            this.processSelectGroup(name, criteria, result, wheres, orderBy, nativeExpressions, con, useRetrieve, resultSet);
            this.commitConnection(con);
        }
        catch (Exception e) {
            this.rollbackConnection(con);
            ExceptionHelper.reThrowCpoException((Throwable)e, (String)"processSelectGroup(String name, Object criteria, Object result,CpoWhere where, Collection orderBy, boolean useRetrieve) failed");
        }
        finally {
            this.closeConnection(con);
        }
    }

    protected <T, C> void processSelectGroup(String name, C criteria, T result, Collection<CpoWhere> wheres, Collection<CpoOrderBy> orderBy, Collection<CpoNativeFunction> nativeExpressions, Connection con, boolean useRetrieve, CpoResultSet<T> resultSet) throws CpoException {
        Logger localLogger = criteria == null ? logger : LoggerFactory.getLogger(criteria.getClass());
        PreparedStatement ps = null;
        ResultSet rs = null;
        if (criteria == null || result == null) {
            throw new CpoException("NULL Object passed into retrieveBean or retrieveBeans");
        }
        try {
            List cpoFunctions;
            CpoClass criteriaClass = this.metaDescriptor.getMetaClass(criteria);
            CpoClass resultClass = this.metaDescriptor.getMetaClass(result);
            if (useRetrieve) {
                localLogger.info("=================== Class=<" + criteria.getClass() + "> Type=<" + RETRIEVE_GROUP + "> Name=<" + name + "> =========================");
                cpoFunctions = criteriaClass.getFunctionGroup(RETRIEVE_GROUP, name).getFunctions();
            } else {
                localLogger.info("=================== Class=<" + criteria.getClass() + "> Type=<" + LIST_GROUP + "> Name=<" + name + "> =========================");
                cpoFunctions = criteriaClass.getFunctionGroup(LIST_GROUP, name).getFunctions();
            }
            for (CpoFunction cpoFunction : cpoFunctions) {
                int k;
                JdbcPreparedStatementFactory jpsf = new JdbcPreparedStatementFactory(con, this, criteriaClass, cpoFunction, criteria, wheres, orderBy, nativeExpressions);
                ps = jpsf.getPreparedStatement();
                if (resultSet.getFetchSize() != -1) {
                    ps.setFetchSize(resultSet.getFetchSize());
                }
                localLogger.debug("Retrieving Records");
                rs = ps.executeQuery();
                jpsf.release();
                localLogger.debug("Processing Records");
                ResultSetMetaData rsmd = rs.getMetaData();
                int columnCount = rsmd.getColumnCount();
                JdbcCpoAttribute[] attributes = new JdbcCpoAttribute[columnCount + 1];
                for (k = 1; k <= columnCount; ++k) {
                    attributes[k] = (JdbcCpoAttribute)resultClass.getAttributeData(rsmd.getColumnLabel(k));
                }
                while (rs.next()) {
                    Object obj;
                    try {
                        obj = result.getClass().newInstance();
                    }
                    catch (IllegalAccessException iae) {
                        if (result != null) {
                            localLogger.error("=================== Could not access default constructor for Class=<" + result.getClass() + "> ==================");
                        } else {
                            localLogger.error("=================== Could not access default constructor for class ==================");
                        }
                        throw new CpoException("Unable to access the constructor of the Return Object", (Throwable)iae);
                    }
                    catch (InstantiationException iae) {
                        throw new CpoException("Unable to instantiate Return Object", (Throwable)iae);
                    }
                    for (k = 1; k <= columnCount; ++k) {
                        if (attributes[k] == null) continue;
                        attributes[k].invokeSetter(obj, (CpoData)new ResultSetCpoData(JdbcMethodMapper.getMethodMapper(), (Object)rs, (CpoAttribute)attributes[k], k));
                    }
                    try {
                        resultSet.put(obj);
                    }
                    catch (InterruptedException e) {
                        localLogger.error("Retriever Thread was interrupted", (Throwable)e);
                        break;
                    }
                }
                this.resultSetClose(rs);
                this.statementClose(ps);
                localLogger.info("=================== " + resultSet.size() + " Records - Class=<" + criteria.getClass() + "> Type=<" + LIST_GROUP + "> Name=<" + name + "> Result=<" + result.getClass() + "> ====================");
            }
        }
        catch (Throwable t) {
            String msg = "ProcessSelectGroup(String name, Object criteria, Object result, CpoWhere where, Collection orderBy, Connection con) failed. Error:";
            localLogger.error(msg, t);
            throw new CpoException(msg, t);
        }
        finally {
            this.resultSetClose(rs);
            this.statementClose(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> long processUpdateGroup(T obj, String groupType, String groupName, Collection<CpoWhere> wheres, Collection<CpoOrderBy> orderBy, Collection<CpoNativeFunction> nativeExpressions) throws CpoException {
        Connection c = null;
        long updateCount = 0L;
        try {
            c = this.getWriteConnection();
            updateCount = this.processUpdateGroup(obj, groupType, groupName, wheres, orderBy, nativeExpressions, c);
            this.commitConnection(c);
        }
        catch (Exception e) {
            this.rollbackConnection(c);
            ExceptionHelper.reThrowCpoException((Throwable)e, (String)"processUdateGroup(Object obj, String groupType, String groupName) failed");
        }
        finally {
            this.closeConnection(c);
        }
        return updateCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <T> long processUpdateGroup(T obj, String groupType, String groupName, Collection<CpoWhere> wheres, Collection<CpoOrderBy> orderBy, Collection<CpoNativeFunction> nativeExpressions, Connection con) throws CpoException {
        Logger localLogger = obj == null ? logger : LoggerFactory.getLogger(obj.getClass());
        PreparedStatement ps = null;
        JdbcPreparedStatementFactory jpsf = null;
        long updateCount = 0L;
        if (obj == null) {
            throw new CpoException("NULL Object passed into insertObject, deleteObject, updateObject, or persistObject");
        }
        try {
            CpoClass cpoClass = this.metaDescriptor.getMetaClass(obj);
            List cpoFunctions = cpoClass.getFunctionGroup(this.getGroupType(obj, groupType, groupName, con), groupName).getFunctions();
            localLogger.info("=================== Class=<" + obj.getClass() + "> Type=<" + groupType + "> Name=<" + groupName + "> =========================");
            int numRows = 0;
            for (CpoFunction cpoFunction : cpoFunctions) {
                jpsf = new JdbcPreparedStatementFactory(con, this, cpoClass, cpoFunction, obj, wheres, orderBy, nativeExpressions);
                ps = jpsf.getPreparedStatement();
                numRows += ps.executeUpdate();
                jpsf.release();
                ps.close();
            }
            localLogger.info("=================== " + numRows + " Updates - Class=<" + obj.getClass() + "> Type=<" + groupType + "> Name=<" + groupName + "> =========================");
            if (numRows > 0) {
                ++updateCount;
            }
            this.statementClose(ps);
            if (jpsf == null) return updateCount;
        }
        catch (Throwable t) {
            try {
                String msg = "ProcessUpdateGroup failed:" + groupType + "," + groupName + "," + obj.getClass().getName();
                localLogger.error(msg, t);
                throw new CpoException(msg, t);
            }
            catch (Throwable throwable) {
                this.statementClose(ps);
                if (jpsf == null) throw throwable;
                jpsf.release();
                throw throwable;
            }
        }
        jpsf.release();
        return updateCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <T> long processBatchUpdateGroup(T[] arr, String groupType, String groupName, Collection<CpoWhere> wheres, Collection<CpoOrderBy> orderBy, Collection<CpoNativeFunction> nativeExpressions, Connection con) throws CpoException {
        PreparedStatement ps = null;
        JdbcPreparedStatementFactory jpsf = null;
        long updateCount = 0L;
        Logger localLogger = logger;
        try {
            CpoClass jmc = this.metaDescriptor.getMetaClass(arr[0]);
            List cpoFunctions = jmc.getFunctionGroup(this.getGroupType(arr[0], groupType, groupName, con), groupName).getFunctions();
            localLogger = LoggerFactory.getLogger((Class)jmc.getMetaClass());
            int numRows = 0;
            if (cpoFunctions.size() == 1) {
                localLogger.info("=================== BATCH - Class=<" + arr[0].getClass() + "> Type=<" + groupType + "> Name=<" + groupName + "> =========================");
                CpoFunction cpoFunction = (CpoFunction)cpoFunctions.get(0);
                jpsf = new JdbcPreparedStatementFactory(con, this, jmc, cpoFunction, arr[0], wheres, orderBy, nativeExpressions);
                ps = jpsf.getPreparedStatement();
                ps.addBatch();
                for (int j = 1; j < arr.length; ++j) {
                    jpsf.setBindValues(jpsf.getBindValues(cpoFunction, arr[j]));
                    ps.addBatch();
                }
                int[] updates = ps.executeBatch();
                jpsf.release();
                ps.close();
                for (int update : updates) {
                    if (update < 0 && update == -2) {
                        ++numRows;
                        continue;
                    }
                    numRows += update;
                }
                localLogger.info("=================== BATCH - " + numRows + " Updates - Class=<" + arr[0].getClass() + "> Type=<" + groupType + "> Name=<" + groupName + "> =========================");
            } else {
                localLogger.info("=================== Class=<" + arr[0].getClass() + "> Type=<" + groupType + "> Name=<" + groupName + "> =========================");
                for (T obj : arr) {
                    for (CpoFunction function : cpoFunctions) {
                        jpsf = new JdbcPreparedStatementFactory(con, this, jmc, function, obj, wheres, orderBy, nativeExpressions);
                        ps = jpsf.getPreparedStatement();
                        numRows += ps.executeUpdate();
                        jpsf.release();
                        ps.close();
                    }
                }
                localLogger.info("=================== " + numRows + " Updates - Class=<" + arr[0].getClass() + "> Type=<" + groupType + "> Name=<" + groupName + "> =========================");
            }
            if (numRows > 0) {
                updateCount = numRows;
            }
            this.statementClose(ps);
            if (jpsf == null) return updateCount;
        }
        catch (Throwable t) {
            try {
                String msg = "ProcessUpdateGroup failed:" + groupType + "," + groupName + "," + arr[0].getClass().getName();
                localLogger.error(msg, t);
                throw new CpoException(msg, t);
            }
            catch (Throwable throwable) {
                this.statementClose(ps);
                if (jpsf == null) throw throwable;
                jpsf.release();
                throw throwable;
            }
        }
        jpsf.release();
        return updateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> long processUpdateGroup(Collection<T> coll, String groupType, String groupName, Collection<CpoWhere> wheres, Collection<CpoOrderBy> orderBy, Collection<CpoNativeFunction> nativeExpressions) throws CpoException {
        Connection c = null;
        long updateCount = 0L;
        try {
            c = this.getWriteConnection();
            updateCount = this.processUpdateGroup(coll, groupType, groupName, wheres, orderBy, nativeExpressions, c);
            this.commitConnection(c);
        }
        catch (Exception e) {
            this.rollbackConnection(c);
            ExceptionHelper.reThrowCpoException((Throwable)e, (String)"processUpdateGroup(Collection coll, String groupType, String groupName) failed");
        }
        finally {
            this.closeConnection(c);
        }
        return updateCount;
    }

    protected <T> long processUpdateGroup(Collection<T> coll, String groupType, String groupName, Collection<CpoWhere> wheres, Collection<CpoOrderBy> orderBy, Collection<CpoNativeFunction> nativeExpressions, Connection con) throws CpoException {
        long updateCount = 0L;
        if (!coll.isEmpty()) {
            Object[] arr = coll.toArray();
            Object obj1 = arr[0];
            boolean allEqual = true;
            for (int i = 1; i < arr.length; ++i) {
                if (obj1.getClass().getName().equals(arr[i].getClass().getName())) continue;
                allEqual = false;
                break;
            }
            if (allEqual && this.batchUpdatesSupported_ && !PERSIST_GROUP.equals(groupType)) {
                updateCount = this.processBatchUpdateGroup(arr, groupType, groupName, wheres, orderBy, nativeExpressions, con);
            } else {
                for (Object obj : arr) {
                    updateCount += this.processUpdateGroup(obj, groupType, groupName, wheres, orderBy, nativeExpressions, con);
                }
            }
        }
        return updateCount;
    }

    public CpoTrxAdapter getCpoTrxAdapter() throws CpoException {
        return new JdbcCpoTrxAdapter(this.metaDescriptor, this.getWriteConnection(), this.batchUpdatesSupported_, this.getDataSourceName());
    }

    protected boolean isConnectionBusy(Connection c) {
        return false;
    }

    protected void setConnectionBusy(Connection c) {
    }

    protected void clearConnectionBusy(Connection c) {
    }

    private void statementClose(Statement s) {
        block3: {
            if (s != null) {
                try {
                    s.close();
                }
                catch (Exception e) {
                    if (!logger.isTraceEnabled()) break block3;
                    logger.trace(e.getMessage());
                }
            }
        }
    }

    private void resultSetClose(ResultSet rs) {
        block3: {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    if (!logger.isTraceEnabled()) break block3;
                    logger.trace(e.getMessage());
                }
            }
        }
    }

    public CpoMetaDescriptor getCpoMetaDescriptor() {
        return this.metaDescriptor;
    }

    public List<CpoAttribute> getCpoAttributes(String expression) throws CpoException {
        ArrayList<CpoAttribute> attributes = new ArrayList<CpoAttribute>();
        if (expression != null && !expression.isEmpty()) {
            Connection c = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                c = this.getWriteConnection();
                ps = c.prepareStatement(expression);
                rs = ps.executeQuery();
                ResultSetMetaData rsmd = rs.getMetaData();
                for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                    JdbcCpoAttribute attribute = new JdbcCpoAttribute();
                    attribute.setDataName(rsmd.getColumnLabel(i));
                    attribute.setDbColumn(rsmd.getColumnName(i));
                    try {
                        attribute.setDbTable(rsmd.getTableName(i));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    DataTypeMapEntry dataTypeMapEntry = this.metaDescriptor.getDataTypeMapEntry(rsmd.getColumnType(i));
                    attribute.setDataType(dataTypeMapEntry.getDataTypeName());
                    attribute.setDataTypeInt(dataTypeMapEntry.getDataTypeInt());
                    attribute.setJavaType(dataTypeMapEntry.getJavaClass().getName());
                    attribute.setJavaName(dataTypeMapEntry.makeJavaName(rsmd.getColumnLabel(i)));
                    attributes.add(attribute);
                }
                this.resultSetClose(rs);
                this.statementClose(ps);
                this.closeConnection(c);
            }
            catch (Throwable t) {
                try {
                    logger.error(ExceptionHelper.getLocalizedMessage((Throwable)t), t);
                    throw new CpoException("Error Generating Attributes", t);
                }
                catch (Throwable throwable) {
                    this.resultSetClose(rs);
                    this.statementClose(ps);
                    this.closeConnection(c);
                    throw throwable;
                }
            }
        }
        return attributes;
    }
}

