/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc.config;

import java.util.Properties;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoAdapter;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.DataSourceInfo;
import org.synchronoss.cpo.config.CpoConfigProcessor;
import org.synchronoss.cpo.core.cpoCoreConfig.CtDataSourceConfig;
import org.synchronoss.cpo.jdbc.AbstractJdbcDataSourceInfo;
import org.synchronoss.cpo.jdbc.ClassJdbcDataSourceInfo;
import org.synchronoss.cpo.jdbc.DriverJdbcDataSourceInfo;
import org.synchronoss.cpo.jdbc.JdbcCpoAdapter;
import org.synchronoss.cpo.jdbc.JndiJdbcDataSourceInfo;
import org.synchronoss.cpo.jdbc.cpoJdbcConfig.CtJdbcConfig;
import org.synchronoss.cpo.jdbc.cpoJdbcConfig.CtJdbcReadWriteConfig;
import org.synchronoss.cpo.jdbc.cpoJdbcConfig.CtProperty;
import org.synchronoss.cpo.jdbc.meta.JdbcCpoMetaDescriptor;
import org.synchronoss.cpo.meta.CpoMetaDescriptor;

public class JdbcCpoConfigProcessor
implements CpoConfigProcessor {
    private static final Logger logger = LoggerFactory.getLogger(JdbcCpoConfigProcessor.class);
    private static final String PROP_URL1 = "url";
    private static final String PROP_URL2 = "URL";
    private static final String PROP_USER = "user";
    private static final String PROP_PASSWORD = "password";

    public CpoAdapter processCpoConfig(CtDataSourceConfig cpoConfig) throws CpoException {
        JdbcCpoAdapter cpoAdapter = null;
        if (cpoConfig == null || !(cpoConfig instanceof CtJdbcConfig)) {
            throw new CpoException("Invalid Jdbc Configuration Information");
        }
        CtJdbcConfig jdbcConfig = (CtJdbcConfig)cpoConfig;
        JdbcCpoMetaDescriptor metaDescriptor = (JdbcCpoMetaDescriptor)CpoMetaDescriptor.getInstance((String)jdbcConfig.getMetaDescriptorName());
        if (jdbcConfig.isSetSupportsBlobs()) {
            metaDescriptor.setSupportsBlobs(jdbcConfig.getSupportsBlobs());
        }
        if (jdbcConfig.isSetSupportsCalls()) {
            metaDescriptor.setSupportsCalls(jdbcConfig.getSupportsCalls());
        }
        if (jdbcConfig.isSetSupportsMillis()) {
            metaDescriptor.setSupportsMillis(jdbcConfig.getSupportsMillis());
        }
        if (jdbcConfig.isSetSupportsSelect4Update()) {
            metaDescriptor.setSupportsSelect4Update(jdbcConfig.getSupportsSelect4Update());
        }
        if (jdbcConfig.isSetReadWriteConfig()) {
            DataSourceInfo dataSourceInfo = this.buildDataSourceInfo(jdbcConfig.getReadWriteConfig());
            cpoAdapter = JdbcCpoAdapter.getInstance(metaDescriptor, dataSourceInfo);
        } else {
            DataSourceInfo readDataSourceInfo = this.buildDataSourceInfo(jdbcConfig.getReadConfig());
            DataSourceInfo writeDataSourceInfo = this.buildDataSourceInfo(jdbcConfig.getWriteConfig());
            cpoAdapter = JdbcCpoAdapter.getInstance(metaDescriptor, writeDataSourceInfo, readDataSourceInfo);
        }
        return cpoAdapter;
    }

    private DataSourceInfo buildDataSourceInfo(CtJdbcReadWriteConfig readWriteConfig) throws CpoException {
        AbstractJdbcDataSourceInfo dataSourceInfo = null;
        if (readWriteConfig.isSetJndiName()) {
            dataSourceInfo = new JndiJdbcDataSourceInfo(readWriteConfig.getJndiName());
        } else if (readWriteConfig.isSetDataSourceClassName()) {
            TreeMap<String, String> props = new TreeMap<String, String>();
            if (readWriteConfig.isSetUrl()) {
                props.put(PROP_URL1, readWriteConfig.getUrl());
                props.put(PROP_URL2, readWriteConfig.getUrl());
            }
            if (readWriteConfig.isSetUser()) {
                props.put(PROP_USER, readWriteConfig.getUser());
            }
            if (readWriteConfig.isSetPassword()) {
                props.put(PROP_PASSWORD, readWriteConfig.getPassword());
            }
            for (CtProperty property : readWriteConfig.getPropertyArray()) {
                props.put(property.getName(), property.getValue());
                logger.debug("Adding property " + property.getName() + "=" + property.getValue());
            }
            dataSourceInfo = new ClassJdbcDataSourceInfo(readWriteConfig.getDataSourceClassName(), props);
        } else if (readWriteConfig.isSetDriverClassName()) {
            if (readWriteConfig.isSetUser()) {
                dataSourceInfo = new DriverJdbcDataSourceInfo(readWriteConfig.getDriverClassName(), readWriteConfig.getUrl(), readWriteConfig.getUser(), readWriteConfig.getPassword());
            } else if (readWriteConfig.getPropertyArray().length > 0) {
                Properties props = new Properties();
                for (CtProperty property : readWriteConfig.getPropertyArray()) {
                    props.put(property.getName(), property.getValue());
                }
                dataSourceInfo = new DriverJdbcDataSourceInfo(readWriteConfig.getDriverClassName(), readWriteConfig.getUrl(), props);
            } else {
                dataSourceInfo = new DriverJdbcDataSourceInfo(readWriteConfig.getDriverClassName(), readWriteConfig.getUrl());
            }
        }
        logger.debug("Created DataSourceInfo: " + (Object)((Object)dataSourceInfo));
        return dataSourceInfo;
    }
}

