/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.helper.CpoClassLoader;
import org.synchronoss.cpo.jdbc.AbstractJdbcDataSource;

public class DriverJdbcDataSourceInfo
extends AbstractJdbcDataSource {
    private static final int URL_CONNECTION = 1;
    private static final int URL_PROPS_CONNECTION = 2;
    private static final int URL_USER_PASSWORD_CONNECTION = 3;
    private int connectionType = 0;
    private String url = null;
    private String username = null;
    private String password = null;
    private Properties properties = null;

    public DriverJdbcDataSourceInfo(String driver, String url) throws CpoException {
        super(url);
        this.loadDriver(driver);
        this.connectionType = 1;
        this.url = url;
    }

    public DriverJdbcDataSourceInfo(String driver, String url, Properties properties) throws CpoException {
        super(url, properties);
        this.loadDriver(driver);
        this.connectionType = 2;
        this.url = url;
        this.properties = properties;
    }

    public DriverJdbcDataSourceInfo(String driver, String url, String username, String password) throws CpoException {
        super(url + username);
        this.loadDriver(driver);
        this.connectionType = 3;
        this.url = url;
        this.username = username;
        this.password = password;
    }

    protected DataSource createDataSource() throws CpoException {
        return this;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.makeNewConnection();
    }

    private Connection makeNewConnection() throws SQLException {
        Connection connection = null;
        switch (this.connectionType) {
            case 1: {
                connection = DriverManager.getConnection(this.url);
                break;
            }
            case 2: {
                connection = DriverManager.getConnection(this.url, this.properties);
                break;
            }
            case 3: {
                connection = DriverManager.getConnection(this.url, this.username, this.password);
                break;
            }
            default: {
                throw new SQLException("Invalid Connection Type");
            }
        }
        return connection;
    }

    public synchronized String toString() {
        StringBuilder info = new StringBuilder();
        info.append("JdbcDataSource(");
        info.append(this.getDataSourceName());
        info.append(")");
        return info.toString();
    }

    private void loadDriver(String driver) throws CpoException {
        try {
            CpoClassLoader.forName((String)driver);
        }
        catch (ClassNotFoundException cnfe) {
            throw new CpoException("Could Not Load Driver" + driver);
        }
    }
}

