/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc.meta;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.jdbc.meta.JdbcMethodMapEntry;
import org.synchronoss.cpo.meta.MethodMapper;

public class JdbcMethodMapper
implements Serializable,
Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(JdbcMethodMapper.class);
    private static final long serialVersionUID = 1L;
    private static final Class<PreparedStatement> psc = PreparedStatement.class;
    private static final Class<ResultSet> rsc = ResultSet.class;
    private static final Class<CallableStatement> csc = CallableStatement.class;
    private static MethodMapper<JdbcMethodMapEntry<?, ?>> methodMapper = JdbcMethodMapper.initMethodMapper();

    private JdbcMethodMapper() {
    }

    public static JdbcMethodMapEntry<?, ?> getJavaSqlMethod(Class<?> c) throws CpoException {
        return (JdbcMethodMapEntry)methodMapper.getDataMethodMapEntry(c);
    }

    private static MethodMapper<JdbcMethodMapEntry<?, ?>> initMethodMapper() throws IllegalArgumentException {
        MethodMapper mapper = new MethodMapper();
        mapper.addMethodMapEntry(JdbcMethodMapper.makeJdbcMethodMapEntry(0, String.class, String.class, "getString", "setString"));
        mapper.addMethodMapEntry(JdbcMethodMapper.makeJdbcMethodMapEntry(0, BigDecimal.class, BigDecimal.class, "getBigDecimal", "setBigDecimal"));
        mapper.addMethodMapEntry(JdbcMethodMapper.makeJdbcMethodMapEntry(0, Byte.TYPE, Byte.TYPE, "getByte", "setByte"));
        mapper.addMethodMapEntry(JdbcMethodMapper.makeJdbcMethodMapEntry(0, Byte.class, Byte.TYPE, "getByte", "setByte"));
        mapper.addMethodMapEntry(JdbcMethodMapper.makeJdbcMethodMapEntry(0, Short.TYPE, Short.TYPE, "getShort", "setShort"));
        mapper.addMethodMapEntry(JdbcMethodMapper.makeJdbcMethodMapEntry(0, Short.class, Short.TYPE, "getShort", "setShort"));
        mapper.addMethodMapEntry(JdbcMethodMapper.makeJdbcMethodMapEntry(0, Integer.TYPE, Integer.TYPE, "getInt", "setInt"));
        mapper.addMethodMapEntry(JdbcMethodMapper.makeJdbcMethodMapEntry(0, Integer.class, Integer.TYPE, "getInt", "setInt"));
        mapper.addMethodMapEntry(JdbcMethodMapper.makeJdbcMethodMapEntry(0, Long.TYPE, Long.TYPE, "getLong", "setLong"));
        mapper.addMethodMapEntry(JdbcMethodMapper.makeJdbcMethodMapEntry(0, Long.class, Long.TYPE, "getLong", "setLong"));
        mapper.addMethodMapEntry(JdbcMethodMapper.makeJdbcMethodMapEntry(0, Float.TYPE, Float.TYPE, "getFloat", "setFloat"));
        mapper.addMethodMapEntry(JdbcMethodMapper.makeJdbcMethodMapEntry(0, Float.class, Float.TYPE, "getFloat", "setFloat"));
        mapper.addMethodMapEntry(JdbcMethodMapper.makeJdbcMethodMapEntry(0, Double.TYPE, Double.TYPE, "getDouble", "setDouble"));
        mapper.addMethodMapEntry(JdbcMethodMapper.makeJdbcMethodMapEntry(0, Double.class, Double.TYPE, "getDouble", "setDouble"));
        mapper.addMethodMapEntry(JdbcMethodMapper.makeJdbcMethodMapEntry(0, byte[].class, byte[].class, "getBytes", "setBytes"));
        mapper.addMethodMapEntry(JdbcMethodMapper.makeJdbcMethodMapEntry(0, Date.class, Date.class, "getDate", "setDate"));
        mapper.addMethodMapEntry(JdbcMethodMapper.makeJdbcMethodMapEntry(0, Time.class, Time.class, "getTime", "setTime"));
        mapper.addMethodMapEntry(JdbcMethodMapper.makeJdbcMethodMapEntry(0, Timestamp.class, Timestamp.class, "getTimestamp", "setTimestamp"));
        mapper.addMethodMapEntry(JdbcMethodMapper.makeJdbcMethodMapEntry(0, Clob.class, Clob.class, "getClob", "setClob"));
        mapper.addMethodMapEntry(JdbcMethodMapper.makeJdbcMethodMapEntry(0, Blob.class, Blob.class, "getBlob", "setBlob"));
        mapper.addMethodMapEntry(JdbcMethodMapper.makeJdbcMethodMapEntry(0, Array.class, Array.class, "getArray", "setArray"));
        mapper.addMethodMapEntry(JdbcMethodMapper.makeJdbcMethodMapEntry(0, Ref.class, Ref.class, "getRef", "setRef"));
        mapper.addMethodMapEntry(JdbcMethodMapper.makeJdbcMethodMapEntry(0, Object.class, Object.class, "getObject", "setObject"));
        mapper.addMethodMapEntry(JdbcMethodMapper.makeJdbcMethodMapEntry(0, URL.class, URL.class, "getURL", "setURL"));
        mapper.addMethodMapEntry(JdbcMethodMapper.makeJdbcMethodMapEntry(0, Boolean.TYPE, Boolean.TYPE, "getBoolean", "setBoolean"));
        mapper.addMethodMapEntry(JdbcMethodMapper.makeJdbcMethodMapEntry(0, Boolean.class, Boolean.TYPE, "getBoolean", "setBoolean"));
        mapper.addMethodMapEntry(JdbcMethodMapper.makeJdbcMethodMapEntry(1, InputStream.class, InputStream.class, "getBlob", "setBinaryStream"));
        mapper.addMethodMapEntry(JdbcMethodMapper.makeJdbcMethodMapEntry(2, Reader.class, Reader.class, "getClob", "setCharacterStream"));
        return mapper;
    }

    public static MethodMapper getMethodMapper() {
        return methodMapper;
    }

    private static <T> JdbcMethodMapEntry<?, ?> makeJdbcMethodMapEntry(int methodType, Class<T> javaClass, Class<T> datasourceMethodClass, String getterName, String setterName) throws IllegalArgumentException {
        Method rsGetter = JdbcMethodMapper.loadGetter(methodType, rsc, getterName);
        Method bsSetter = JdbcMethodMapper.loadSetter(methodType, psc, datasourceMethodClass, setterName);
        Method csGetter = JdbcMethodMapper.loadGetter(methodType, csc, getterName);
        Method csSetter = JdbcMethodMapper.loadSetter(methodType, csc, datasourceMethodClass, setterName);
        return new JdbcMethodMapEntry<T, T>(methodType, javaClass, datasourceMethodClass, rsGetter, bsSetter, csGetter, csSetter);
    }

    private static <M, D> Method loadSetter(int methodType, Class<M> methodClass, Class<D> datasourceClass, String setterName) throws IllegalArgumentException {
        Method setter;
        try {
            setter = methodType == 0 ? methodClass.getMethod(setterName, Integer.TYPE, datasourceClass) : methodClass.getMethod(setterName, Integer.TYPE, datasourceClass, Integer.TYPE);
        }
        catch (NoSuchMethodException nsme) {
            logger.error("Error loading Setter" + setterName, (Throwable)nsme);
            throw new IllegalArgumentException(nsme);
        }
        return setter;
    }

    private static <M> Method loadGetter(int methodType, Class<M> methodClass, String getterName) throws IllegalArgumentException {
        Method getter;
        try {
            getter = methodClass.getMethod(getterName, Integer.TYPE);
        }
        catch (NoSuchMethodException nsme) {
            logger.error("Error loading Getter" + getterName, (Throwable)nsme);
            throw new IllegalArgumentException(nsme);
        }
        return getter;
    }
}

