/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.transform.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.jdbc.JdbcCallableStatementFactory;
import org.synchronoss.cpo.jdbc.JdbcPreparedStatementFactory;
import org.synchronoss.cpo.transform.jdbc.JdbcCpoTransform;

public class TransformGZipBytes
implements JdbcCpoTransform<byte[], byte[]> {
    private static final Logger logger = LoggerFactory.getLogger(TransformGZipBytes.class);

    public byte[] transformIn(byte[] inBytes) throws CpoException {
        byte[] buffBytes = new byte[1024];
        byte[] retBytes = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (inBytes != null) {
            if (inBytes.length > 0) {
                try {
                    int length;
                    ByteArrayInputStream bis = new ByteArrayInputStream(inBytes);
                    GZIPInputStream gzis = new GZIPInputStream(bis);
                    while ((length = gzis.read(buffBytes)) != -1) {
                        bos.write(buffBytes, 0, length);
                    }
                    bos.flush();
                    bos.close();
                    gzis.close();
                    ((InputStream)bis).close();
                    retBytes = bos.toByteArray();
                }
                catch (Exception e) {
                    logger.error("Error in transform GZipBytes", (Throwable)e);
                    throw new CpoException((Throwable)e);
                }
            } else {
                retBytes = new byte[]{};
            }
        }
        return retBytes;
    }

    @Override
    public byte[] transformOut(JdbcPreparedStatementFactory jpsf, byte[] attributeObject) throws CpoException {
        byte[] retBytes = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            if (attributeObject != null) {
                if (attributeObject.length > 0) {
                    GZIPOutputStream os = new GZIPOutputStream(baos);
                    os.write(attributeObject);
                    os.flush();
                    os.close();
                    baos.flush();
                    baos.close();
                    retBytes = baos.toByteArray();
                } else {
                    retBytes = new byte[]{};
                }
            }
        }
        catch (Exception e) {
            String msg = "Error GZipping Byte Array";
            logger.error(msg, (Throwable)e);
            throw new CpoException(msg, (Throwable)e);
        }
        return retBytes;
    }

    @Override
    public byte[] transformOut(JdbcCallableStatementFactory jpsf, byte[] attributeObject) throws CpoException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public byte[] transformOut(byte[] j) throws CpoException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

