/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.CpoTrxAdapter;
import org.synchronoss.cpo.jdbc.JdbcCpoAdapter;
import org.synchronoss.cpo.jdbc.meta.JdbcCpoMetaDescriptor;

public class JdbcCpoTrxAdapter
extends JdbcCpoAdapter
implements CpoTrxAdapter {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(JdbcCpoAdapter.class);
    private Connection writeConnection_ = null;
    private static final HashMap<Connection, Connection> busyMap_ = new HashMap();

    private JdbcCpoTrxAdapter() {
    }

    protected JdbcCpoTrxAdapter(JdbcCpoMetaDescriptor metaDescriptor, Connection c, boolean batchSupported, String dataSourceName) throws CpoException {
        super(metaDescriptor, batchSupported, dataSourceName);
        this.setStaticConnection(c);
    }

    public void commit() throws CpoException {
        if (this.writeConnection_ != null) {
            try {
                this.writeConnection_.commit();
            }
            catch (SQLException se) {
                throw new CpoException(se.getMessage());
            }
        } else {
            throw new CpoException("Transaction Object has been Closed");
        }
    }

    public void rollback() throws CpoException {
        if (this.writeConnection_ != null) {
            try {
                this.writeConnection_.rollback();
            }
            catch (Exception e) {
                throw new CpoException(e.getMessage());
            }
        } else {
            throw new CpoException("Transaction Object has been Closed");
        }
    }

    public boolean isClosed() throws CpoException {
        boolean closed = false;
        try {
            closed = this.writeConnection_ == null || this.writeConnection_.isClosed();
        }
        catch (Exception e) {
            throw new CpoException(e.getMessage());
        }
        return closed;
    }

    public void close() throws CpoException {
        if (this.writeConnection_ != null) {
            try {
                block9: {
                    try {
                        this.writeConnection_.rollback();
                    }
                    catch (Exception e) {
                        if (!logger.isTraceEnabled()) break block9;
                        logger.trace(e.getLocalizedMessage());
                    }
                }
                try {
                    this.writeConnection_.close();
                }
                catch (Exception e) {
                    if (logger.isTraceEnabled()) {
                        logger.trace(e.getLocalizedMessage());
                    }
                }
            }
            finally {
                this.setStaticConnection(null);
            }
        }
    }

    protected void finalize() {
        block6: {
            block5: {
                try {
                    super.finalize();
                }
                catch (Throwable e) {
                    if (!logger.isTraceEnabled()) break block5;
                    logger.trace(e.getLocalizedMessage());
                }
            }
            try {
                if (this.writeConnection_ != null && !this.writeConnection_.isClosed()) {
                    this.close();
                }
            }
            catch (Exception e) {
                if (!logger.isTraceEnabled()) break block6;
                logger.trace(e.getLocalizedMessage());
            }
        }
    }

    @Override
    protected Connection getStaticConnection() throws CpoException {
        if (this.writeConnection_ != null) {
            if (this.isConnectionBusy(this.writeConnection_)) {
                throw new CpoException("Error Connection Busy");
            }
            this.setConnectionBusy(this.writeConnection_);
        }
        return this.writeConnection_;
    }

    @Override
    protected boolean isStaticConnection(Connection c) {
        return this.writeConnection_ == c;
    }

    @Override
    protected void setStaticConnection(Connection c) {
        this.writeConnection_ = c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isConnectionBusy(Connection c) {
        HashMap<Connection, Connection> hashMap = busyMap_;
        synchronized (hashMap) {
            Connection test = busyMap_.get(c);
            return test != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setConnectionBusy(Connection c) {
        HashMap<Connection, Connection> hashMap = busyMap_;
        synchronized (hashMap) {
            busyMap_.put(c, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clearConnectionBusy(Connection c) {
        HashMap<Connection, Connection> hashMap = busyMap_;
        synchronized (hashMap) {
            busyMap_.remove(c);
        }
    }
}

