/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import java.io.InputStream;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoByteArrayInputStream;
import org.synchronoss.cpo.CpoCharArrayReader;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.helper.ExceptionHelper;
import org.synchronoss.cpo.jdbc.JdbcPreparedStatementFactory;
import org.synchronoss.cpo.jdbc.meta.JdbcMethodMapEntry;
import org.synchronoss.cpo.jdbc.meta.JdbcMethodMapper;
import org.synchronoss.cpo.meta.AbstractBindableCpoData;
import org.synchronoss.cpo.meta.domain.CpoAttribute;
import org.synchronoss.cpo.transform.CpoTransform;
import org.synchronoss.cpo.transform.jdbc.JdbcCpoTransform;

public class JdbcPreparedStatementCpoData
extends AbstractBindableCpoData {
    private static final Logger logger = LoggerFactory.getLogger(JdbcPreparedStatementCpoData.class);
    private JdbcPreparedStatementFactory cpoStatementFactory = null;

    public JdbcPreparedStatementCpoData(JdbcPreparedStatementFactory cpoStatementFactory, CpoAttribute cpoAttribute, int index) {
        super(cpoAttribute, index);
        this.cpoStatementFactory = cpoStatementFactory;
    }

    public void invokeSetter(Object instanceObject) throws CpoException {
        Logger localLogger = instanceObject == null ? logger : LoggerFactory.getLogger(instanceObject.getClass());
        CpoAttribute cpoAttribute = this.getCpoAttribute();
        Object param = this.transformOut(cpoAttribute.invokeGetter(instanceObject));
        JdbcMethodMapEntry<?, ?> methodMapEntry = JdbcMethodMapper.getJavaSqlMethod(this.getDataSetterParamType());
        if (methodMapEntry == null) {
            throw new CpoException("Error Retrieveing Jdbc Method for type: " + this.getDataSetterParamType().getName());
        }
        localLogger.info(cpoAttribute.getDataName() + "=" + param);
        try {
            switch (methodMapEntry.getMethodType()) {
                case 0: {
                    methodMapEntry.getBsSetter().invoke((Object)this.cpoStatementFactory.getPreparedStatement(), this.getIndex(), param);
                    break;
                }
                case 1: {
                    CpoByteArrayInputStream cbais = CpoByteArrayInputStream.getCpoStream((InputStream)((InputStream)param));
                    methodMapEntry.getBsSetter().invoke((Object)this.cpoStatementFactory.getPreparedStatement(), this.getIndex(), cbais, cbais.getLength());
                    break;
                }
                case 2: {
                    CpoCharArrayReader ccar = CpoCharArrayReader.getCpoReader((Reader)((Reader)param));
                    methodMapEntry.getBsSetter().invoke((Object)this.cpoStatementFactory.getPreparedStatement(), this.getIndex(), ccar, ccar.getLength());
                }
            }
        }
        catch (Exception e) {
            throw new CpoException("Error Invoking Jdbc Method: " + methodMapEntry.getBsSetter().getName() + ":" + ExceptionHelper.getLocalizedMessage((Throwable)e));
        }
    }

    public Object transformOut(Object attributeObject) throws CpoException {
        Object retObj = attributeObject;
        CpoTransform cpoTransform = this.getCpoAttribute().getCpoTransform();
        if (cpoTransform != null) {
            retObj = cpoTransform instanceof JdbcCpoTransform ? ((JdbcCpoTransform)cpoTransform).transformOut(this.cpoStatementFactory, attributeObject) : cpoTransform.transformOut(attributeObject);
        }
        return retObj;
    }
}

