/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoData;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.CpoNativeFunction;
import org.synchronoss.cpo.CpoOrderBy;
import org.synchronoss.cpo.CpoReleasible;
import org.synchronoss.cpo.CpoStatementFactory;
import org.synchronoss.cpo.CpoWhere;
import org.synchronoss.cpo.helper.ExceptionHelper;
import org.synchronoss.cpo.jdbc.JdbcCpoAdapter;
import org.synchronoss.cpo.jdbc.JdbcPreparedStatementCpoData;
import org.synchronoss.cpo.jdbc.meta.JdbcMethodMapper;
import org.synchronoss.cpo.meta.MethodMapper;
import org.synchronoss.cpo.meta.domain.CpoAttribute;
import org.synchronoss.cpo.meta.domain.CpoClass;
import org.synchronoss.cpo.meta.domain.CpoFunction;

public class JdbcPreparedStatementFactory
extends CpoStatementFactory
implements CpoReleasible {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(JdbcPreparedStatementFactory.class);
    private PreparedStatement ps_ = null;
    private List<CpoReleasible> releasibles = new ArrayList<CpoReleasible>();
    private static final String WHERE_MARKER = "__CPO_WHERE__";
    private static final String ORDERBY_MARKER = "__CPO_ORDERBY__";

    public <T> JdbcPreparedStatementFactory(Connection conn, JdbcCpoAdapter jca, CpoClass criteria, CpoFunction function, T obj, Collection<CpoWhere> wheres, Collection<CpoOrderBy> orderBy, Collection<CpoNativeFunction> nativeQueries) throws CpoException {
        super(obj == null ? logger : LoggerFactory.getLogger(obj.getClass()));
        List bindValues = this.getBindValues(function, obj);
        String sql = this.buildSql(criteria, function.getExpression(), wheres, orderBy, nativeQueries, bindValues);
        this.getLocalLogger().debug("CpoFunction SQL = <" + sql + ">");
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
        }
        catch (SQLException se) {
            this.getLocalLogger().error("Error Instantiating JdbcPreparedStatementFactory SQL=<" + sql + ">" + ExceptionHelper.getLocalizedMessage((Throwable)se));
            throw new CpoException((Throwable)se);
        }
        this.setPreparedStatement(pstmt);
        this.setBindValues(bindValues);
    }

    protected MethodMapper getMethodMapper() {
        return JdbcMethodMapper.getMethodMapper();
    }

    protected CpoData getCpoData(CpoAttribute cpoAttribute, int index) {
        return new JdbcPreparedStatementCpoData(this, cpoAttribute, index);
    }

    protected Object getBindableStatement() {
        return this.getPreparedStatement();
    }

    protected int getStartingIndex() {
        return 1;
    }

    public PreparedStatement getPreparedStatement() {
        return this.ps_;
    }

    protected void setPreparedStatement(PreparedStatement ps) {
        this.ps_ = ps;
    }
}

