/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.CpoTrxAdapter;
import org.synchronoss.cpo.jdbc.JdbcCpoAdapter;

public class JdbcCpoTrxAdapter
extends JdbcCpoAdapter
implements CpoTrxAdapter {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(JdbcCpoTrxAdapter.class);
    private Connection writeConnection_ = null;
    private static final HashMap<Connection, Connection> busyMap_ = new HashMap();

    private JdbcCpoTrxAdapter() {
    }

    protected JdbcCpoTrxAdapter(JdbcCpoAdapter jdbcCpoAdapter) throws CpoException {
        super(jdbcCpoAdapter);
    }

    public void commit() throws CpoException {
        Connection conn = this.getStaticConnection();
        if (conn != null) {
            try {
                conn.commit();
            }
            catch (SQLException se) {
                throw new CpoException(se.getMessage());
            }
        } else {
            throw new CpoException("Transaction Object has been Closed");
        }
    }

    public void rollback() throws CpoException {
        Connection conn = this.getStaticConnection();
        if (conn != null) {
            try {
                conn.rollback();
            }
            catch (Exception e) {
                throw new CpoException(e.getMessage());
            }
        } else {
            throw new CpoException("Transaction Object has been Closed");
        }
    }

    public boolean isClosed() throws CpoException {
        boolean closed = false;
        try {
            closed = this.writeConnection_ == null || this.writeConnection_.isClosed();
        }
        catch (Exception e) {
            throw new CpoException(e.getMessage());
        }
        return closed;
    }

    public boolean isBusy() throws CpoException {
        return this.isConnectionBusy(this.writeConnection_);
    }

    public void close() throws CpoException {
        block11: {
            Connection conn = this.getStaticConnection();
            try {
                block12: {
                    if (conn == null || conn.isClosed()) break block11;
                    try {
                        conn.rollback();
                    }
                    catch (Exception e) {
                        if (!logger.isTraceEnabled()) break block12;
                        logger.trace(e.getLocalizedMessage());
                    }
                }
                try {
                    conn.close();
                }
                catch (Exception e) {
                    if (logger.isTraceEnabled()) {
                        logger.trace(e.getLocalizedMessage());
                    }
                }
            }
            catch (Exception e) {
                if (logger.isTraceEnabled()) {
                    logger.trace(e.getLocalizedMessage());
                }
            }
            finally {
                this.setStaticConnection(null);
            }
        }
    }

    protected void finalize() {
        block5: {
            block4: {
                try {
                    super.finalize();
                }
                catch (Throwable e) {
                    if (!logger.isTraceEnabled()) break block4;
                    logger.trace(e.getLocalizedMessage());
                }
            }
            try {
                this.close();
            }
            catch (Exception e) {
                if (!logger.isTraceEnabled()) break block5;
                logger.trace(e.getLocalizedMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isConnectionBusy(Connection c) {
        HashMap<Connection, Connection> hashMap = busyMap_;
        synchronized (hashMap) {
            return c != null && busyMap_.containsKey(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setConnectionBusy(Connection c) {
        HashMap<Connection, Connection> hashMap = busyMap_;
        synchronized (hashMap) {
            busyMap_.put(c, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearConnectionBusy(Connection c) {
        HashMap<Connection, Connection> hashMap = busyMap_;
        synchronized (hashMap) {
            busyMap_.remove(c);
        }
    }

    protected Connection getStaticConnection() throws CpoException {
        if (this.writeConnection_ != null) {
            if (this.isConnectionBusy(this.writeConnection_)) {
                throw new CpoException("Error Connection Busy");
            }
        } else {
            this.writeConnection_ = super.getWriteConnection();
        }
        return this.writeConnection_;
    }

    private void setStaticConnection(Connection c) {
        this.writeConnection_ = c;
    }

    @Override
    protected Connection getReadConnection() throws CpoException {
        Connection connection = this.getStaticConnection();
        this.setConnectionBusy(connection);
        return connection;
    }

    @Override
    protected Connection getWriteConnection() throws CpoException {
        Connection connection = this.getStaticConnection();
        this.setConnectionBusy(connection);
        return connection;
    }

    @Override
    protected void closeLocalConnection(Connection connection) {
        this.clearConnectionBusy(connection);
    }

    @Override
    protected void commitLocalConnection(Connection connection) {
    }

    @Override
    protected void rollbackLocalConnection(Connection connection) {
    }
}

