/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.plugin;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.synchronoss.cpo.MetaVisitor;
import org.synchronoss.cpo.core.cpoCoreMeta.CpoMetaDataDocument;
import org.synchronoss.cpo.helper.XmlBeansHelper;
import org.synchronoss.cpo.jdbc.JdbcCpoArgument;
import org.synchronoss.cpo.jdbc.JdbcCpoAttribute;
import org.synchronoss.cpo.jdbc.exporter.JdbcMetaXmlObjectExporter;
import org.synchronoss.cpo.jdbc.meta.JdbcCpoMetaDescriptor;
import org.synchronoss.cpo.meta.CpoMetaDescriptor;
import org.synchronoss.cpo.meta.domain.CpoArgument;
import org.synchronoss.cpo.meta.domain.CpoAttribute;
import org.synchronoss.cpo.meta.domain.CpoClass;
import org.synchronoss.cpo.meta.domain.CpoFunction;
import org.synchronoss.cpo.meta.domain.CpoFunctionGroup;

public class ConvertSQLToXML
extends AbstractMojo {
    private String dbUrl;
    private String dbTablePrefix;
    private String dbDriver;
    private String dbParams;
    private String filter;
    public static final File TARGET = new File("target");
    public static final String CPO_META_DATA_XML = "CpoMetaData.xml";
    private JdbcCpoMetaDescriptor metaDescriptor;

    public void execute(String dbUrl, String dbTablePrefix, String dbDriver, String dbParams, String filter) throws MojoExecutionException {
        this.dbUrl = dbUrl;
        this.dbTablePrefix = dbTablePrefix;
        this.dbDriver = dbDriver;
        this.dbParams = dbParams;
        this.filter = filter;
        this.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Converting SQL to XML...");
        this.getLog().info((CharSequence)("dbUrl: " + this.dbUrl));
        this.getLog().info((CharSequence)("dbTablePrefix: " + this.dbTablePrefix));
        this.getLog().info((CharSequence)("Class: " + this.dbDriver));
        try {
            this.metaDescriptor = new JdbcCpoMetaDescriptor("Converter");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Couldn't load the MetaDescriptor");
        }
        try {
            Class<?> driverClass = Class.forName(this.dbDriver);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Couldn't location driver class");
        }
        Properties connectionProperties = new Properties();
        if (this.dbParams != null && !this.dbParams.equals("")) {
            StringTokenizer st = new StringTokenizer(this.dbParams, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                StringTokenizer stNameValue = new StringTokenizer(token, "=");
                String name = null;
                String value = null;
                if (stNameValue.hasMoreTokens()) {
                    name = stNameValue.nextToken();
                }
                if (stNameValue.hasMoreTokens()) {
                    value = stNameValue.nextToken();
                }
                connectionProperties.setProperty(name, value);
            }
        }
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(this.dbUrl, connectionProperties);
            conn.setAutoCommit(false);
            List<CpoClass> classes = this.getClasses(conn);
            for (CpoClass cpoClass : classes) {
                for (CpoAttribute att : this.getAttributes(cpoClass, conn)) {
                    cpoClass.addAttribute(att);
                }
                for (CpoFunctionGroup fg : this.getFunctionGroups(cpoClass, conn)) {
                    cpoClass.addFunctionGroup(fg);
                }
            }
            JdbcMetaXmlObjectExporter exporter = new JdbcMetaXmlObjectExporter((CpoMetaDescriptor)this.metaDescriptor);
            for (CpoClass cpoClass : classes) {
                cpoClass.acceptMetaDFVisitor((MetaVisitor)exporter);
            }
            CpoMetaDataDocument cpoMetaDataDocument = exporter.getCpoMetaDataDocument();
            if (!TARGET.exists()) {
                TARGET.mkdir();
            }
            cpoMetaDataDocument.save(new File(TARGET, CPO_META_DATA_XML), XmlBeansHelper.getXmlOptions());
        }
        catch (IOException ex) {
            this.getLog().error((CharSequence)"IOException caught", (Throwable)ex);
        }
        catch (SQLException ex) {
            this.getLog().error((CharSequence)"SQLException caught", (Throwable)ex);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CpoClass> getClasses(Connection conn) {
        ArrayList<CpoClass> classes = new ArrayList<CpoClass>();
        StringBuilder sql = new StringBuilder();
        sql.append("select name from ");
        sql.append(this.dbTablePrefix);
        sql.append("cpo_class order by name");
        this.getLog().debug((CharSequence)("getClasses() SQL: " + sql));
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(sql.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                String className = rs.getString(1);
                if (this.filter == null || !className.matches(this.filter)) continue;
                CpoClass cpoClass = new CpoClass();
                cpoClass.setName(className);
                classes.add(cpoClass);
            }
        }
        catch (SQLException ex) {
            this.getLog().error((CharSequence)"SQLException caught", (Throwable)ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception e) {}
            }
        }
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CpoAttribute> getAttributes(CpoClass cpoClass, Connection conn) {
        ArrayList<CpoAttribute> attributes = new ArrayList<CpoAttribute>();
        StringBuilder sql = new StringBuilder();
        sql.append("select cam.column_name, cam.attribute, cam.column_type, cam.db_table, cam.db_column, cam.transform_class from ");
        sql.append(this.dbTablePrefix);
        sql.append("cpo_attribute_map cam, ");
        sql.append(this.dbTablePrefix);
        sql.append("cpo_class cc where cc.name = ? and cam.class_id = cc.class_id ");
        PreparedStatement ps = null;
        ResultSet rs = null;
        this.getLog().debug((CharSequence)("loadAttribute Sql <" + sql.toString() + ">"));
        try {
            ps = conn.prepareStatement(sql.toString());
            ps.setString(1, cpoClass.getName());
            rs = ps.executeQuery();
            while (rs.next()) {
                JdbcCpoAttribute cpoAttribute = new JdbcCpoAttribute();
                cpoAttribute.setDataName(rs.getString(1));
                cpoAttribute.setJavaName(rs.getString(2));
                cpoAttribute.setDataType(rs.getString(3));
                cpoAttribute.setDbTable(rs.getString(4));
                cpoAttribute.setDbColumn(rs.getString(5));
                cpoAttribute.setTransformClassName(rs.getString(6));
                if (cpoAttribute.getTransformClassName() != null) {
                    try {
                        cpoAttribute.loadRunTimeInfo((CpoMetaDescriptor)this.metaDescriptor, null);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                cpoAttribute.setJavaType(this.metaDescriptor.getJavaTypeName((CpoAttribute)cpoAttribute));
                attributes.add((CpoAttribute)cpoAttribute);
            }
        }
        catch (Exception ex) {
            String msg = "loadAttributeMap() failed:'" + sql + "' classname:" + cpoClass.getName();
            this.getLog().error((CharSequence)msg, (Throwable)ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception e) {}
            }
        }
        return attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CpoFunctionGroup> getFunctionGroups(CpoClass cpoClass, Connection conn) {
        ArrayList<CpoFunctionGroup> functionGroups = new ArrayList<CpoFunctionGroup>();
        StringBuilder sql = new StringBuilder();
        sql.append("select cqg.group_type, cqg.name, cqt.sql_text, cqt.description, cam.attribute, cqp.param_type ");
        sql.append("from " + this.dbTablePrefix + "cpo_query_group cqg ");
        sql.append("join " + this.dbTablePrefix + "cpo_class cc on cqg.class_id = cc.class_id and cc.name = ? ");
        sql.append("left outer join " + this.dbTablePrefix + "cpo_query cq on cqg.group_id = cq.group_id ");
        sql.append("left outer join " + this.dbTablePrefix + "cpo_query_text cqt on cq.text_id = cqt.text_id ");
        sql.append("left outer join " + this.dbTablePrefix + "cpo_query_parameter cqp on cq.query_id = cqp.query_id ");
        sql.append("left outer join " + this.dbTablePrefix + "cpo_attribute_map cam on cqp.attribute_id = cam.attribute_id ");
        sql.append("order by cqg.group_type, cqg.name, cqg.group_id, cq.seq_no, cqp.seq_no ");
        PreparedStatement ps = null;
        ResultSet rs = null;
        this.getLog().debug((CharSequence)("functionGroup Sql <" + sql.toString() + ">"));
        try {
            ps = conn.prepareStatement(sql.toString());
            ps.setString(1, cpoClass.getName());
            rs = ps.executeQuery();
            String lastFunctionGroupName = null;
            CpoFunctionGroup functionGroup = null;
            CpoFunction function = null;
            while (rs.next()) {
                String groupType = rs.getString(1);
                String groupName = rs.getString(2);
                String expression = rs.getString(3);
                String functionName = rs.getString(4);
                String attribute = rs.getString(5);
                String paramType = rs.getString(6);
                StringBuilder fgNamebuf = new StringBuilder();
                fgNamebuf.append(groupType);
                fgNamebuf.append("@");
                if (groupName != null) {
                    fgNamebuf.append(groupName);
                }
                if (functionGroup == null || !fgNamebuf.toString().equals(lastFunctionGroupName)) {
                    functionGroup = new CpoFunctionGroup();
                    functionGroup.setType(groupType);
                    functionGroup.setName(groupName);
                    functionGroups.add(functionGroup);
                    function = null;
                    lastFunctionGroupName = fgNamebuf.toString();
                }
                if (function == null || !function.getExpression().equals(expression)) {
                    if (functionName == null || functionName.isEmpty() || expression == null || expression.isEmpty()) {
                        this.getLog().warn((CharSequence)("Query Group[" + groupName + "] contained no sql, so ignoring it"));
                    } else {
                        function = new CpoFunction();
                        function.setName(functionName);
                        function.setExpression(expression);
                        functionGroup.addFunction(function);
                    }
                }
                if (attribute == null) continue;
                JdbcCpoArgument argument = new JdbcCpoArgument();
                argument.setAttributeName(attribute);
                argument.setScope(paramType);
                function.addArgument((CpoArgument)argument);
            }
        }
        catch (SQLException ex) {
            String msg = "loadAttributeMap() failed:'" + sql + "' classname:" + cpoClass.getName();
            this.getLog().error((CharSequence)msg, (Throwable)ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception e) {}
            }
        }
        return functionGroups;
    }
}

