/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.plugin;

import java.io.File;
import java.io.FileWriter;
import java.util.StringTokenizer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.synchronoss.cpo.MetaVisitor;
import org.synchronoss.cpo.exporter.CpoClassSourceGenerator;
import org.synchronoss.cpo.meta.CpoMetaDescriptor;
import org.synchronoss.cpo.meta.domain.CpoClass;

public class GenerateJavaSources
extends AbstractMojo {
    private String cpoConfig;
    private String outputDir;
    private String testOutputDir;
    private String scope;
    protected MavenProject project;
    private final String JAVA_EXT = ".java";
    private final String META_DESCRIPTOR_NAME = "Generator-" + System.currentTimeMillis();

    public void execute() throws MojoExecutionException {
        File srcDir;
        this.getLog().info((CharSequence)("Cpo config: " + this.cpoConfig));
        if (Scopes.test.toString().equals(this.scope)) {
            srcDir = new File(this.testOutputDir);
            this.project.addTestCompileSourceRoot(srcDir.getAbsolutePath());
            this.getLog().debug((CharSequence)("Adding " + srcDir.getAbsolutePath() + " to the project's test compile sources."));
        } else {
            srcDir = new File(this.outputDir);
            this.project.addCompileSourceRoot(srcDir.getAbsolutePath());
            this.getLog().debug((CharSequence)("Adding " + srcDir.getAbsolutePath() + " to the project's compile sources."));
        }
        this.getLog().info((CharSequence)("Generating cpo java sources to " + srcDir));
        File outputDirectory = new File(this.project.getBuild().getOutputDirectory());
        if (!outputDirectory.exists() && !outputDirectory.mkdirs()) {
            throw new MojoExecutionException("Unable to create output directory: " + outputDirectory.getAbsolutePath());
        }
        try {
            CpoMetaDescriptor metaDescriptor = CpoMetaDescriptor.getInstance((String)this.META_DESCRIPTOR_NAME, (String)this.cpoConfig);
            for (CpoClass cpoClass : metaDescriptor.getCpoClasses()) {
                String className = cpoClass.getName();
                File classDir = srcDir;
                if (className.lastIndexOf(".") != -1) {
                    String packageName = className.substring(0, className.lastIndexOf("."));
                    StringTokenizer tok = new StringTokenizer(packageName, ".");
                    while (tok.hasMoreTokens()) {
                        String dirName = tok.nextToken();
                        classDir = new File(classDir, dirName);
                    }
                    className = className.substring(className.lastIndexOf(".") + 1);
                }
                if (!classDir.exists() && !classDir.mkdirs()) {
                    throw new MojoExecutionException("Unable to create class directories: " + classDir.getAbsolutePath());
                }
                File javaFile = new File(classDir, className + ".java");
                this.getLog().info((CharSequence)("cpo-plugin generated " + javaFile.getAbsolutePath()));
                CpoClassSourceGenerator classSourceGenerator = new CpoClassSourceGenerator(metaDescriptor);
                cpoClass.acceptMetaDFVisitor((MetaVisitor)classSourceGenerator);
                FileWriter cw = new FileWriter(javaFile);
                cw.write(classSourceGenerator.getSourceCode());
                cw.flush();
                cw.close();
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Exception caught", ex);
        }
    }

    private static enum Scopes {
        test;

    }
}

