/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.plugin;

import java.io.File;
import java.io.FileWriter;
import java.util.StringTokenizer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.synchronoss.cpo.MetaVisitor;
import org.synchronoss.cpo.exporter.CpoClassSourceGenerator;
import org.synchronoss.cpo.exporter.CpoInterfaceSourceGenerator;
import org.synchronoss.cpo.exporter.CpoLegacyClassSourceGenerator;
import org.synchronoss.cpo.meta.CpoMetaDescriptor;
import org.synchronoss.cpo.meta.domain.CpoClass;

@Mojo(name="generatejavasource", requiresDependencyResolution=ResolutionScope.RUNTIME, configurator="include-project-dependencies", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class GenerateJavaSources
extends AbstractMojo {
    @Parameter(property="cpoConfig", required=true)
    private String cpoConfig;
    @Parameter(property="outputDir", required=true, defaultValue="${project.build.directory}/generated-sources/cpo")
    private String outputDir;
    @Parameter(property="testOutputDir", required=true, defaultValue="${project.build.directory}/generated-test-sources/cpo")
    private String testOutputDir;
    @Parameter(property="scope", required=true, defaultValue="compile")
    private String scope;
    @Parameter(property="filter", defaultValue=".*")
    private String filter;
    @Parameter(property="generateInterface", defaultValue="false")
    private boolean generateInterface = false;
    @Parameter(property="generateClass", defaultValue="true")
    private boolean generateClass = true;
    @Component
    protected MavenProject project;
    private final String JAVA_EXT = ".java";
    private final String META_DESCRIPTOR_NAME = "Generator-" + System.currentTimeMillis();

    public void execute() throws MojoExecutionException {
        File srcDir;
        this.getLog().info((CharSequence)("Cpo config: " + this.cpoConfig));
        if (!this.generateInterface && !this.generateClass) {
            throw new MojoExecutionException("You must generate interfaces, classes or both");
        }
        if (Scopes.test.toString().equals(this.scope)) {
            srcDir = new File(this.testOutputDir);
            this.project.addTestCompileSourceRoot(srcDir.getAbsolutePath());
            this.getLog().debug((CharSequence)("Adding " + srcDir.getAbsolutePath() + " to the project's test compile sources."));
        } else {
            srcDir = new File(this.outputDir);
            this.project.addCompileSourceRoot(srcDir.getAbsolutePath());
            this.getLog().debug((CharSequence)("Adding " + srcDir.getAbsolutePath() + " to the project's compile sources."));
        }
        this.getLog().info((CharSequence)("Generating cpo java sources to " + srcDir));
        File outputDirectory = new File(this.project.getBuild().getOutputDirectory());
        if (!outputDirectory.exists() && !outputDirectory.mkdirs()) {
            throw new MojoExecutionException("Unable to create output directory: " + outputDirectory.getAbsolutePath());
        }
        try {
            CpoMetaDescriptor metaDescriptor = CpoMetaDescriptor.getInstance((String)this.META_DESCRIPTOR_NAME, (String)this.cpoConfig, (boolean)true);
            for (CpoClass cpoClass : metaDescriptor.getCpoClasses()) {
                String className = cpoClass.getName();
                if (this.filter == null || !className.matches(this.filter)) continue;
                File classDir = srcDir;
                if (className.lastIndexOf(".") != -1) {
                    String packageName = className.substring(0, className.lastIndexOf("."));
                    StringTokenizer tok = new StringTokenizer(packageName, ".");
                    while (tok.hasMoreTokens()) {
                        String dirName = tok.nextToken();
                        classDir = new File(classDir, dirName);
                    }
                }
                if (!classDir.exists() && !classDir.mkdirs()) {
                    throw new MojoExecutionException("Unable to create class directories: " + classDir.getAbsolutePath());
                }
                if (this.generateInterface) {
                    CpoInterfaceSourceGenerator interfaceSourceGenerator = new CpoInterfaceSourceGenerator(metaDescriptor);
                    cpoClass.acceptMetaDFVisitor((MetaVisitor)interfaceSourceGenerator);
                    File interfaceFile = new File(classDir, interfaceSourceGenerator.getInterfaceName() + ".java");
                    this.getLog().info((CharSequence)("cpo-plugin generated " + interfaceFile.getAbsolutePath()));
                    FileWriter iw = new FileWriter(interfaceFile);
                    iw.write(interfaceSourceGenerator.getSourceCode());
                    iw.flush();
                    iw.close();
                }
                if (!this.generateClass) continue;
                Object classSourceGenerator = this.generateInterface ? new CpoClassSourceGenerator(metaDescriptor) : new CpoLegacyClassSourceGenerator(metaDescriptor);
                cpoClass.acceptMetaDFVisitor((MetaVisitor)classSourceGenerator);
                File javaFile = new File(classDir, classSourceGenerator.getClassName() + ".java");
                this.getLog().info((CharSequence)("cpo-plugin generated " + javaFile.getAbsolutePath()));
                FileWriter cw = new FileWriter(javaFile);
                cw.write(classSourceGenerator.getSourceCode());
                cw.flush();
                cw.close();
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Exception caught", ex);
        }
    }

    private static enum Scopes {
        test;

    }
}

