/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.configurator.AbstractComponentConfigurator;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ComponentConfigurator;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.composite.ObjectWithFieldsConverter;
import org.codehaus.plexus.component.configurator.converters.special.ClassRealmConverter;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=ComponentConfigurator.class, hint="include-project-dependencies")
public class IncludeProjectDependencies
extends AbstractComponentConfigurator {
    private static final Logger LOGGER = LoggerFactory.getLogger(IncludeProjectDependencies.class);

    public void configureComponent(Object component, PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator, ClassRealm containerRealm, ConfigurationListener listener) throws ComponentConfigurationException {
        this.addProjectDependenciesToClassRealm(expressionEvaluator, containerRealm);
        this.converterLookup.registerConverter((ConfigurationConverter)new ClassRealmConverter(containerRealm));
        ObjectWithFieldsConverter converter = new ObjectWithFieldsConverter();
        converter.processConfiguration(this.converterLookup, component, containerRealm.getClassLoader(), configuration, expressionEvaluator, listener);
    }

    private void addProjectDependenciesToClassRealm(ExpressionEvaluator expressionEvaluator, ClassRealm containerRealm) throws ComponentConfigurationException {
        URL[] urls;
        ArrayList<String> myClasspathElements = new ArrayList<String>();
        try {
            List runtimeClasspathElements = (List)expressionEvaluator.evaluate("${project.runtimeClasspathElements}");
            if (runtimeClasspathElements != null) {
                for (String elem : runtimeClasspathElements) {
                    myClasspathElements.add(elem);
                }
            }
        }
        catch (ExpressionEvaluationException e) {
            throw new ComponentConfigurationException("There was a problem evaluating: ${project.runtimeClasspathElements}", (Throwable)e);
        }
        for (URL url : urls = this.buildURLs(myClasspathElements)) {
            containerRealm.addConstituent(url);
        }
    }

    private URL[] buildURLs(List<String> runtimeClasspathElements) throws ComponentConfigurationException {
        ArrayList<URL> urls = new ArrayList<URL>(runtimeClasspathElements.size());
        for (String element : runtimeClasspathElements) {
            try {
                URL url = new File(element).toURI().toURL();
                urls.add(url);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Added to project class loader: " + url);
            }
            catch (MalformedURLException e) {
                throw new ComponentConfigurationException("Unable to access project dependency: " + element, (Throwable)e);
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }
}

