/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.util;

import java.util.HashSet;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.util.CpoRootNode;
import org.synchronoss.cpo.util.Proxy;

public abstract class AbstractCpoNode
extends DefaultMutableTreeNode {
    private boolean dirty = false;
    private boolean remove = false;
    private boolean isnew = false;
    private boolean isProtected = false;
    protected Set<AbstractCpoNode> dirtyChildren = new HashSet<AbstractCpoNode>();
    protected Set<AbstractCpoNode> newChildren = new HashSet<AbstractCpoNode>();
    protected Set<AbstractCpoNode> removeChildren = new HashSet<AbstractCpoNode>();

    public AbstractCpoNode() {
    }

    public AbstractCpoNode(Object userObject) {
        super(userObject);
    }

    public AbstractCpoNode(Object userObject, boolean allowsChildren) {
        super(userObject, allowsChildren);
    }

    @Override
    public AbstractCpoNode getParent() {
        return (AbstractCpoNode)super.getParent();
    }

    @Override
    public CpoRootNode getRoot() {
        return (CpoRootNode)super.getRoot();
    }

    public Proxy getProxy() {
        return this.getRoot().getUserObject();
    }

    public abstract JPanel getPanelForSelected();

    public String getToolTipText() {
        return this.toString();
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public void setProtected(boolean b) {
        this.isProtected = b;
    }

    public void setDirty(boolean dirty) {
        if (this.dirty == dirty) {
            return;
        }
        this.dirty = dirty;
        this.getProxy().nodeChanged(this, this);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setChildDirty(AbstractCpoNode childNode) {
        boolean notify = false;
        if (this.isChildDirty() != childNode.isDirty()) {
            notify = true;
        }
        if (childNode.isDirty()) {
            this.dirtyChildren.add(childNode);
        } else if (!childNode.isDirty()) {
            this.dirtyChildren.remove(childNode);
        }
        if (notify) {
            this.getProxy().nodeChanged(this, childNode);
        }
    }

    public boolean isChildDirty() {
        return !this.dirtyChildren.isEmpty();
    }

    public void setRemove(boolean remove) {
        if (this.remove == remove) {
            return;
        }
        this.remove = remove;
        this.getProxy().nodeChanged(this, this);
    }

    public void performRemove() throws CpoException {
    }

    public boolean isRemove() {
        return this.remove;
    }

    public void setChildRemove(AbstractCpoNode childNode) {
        if (childNode.isRemove() && childNode.isNew()) {
            this.removeChildren.remove(childNode);
            this.newChildren.remove(childNode);
            this.dirtyChildren.remove(childNode);
        } else if (childNode.isRemove()) {
            this.removeChildren.add(childNode);
        } else if (!childNode.isRemove()) {
            this.removeChildren.remove(childNode);
        }
        this.getProxy().nodeChanged(this, childNode);
    }

    public boolean isChildRemove() {
        return !this.removeChildren.isEmpty();
    }

    public void setNew(boolean isnew) {
        if (this.isnew == isnew) {
            return;
        }
        this.isnew = isnew;
        this.getProxy().nodeChanged(this, this);
    }

    public boolean isNew() {
        return this.isnew;
    }

    public void setChildNew(AbstractCpoNode childNode) {
        boolean notify = false;
        if (this.isChildNew() != childNode.isNew()) {
            notify = true;
        }
        if (childNode.isNew()) {
            this.newChildren.add(childNode);
        } else if (!childNode.isNew()) {
            this.newChildren.remove(childNode);
        }
        if (notify) {
            this.getProxy().nodeChanged(this, childNode);
        }
    }

    public boolean isChildNew() {
        return !this.newChildren.isEmpty();
    }
}

