/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.util;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreeNode;
import org.synchronoss.cpo.meta.domain.CpoArgument;
import org.synchronoss.cpo.meta.domain.CpoAttribute;
import org.synchronoss.cpo.util.CpoArgumentAttributeEditor;
import org.synchronoss.cpo.util.CpoArgumentNode;
import org.synchronoss.cpo.util.CpoAttributeLabelNode;
import org.synchronoss.cpo.util.CpoAttributeNode;
import org.synchronoss.cpo.util.CpoFunctionNode;
import org.synchronoss.cpo.util.CpoUtil;

public class CoreArgumentTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    protected CpoFunctionNode cpoFunctionNode;

    public CoreArgumentTableModel(CpoFunctionNode cpoFunctionNode) {
        this.cpoFunctionNode = cpoFunctionNode;
    }

    public void initTableEditors(JTable table) {
        table.setDefaultEditor(CpoAttribute.class, new CpoArgumentAttributeEditor(this));
    }

    public CpoFunctionNode getCpoFunctionNode() {
        return this.cpoFunctionNode;
    }

    public List<String> getColumnNames() {
        return Arrays.asList("Seq Num", "Attribute", "Data Name", "Data Type", "Transform Class", "Changed?");
    }

    public List<Class<?>> getColumnClasses() {
        Class[] columnClasses = new Class[]{String.class, CpoAttribute.class, String.class, String.class, String.class, String.class};
        return Arrays.asList(columnClasses);
    }

    @Override
    public int getRowCount() {
        return this.cpoFunctionNode.getChildCount();
    }

    @Override
    public int getColumnCount() {
        return this.getColumnNames().size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.getColumnNames().get(columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.getColumnClasses().get(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        CpoArgumentNode cpoArgumentNode = (CpoArgumentNode)this.cpoFunctionNode.getChildAt(rowIndex);
        CpoArgument argument = cpoArgumentNode.getUserObject();
        CpoAttribute att = argument.getAttribute();
        if (columnIndex == 0) {
            return this.cpoFunctionNode.getIndex(cpoArgumentNode);
        }
        if (columnIndex == 1) {
            return cpoArgumentNode.getCpoAttribute();
        }
        if (columnIndex == 2) {
            return att != null ? att.getDataName() : null;
        }
        if (columnIndex == 3) {
            return att != null ? att.getDataType() : null;
        }
        if (columnIndex == 4) {
            return att != null ? att.getTransformClassName() : null;
        }
        if (columnIndex == 5) {
            if (cpoArgumentNode.isNew()) {
                return "New";
            }
            if (cpoArgumentNode.isRemove()) {
                return "Removed";
            }
            if (cpoArgumentNode.isDirty()) {
                return "Changed";
            }
            return "";
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            CpoArgumentNode cpoArgumentNode = (CpoArgumentNode)this.cpoFunctionNode.getChildAt(rowIndex);
            cpoArgumentNode.setCpoAttribute((CpoAttribute)aValue);
        }
        this.fireTableDataChanged();
    }

    public void removeNewRow() {
        CpoArgumentNode cpoArgumentNode;
        int i;
        int originalLength = this.getNonRemovedRows();
        for (i = this.cpoFunctionNode.getChildCount() - 1; i >= 0; --i) {
            cpoArgumentNode = (CpoArgumentNode)this.cpoFunctionNode.getChildAt(i);
            if (!cpoArgumentNode.isNew()) continue;
            cpoArgumentNode.setRemove(true);
            this.fireTableDataChanged();
            return;
        }
        if (this.getNonRemovedRows() == originalLength) {
            for (i = this.cpoFunctionNode.getChildCount() - 1; i >= 0; --i) {
                cpoArgumentNode = (CpoArgumentNode)this.cpoFunctionNode.getChildAt(i);
                if (cpoArgumentNode.isRemove()) continue;
                this.removeRow(i);
                return;
            }
        }
    }

    public void removeRow(int rowIndex) {
        CpoArgumentNode cpoArgumentNode = (CpoArgumentNode)this.cpoFunctionNode.getChildAt(rowIndex);
        cpoArgumentNode.setRemove(true);
        this.fireTableDataChanged();
    }

    public void addNewRow() {
        int originalLength = this.getNonRemovedRows();
        Enumeration<TreeNode> e = this.cpoFunctionNode.children();
        while (e.hasMoreElements()) {
            CpoArgumentNode cpoArgumentNode = (CpoArgumentNode)e.nextElement();
            if (!cpoArgumentNode.isRemove()) continue;
            cpoArgumentNode.setRemove(false);
            this.fireTableDataChanged();
            return;
        }
        if (this.getNonRemovedRows() == originalLength) {
            try {
                CpoArgumentNode cpoArgumentNode;
                CpoAttributeLabelNode attributeLabelNode = this.cpoFunctionNode.getParent().getParent().getParent().getAttributeLabelNode();
                CpoAttribute firstAttribute = null;
                if (attributeLabelNode.getChildCount() > 0) {
                    CpoAttributeNode firstAttributeNode = (CpoAttributeNode)attributeLabelNode.getFirstChild();
                    firstAttribute = firstAttributeNode.getUserObject();
                }
                if ((cpoArgumentNode = this.cpoFunctionNode.getProxy().addArgument(this.cpoFunctionNode, firstAttribute)) != null) {
                    this.fireTableDataChanged();
                }
            }
            catch (Exception pe) {
                CpoUtil.showException(pe);
            }
        }
    }

    public int getNonRemovedRows() {
        int count = 0;
        Enumeration<TreeNode> e = this.cpoFunctionNode.children();
        while (e.hasMoreElements()) {
            CpoArgumentNode cpoArgumentNode = (CpoArgumentNode)e.nextElement();
            if (cpoArgumentNode.isRemove()) continue;
            ++count;
        }
        return count;
    }
}

