/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.util;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.util.CpoUtil;

public class CpoEditConnPanel
extends JPanel {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long serialVersionUID = 1L;
    private JComboBox connectionComboBox = new JComboBox();

    public CpoEditConnPanel() {
        this.refreshConnectionList();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.connectionComboBox, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JButton editButton = new JButton("Edit");
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CpoEditConnPanel.this.editConnection();
            }
        });
        this.add((Component)editButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JButton deleteButton = new JButton("Delete");
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CpoEditConnPanel.this.deleteConnection();
            }
        });
        this.add((Component)deleteButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void editConnection() {
        String connectionName = (String)this.connectionComboBox.getSelectedItem();
        if (connectionName == null) {
            return;
        }
        CpoUtil.getInstance().editConnection(connectionName);
        this.refreshConnectionList();
    }

    private void deleteConnection() {
        String connectionName = (String)this.connectionComboBox.getSelectedItem();
        if (connectionName == null) {
            return;
        }
        String message = "Are you sure you want to delete the connection: " + connectionName;
        int result = JOptionPane.showConfirmDialog(CpoUtil.getInstance(), message, "Delete Connection", 0, 3);
        if (result == 0) {
            CpoUtil.getInstance().removeConnection(connectionName);
            this.refreshConnectionList();
        }
    }

    protected void refreshConnectionList() {
        this.connectionComboBox.setModel(new DefaultComboBoxModel<String>(CpoUtil.getInstance().getConnectionList()));
    }
}

