/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.util.Proxy;

public class CpoNewClassPanel
extends JPanel {
    private static Logger logger = LoggerFactory.getLogger(CpoNewClassPanel.class);
    private static final long serialVersionUID = 1L;
    private JTextField jTextClassName = new JTextField();
    private JCheckBox genSrcCheckBox = new JCheckBox();
    private JTextArea jTextAreaExpression = new JTextArea();
    private JComboBox connectionComboBox = new JComboBox();

    public CpoNewClassPanel(Proxy proxy) {
        this(proxy, null);
    }

    public CpoNewClassPanel(Proxy proxy, String className) {
        try {
            this.connectionComboBox.setModel(new DefaultComboBoxModel<String>(proxy.getConnectionList()));
            this.jbInit();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (className != null) {
            this.jTextClassName.setText(className);
        } else if (proxy.getDefaultPackageName() != null) {
            this.jTextClassName.setText(proxy.getDefaultPackageName());
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        JLabel jLabClassName = new JLabel("Class Name:");
        this.add((Component)jLabClassName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jTextClassName.setMinimumSize(new Dimension(300, 20));
        this.jTextClassName.setPreferredSize(new Dimension(300, 20));
        this.add((Component)this.jTextClassName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        JLabel jLabGenerateSource = new JLabel("Generate Source:");
        this.add((Component)jLabGenerateSource, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.genSrcCheckBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        JLabel jLabConnection = new JLabel("Connection:");
        this.add((Component)jLabConnection, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.connectionComboBox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        JLabel jLabExpression = new JLabel("Initialization Expression:");
        this.add((Component)jLabExpression, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 12, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jTextAreaExpression.setLineWrap(true);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add((Component)this.jTextAreaExpression, null);
        jScrollPane.setPreferredSize(new Dimension(300, 200));
        this.add((Component)jScrollPane, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
    }

    public String getClassName() {
        return this.jTextClassName.getText();
    }

    public boolean isGenerateSource() {
        return this.genSrcCheckBox.isSelected();
    }

    public String getExpression() {
        return this.jTextAreaExpression.getText();
    }

    public String getConnection() {
        if (this.connectionComboBox.getSelectedIndex() != -1) {
            return (String)this.connectionComboBox.getSelectedItem();
        }
        return null;
    }
}

