/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.core.cpoCoreConfig.CtDataSourceConfig;
import org.synchronoss.cpo.helper.XmlBeansHelper;
import org.synchronoss.cpo.meta.domain.CpoClass;
import org.synchronoss.cpo.util.AboutBoxPanel;
import org.synchronoss.cpo.util.AbstractConnectionPanel;
import org.synchronoss.cpo.util.CaseInsensitiveStringComparator;
import org.synchronoss.cpo.util.CpoBrowserPanel;
import org.synchronoss.cpo.util.CpoBrowserTree;
import org.synchronoss.cpo.util.CpoEditConnPanel;
import org.synchronoss.cpo.util.CpoUtilClassLoader;
import org.synchronoss.cpo.util.CpoUtilClasspathPanel;
import org.synchronoss.cpo.util.ExceptionPanel;
import org.synchronoss.cpo.util.Proxy;
import org.synchronoss.cpo.util.ProxyFactory;
import org.synchronoss.cpo.util.SupportedType;
import org.synchronoss.cpo.util.UrlLoader;
import org.synchronoss.cpo.util.conversion.ConvertCpoUtilLocalProperties;
import org.synchronoss.cpo.util.cpoUtilConfig.CpoUtilConfigDocument;
import org.synchronoss.cpo.util.cpoUtilConfig.CtCpoUtilConfig;

public class CpoUtil
extends JFrame {
    private static Logger logger = LoggerFactory.getLogger(CpoUtil.class);
    private static URL mainIcon = CpoBrowserTree.class.getResource("/images/sync-logo-sm.gif");
    private static ImageIcon closeIcon = new ImageIcon(CpoBrowserTree.class.getResource("/images/close.png"));
    private static final String CPOUTIL_CONFIG_DIRNAME = ".cpoutil";
    private static final File CPOUTIL_CONFIG_DIR = new File(System.getProperties().getProperty("user.home"), ".cpoutil");
    private static final String CPOUTIL_CONFIG_FILE = "CpoUtilConfig.xml";
    private static final File configFile = new File(CPOUTIL_CONFIG_DIR, "CpoUtilConfig.xml");
    private static final String CPOUTIL_PROPERTIES_FILE = "cpoutil.properties";
    private static final String BOOTSTRAP_URL_PROP = "cpoutil.bootstrapUrl";
    private static final String PROTECTED_CLASS_PROP = "cpoutil.protectedClasses";
    public static final String TITLE = "cpoutil.title";
    public static final String VERSION = "cpoutil.version";
    public static final String AUTHOR = "cpoutil.author";
    public static final String COPYRIGHT = "cpoutil.copyright";
    public static final String COMPANY = "cpoutil.company";
    public static final String MINIMUM_VERSION = "cpoutil.minimumVersion";
    private static final String SNAPSHOT = "-SNAPSHOT";
    private CtCpoUtilConfig cpoUtilConfig = null;
    private Properties props = new Properties();
    private static CpoUtil cpoUtil;
    private Set<String> protectedClasses = new HashSet<String>();
    private JLabel statusBar = new JLabel();
    protected JTabbedPane jTabbedPane = new JTabbedPane();
    private int tabCounter = 0;

    public static CpoUtil getInstance() {
        return cpoUtil;
    }

    protected CpoUtil() {
        this.loadConfig();
        this.checkKillSwitch();
        this.loadProtectedClasses();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CpoUtil.this.exit();
            }
        });
        this.setVisible(true);
    }

    private void jbInit() throws Exception {
        this.setIconImage(Toolkit.getDefaultToolkit().createImage(mainIcon));
        this.getContentPane().setLayout(new BorderLayout());
        this.setSize(new Dimension(1000, 800));
        this.setTitle("CPO Utility");
        JPanel panelCenter = new JPanel();
        panelCenter.setLayout(new BorderLayout());
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menuFile = new JMenu("File");
        menuBar.add(menuFile);
        JMenu newMenu = new JMenu("New");
        menuFile.add(newMenu);
        for (final SupportedType type : SupportedType.values()) {
            JMenuItem typeMenu = new JMenuItem(type.toString());
            newMenu.add(typeMenu);
            typeMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    CpoUtil.this.newMetaFile(type);
                }
            });
        }
        JMenuItem menuOpen = new JMenuItem("Open");
        menuOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CpoUtil.this.openActionPerformed();
            }
        });
        menuFile.add(menuOpen);
        JMenuItem menuSave = new JMenuItem("Save");
        menuSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CpoUtil.this.saveActionPerformed();
            }
        });
        menuFile.add(menuSave);
        JMenuItem menuSaveAs = new JMenuItem("Save As");
        menuSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CpoUtil.this.saveAsActionPerformed();
            }
        });
        menuFile.add(menuSaveAs);
        JMenuItem menuExit = new JMenuItem("Exit");
        menuExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CpoUtil.this.exit();
            }
        });
        menuFile.add(menuExit);
        JMenu menuConnections = new JMenu("Connections");
        menuBar.add(menuConnections);
        JMenu newConnectionMenu = new JMenu("New");
        menuConnections.add(newConnectionMenu);
        for (final SupportedType type : SupportedType.values()) {
            JMenuItem typeMenu = new JMenuItem(type.toString());
            newConnectionMenu.add(typeMenu);
            typeMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    CpoUtil.this.newConnection(type);
                }
            });
        }
        JMenuItem menuEditCon = new JMenuItem("Edit Connections");
        menuEditCon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    CpoUtil.this.editConActionPerformed();
                }
                catch (Exception e) {
                    CpoUtil.showException(e);
                }
            }
        });
        menuConnections.add(menuEditCon);
        JMenu menuTools = new JMenu("Tools");
        menuBar.add(menuTools);
        JMenuItem menuClasspath = new JMenuItem("Set Custom Classpath");
        menuClasspath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CpoUtil.this.setCustomClasspath("Set Custom Classpath");
            }
        });
        menuTools.add(menuClasspath);
        JMenuItem menuUnloadLoader = new JMenuItem("Unload Classloader");
        menuUnloadLoader.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CpoUtil.this.unloadCustomClassLoader();
            }
        });
        menuTools.add(menuUnloadLoader);
        JMenu menuHelp = new JMenu("Help");
        menuBar.add(menuHelp);
        JMenuItem menuHelpAbout = new JMenuItem("About");
        menuHelpAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CpoUtil.this.aboutActionPerformed();
            }
        });
        menuHelp.add(menuHelpAbout);
        this.statusBar.setText("");
        this.getContentPane().add((Component)this.statusBar, "South");
        panelCenter.add((Component)this.jTabbedPane, "Center");
        this.getContentPane().add((Component)panelCenter, "Center");
    }

    private void newMetaFile(SupportedType type) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "XML files";
            }

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".xml");
            }
        });
        int result = jFileChooser.showSaveDialog(this);
        if (result == 1) {
            return;
        }
        try {
            Proxy proxy = ProxyFactory.getInstance().newProxy(jFileChooser.getSelectedFile(), type);
            this.createNewBrowser(proxy);
        }
        catch (CpoException ex) {
            CpoUtil.showException(ex);
        }
    }

    private void openActionPerformed() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "XML files";
            }

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".xml");
            }
        });
        int result = jFileChooser.showOpenDialog(this);
        if (result == 1) {
            return;
        }
        File cpoMetaXml = jFileChooser.getSelectedFile();
        if (cpoMetaXml == null || !cpoMetaXml.canRead()) {
            CpoUtil.showErrorMessage("Invalid file selected.");
            return;
        }
        int tabCount = this.jTabbedPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            CpoBrowserPanel panel = (CpoBrowserPanel)this.jTabbedPane.getComponentAt(i);
            if (!cpoMetaXml.equals(panel.getProxy().getCpoMetaXml())) continue;
            CpoUtil.showErrorMessage("The selected file is already open: " + cpoMetaXml.getAbsolutePath());
            return;
        }
        try {
            Proxy proxy = ProxyFactory.getInstance().getProxy(cpoMetaXml);
            this.createNewBrowser(proxy);
        }
        catch (CpoException ex) {
            CpoUtil.showException(ex);
        }
    }

    private void createNewBrowser(Proxy proxy) {
        try {
            CpoBrowserPanel browserPanel = new CpoBrowserPanel(proxy);
            this.jTabbedPane.addTab(browserPanel.getProxy().toString(), null, browserPanel, browserPanel.getProxy().toString());
            this.jTabbedPane.setSelectedComponent(browserPanel);
            JButton tabCloseButton = new JButton(closeIcon);
            tabCloseButton.setContentAreaFilled(false);
            tabCloseButton.setBorderPainted(false);
            tabCloseButton.setActionCommand(Integer.toString(this.tabCounter++));
            tabCloseButton.setMaximumSize(new Dimension(16, 16));
            tabCloseButton.setMinimumSize(new Dimension(16, 16));
            tabCloseButton.setPreferredSize(new Dimension(16, 16));
            ActionListener al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    JButton btn = (JButton)ae.getSource();
                    String s1 = btn.getActionCommand();
                    for (int i = 0; i < CpoUtil.this.jTabbedPane.getTabCount(); ++i) {
                        JPanel pnl = (JPanel)CpoUtil.this.jTabbedPane.getTabComponentAt(i);
                        btn = (JButton)pnl.getComponent(1);
                        String s2 = btn.getActionCommand();
                        if (!s1.equals(s2)) continue;
                        if (CpoUtil.this.checkUnsavedData("You have unsaved data, are you sure you wish to exit??", i)) break;
                        CpoUtil.this.jTabbedPane.removeTabAt(i);
                        break;
                    }
                }
            };
            tabCloseButton.addActionListener(al);
            JPanel pnl = new JPanel(new GridBagLayout());
            pnl.setOpaque(false);
            pnl.add((Component)new JLabel(browserPanel.getProxy().toString()), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnl.add((Component)tabCloseButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jTabbedPane.setTabComponentAt(this.jTabbedPane.getTabCount() - 1, pnl);
            this.jTabbedPane.setSelectedIndex(this.jTabbedPane.getTabCount() - 1);
        }
        catch (CpoException ex) {
            CpoUtil.showException(ex);
        }
    }

    private void saveActionPerformed() {
        int index = this.jTabbedPane.getSelectedIndex();
        if (index != -1) {
            this.save(null);
        }
    }

    private void saveAsActionPerformed() {
        int index = this.jTabbedPane.getSelectedIndex();
        if (index != -1) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setFileFilter(new FileFilter(){

                @Override
                public String getDescription() {
                    return "XML files";
                }

                @Override
                public boolean accept(File f) {
                    return f.getName().toLowerCase().endsWith(".xml");
                }
            });
            int result = jFileChooser.showSaveDialog(this);
            if (result == 1) {
                return;
            }
            this.save(jFileChooser.getSelectedFile());
        }
    }

    private void save(File file) {
        CpoBrowserPanel cbp;
        int index = this.jTabbedPane.getSelectedIndex();
        if (index != -1 && (cbp = (CpoBrowserPanel)this.jTabbedPane.getComponentAt(index)) != null) {
            cbp.save(file);
        }
    }

    private void aboutActionPerformed() {
        JOptionPane.showMessageDialog(this, new AboutBoxPanel(), "About", -1);
    }

    private void newConnection(SupportedType type) {
        try {
            AbstractConnectionPanel panel = type.getConnectionPanelClass().newInstance();
            panel.newDataSourceConfig();
            String title = "Create " + panel.getTitle();
            int result = 0;
            boolean complete = false;
            while (result == 0 && !complete) {
                result = JOptionPane.showConfirmDialog(this, panel, title, 2);
                if (result != 0) continue;
                try {
                    CtDataSourceConfig dataSourceConfig = panel.createDataSourceConfig();
                    if (!this.cpoUtilConfig.isSetDataConfigs()) {
                        this.cpoUtilConfig.addNewDataConfigs();
                    }
                    CtDataSourceConfig dsc = this.cpoUtilConfig.getDataConfigs().addNewDataConfig();
                    dsc.set((XmlObject)dataSourceConfig);
                    this.saveConfig();
                    complete = true;
                }
                catch (CpoException ex) {
                    CpoUtil.showErrorMessage(ex.getMessage());
                }
            }
        }
        catch (Exception ex) {
            CpoUtil.showException(ex);
        }
    }

    protected void editConnection(String connectionName) {
        CtDataSourceConfig dataSourceConfig = this.getDataSourceConfig(connectionName);
        if (dataSourceConfig == null) {
            CpoUtil.showErrorMessage("Can't find data source config for connection: " + connectionName);
            return;
        }
        try {
            SupportedType type = SupportedType.getTypeForConnection(dataSourceConfig);
            AbstractConnectionPanel panel = type.getConnectionPanelClass().newInstance();
            panel.setDataSourceConfig(dataSourceConfig);
            String title = "Edit " + panel.getTitle();
            int result = 0;
            boolean complete = false;
            while (result == 0 && !complete) {
                result = JOptionPane.showConfirmDialog(this, panel, title, 2);
                if (result != 0) continue;
                try {
                    CtDataSourceConfig panelDsc = panel.createDataSourceConfig();
                    for (CtDataSourceConfig dsc : this.cpoUtilConfig.getDataConfigs().getDataConfigArray()) {
                        if (!dsc.getName().equals(dataSourceConfig.getName())) continue;
                        dsc.set((XmlObject)panelDsc);
                        complete = true;
                        this.saveConfig();
                    }
                    if (complete) continue;
                    throw new CpoException("Saving connection failed, could not update connection: " + connectionName);
                }
                catch (CpoException ex) {
                    CpoUtil.showErrorMessage(ex.getMessage());
                }
            }
        }
        catch (Exception ex) {
            CpoUtil.showException(ex);
        }
    }

    private void editConActionPerformed() {
        CpoEditConnPanel cecp = new CpoEditConnPanel();
        JOptionPane.showConfirmDialog(this, cecp, "Edit Connections", 2, 3);
    }

    private void unloadCustomClassLoader() {
        CpoUtilClassLoader.unloadLoader();
        this.setStatusBarText("Classloader Unloaded - Meta Cache Refreshed On All Connected Servers");
    }

    public void setStatusBarText(String txt) {
        this.statusBar.setText(txt);
    }

    public String getProperty(String propertyName) {
        return this.props.getProperty(propertyName);
    }

    protected void loadConfig() {
        block14: {
            try {
                if (!configFile.exists()) {
                    CpoUtilConfigDocument cpoUtilConfigDocument = CpoUtilConfigDocument.Factory.newInstance();
                    try {
                        this.cpoUtilConfig = ConvertCpoUtilLocalProperties.convert();
                    }
                    catch (CpoException ex) {
                        CpoUtil.showException(ex);
                    }
                    if (this.cpoUtilConfig == null) {
                        this.cpoUtilConfig = cpoUtilConfigDocument.addNewCpoUtilConfig();
                    }
                    this.saveConfig();
                } else {
                    CpoUtilConfigDocument cpoUtilConfigDocument = CpoUtilConfigDocument.Factory.parse(configFile);
                    this.cpoUtilConfig = cpoUtilConfigDocument.getCpoUtilConfig();
                }
                InputStream is = this.getClass().getResourceAsStream("/cpoutil.properties");
                if (is == null) {
                    throw new IOException("Could not find properties file!\nCPU Util will exit now.");
                }
                this.props.load(is);
                String bootstrapUrl = this.props.getProperty(BOOTSTRAP_URL_PROP);
                if (bootstrapUrl == null || bootstrapUrl.isEmpty()) break block14;
                if (logger.isDebugEnabled()) {
                    logger.debug("Bootstrap Url: " + bootstrapUrl);
                }
                try {
                    UrlLoader loader = new UrlLoader(bootstrapUrl);
                    Thread thread = new Thread(loader);
                    thread.start();
                    thread.join(3000L);
                    InputStream in = loader.getInputStream();
                    if (in != null) {
                        this.props.load(in);
                        in.close();
                    }
                }
                catch (Exception ex) {
                    logger.error("Exception caught reading bootstrap properties: " + ex);
                }
            }
            catch (MalformedURLException mue) {
                CpoUtil.showException(mue);
                System.exit(1);
            }
            catch (IOException ex) {
                CpoUtil.showException(ex);
                System.exit(1);
            }
            catch (XmlException ex) {
                CpoUtil.showException(ex);
                System.exit(1);
            }
        }
    }

    private void saveConfig() {
        if (!CPOUTIL_CONFIG_DIR.exists()) {
            CPOUTIL_CONFIG_DIR.mkdir();
        }
        CpoUtilConfigDocument doc = CpoUtilConfigDocument.Factory.newInstance();
        CtCpoUtilConfig config = doc.addNewCpoUtilConfig();
        config.set(this.cpoUtilConfig);
        try {
            doc.save(configFile, XmlBeansHelper.getXmlOptions());
        }
        catch (Exception ex) {
            CpoUtil.showException(ex);
        }
    }

    private void checkKillSwitch() {
        String minimumVersion = this.props.getProperty(MINIMUM_VERSION);
        if (logger.isDebugEnabled()) {
            logger.debug("Minimum version: " + minimumVersion);
        }
        if (minimumVersion != null) {
            int idxSecondDot;
            int idxFirstDot;
            String version = this.props.getProperty(VERSION);
            if (version.endsWith(SNAPSHOT)) {
                version = version.substring(0, version.length() - SNAPSHOT.length());
            }
            if ((idxFirstDot = version.indexOf(".")) != -1 && (idxSecondDot = version.indexOf(".", idxFirstDot + 1)) != -1) {
                version = version.substring(0, idxSecondDot);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Version: " + version);
            }
            double min = 0.0;
            try {
                min = Double.parseDouble(minimumVersion);
            }
            catch (NumberFormatException ex) {
                logger.error(ex.getMessage());
            }
            double actual = 0.0;
            try {
                actual = Double.parseDouble(version);
            }
            catch (NumberFormatException ex) {
                logger.error(ex.getMessage());
            }
            if (actual < min) {
                CpoUtil.showMessage("Your version (" + this.props.getProperty(VERSION) + ") is outdated.\nPlease upgrade to at least version " + minimumVersion);
                System.exit(2);
            }
        }
    }

    private void loadProtectedClasses() {
        Set<String> protClasses;
        if (this.props == null) {
            return;
        }
        String url = this.props.getProperty(PROTECTED_CLASS_PROP);
        if (logger.isDebugEnabled()) {
            logger.debug("Protected Classes Url: " + url);
        }
        if ((protClasses = this.loadProtectedClassesFromUrl(url)) != null) {
            logger.debug("Connected to url, loading classes");
            this.protectedClasses.addAll(protClasses);
            this.saveProtectedClasses();
        } else {
            logger.debug("Couldn't connect to url, so loading local copy");
            if (this.cpoUtilConfig.isSetProtectedClasses()) {
                this.protectedClasses.addAll(Arrays.asList(this.cpoUtilConfig.getProtectedClasses().getProtectedClassArray()));
            }
        }
    }

    private Set<String> loadProtectedClassesFromUrl(String url) {
        if (url == null) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Url: " + url);
            }
            UrlLoader loader = new UrlLoader(url);
            Thread thread = new Thread(loader);
            thread.start();
            thread.join(3000L);
            InputStream in = loader.getInputStream();
            if (in != null) {
                String inputLine;
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                while ((inputLine = br.readLine()) != null) {
                    result.add(inputLine);
                }
                br.close();
                in.close();
            }
            return result;
        }
        catch (Exception ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("Exception caught reading from url: " + ex);
            }
            return null;
        }
    }

    private void saveProtectedClasses() {
        if (this.protectedClasses == null) {
            return;
        }
        if (this.cpoUtilConfig.isSetProtectedClasses()) {
            this.cpoUtilConfig.unsetProtectedClasses();
        }
        this.cpoUtilConfig.addNewProtectedClasses();
        for (String pc : this.protectedClasses) {
            this.cpoUtilConfig.getProtectedClasses().addProtectedClass(pc);
        }
        this.saveConfig();
    }

    protected List<File> getCustomClasspathEntries() {
        ArrayList<File> files = new ArrayList<File>();
        if (this.cpoUtilConfig.isSetCustomClasspath()) {
            for (String classpathEntry : this.cpoUtilConfig.getCustomClasspath().getClasspathEntryArray()) {
                files.add(new File(classpathEntry));
            }
        }
        return files;
    }

    public void setCustomClasspath(String message) {
        CpoUtilClasspathPanel cpp = new CpoUtilClasspathPanel(this.getCustomClasspathEntries());
        int result = JOptionPane.showConfirmDialog(this, cpp, message, 2, -1);
        if (result == 0) {
            List<File> classpathEntries = cpp.getClasspathEntries();
            this.cpoUtilConfig.unsetCustomClasspath();
            if (!classpathEntries.isEmpty()) {
                this.cpoUtilConfig.addNewCustomClasspath();
                for (File f : classpathEntries) {
                    this.cpoUtilConfig.getCustomClasspath().addClasspathEntry(f.getAbsolutePath());
                }
            }
            this.saveConfig();
            this.unloadCustomClassLoader();
        }
    }

    public List<CtDataSourceConfig> getDataSourceConfigs() {
        ArrayList<CtDataSourceConfig> result = new ArrayList<CtDataSourceConfig>();
        if (this.cpoUtilConfig.isSetDataConfigs()) {
            result.addAll(Arrays.asList(this.cpoUtilConfig.getDataConfigs().getDataConfigArray()));
        }
        return result;
    }

    public CtDataSourceConfig getDataSourceConfig(String name) {
        if (this.cpoUtilConfig.isSetDataConfigs()) {
            for (CtDataSourceConfig dataSourceConfig : this.cpoUtilConfig.getDataConfigs().getDataConfigArray()) {
                if (!dataSourceConfig.getName().equals(name)) continue;
                return dataSourceConfig;
            }
        }
        return null;
    }

    protected Vector<String> getConnectionList() {
        Vector<String> result = new Vector<String>();
        for (CtDataSourceConfig dataSourceConfig : this.getDataSourceConfigs()) {
            result.add(dataSourceConfig.getName());
        }
        Collections.sort(result, new CaseInsensitiveStringComparator());
        return result;
    }

    protected void addConnection(CtDataSourceConfig dataSourceConfig) {
        if (!this.cpoUtilConfig.isSetDataConfigs()) {
            this.cpoUtilConfig.addNewDataConfigs();
        }
        CtDataSourceConfig cdsc = this.cpoUtilConfig.getDataConfigs().addNewDataConfig();
        cdsc.set((XmlObject)dataSourceConfig);
        this.saveConfig();
    }

    protected void removeConnection(String connectionName) {
        int index = 0;
        int connectionNameIndex = -1;
        for (CtDataSourceConfig dataSourceConfig : this.cpoUtilConfig.getDataConfigs().getDataConfigArray()) {
            if (dataSourceConfig.getName().equals(connectionName)) {
                connectionNameIndex = index;
            }
            ++index;
        }
        this.cpoUtilConfig.getDataConfigs().removeDataConfig(connectionNameIndex);
        this.saveConfig();
    }

    public boolean checkUnsavedData(String message) {
        return this.checkUnsavedData(message, -1);
    }

    public boolean checkUnsavedData(String message, int tabIdx) {
        int result;
        boolean unsavedData = false;
        int tabCount = this.jTabbedPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            CpoBrowserPanel panel = (CpoBrowserPanel)this.jTabbedPane.getComponentAt(i);
            if (tabIdx != -1 && tabIdx != i || !panel.hasUnsavedData()) continue;
            unsavedData = true;
        }
        if (unsavedData && (result = JOptionPane.showConfirmDialog(this, message, "Cpo Utility - Unsaved Data", 0, 3)) == 0) {
            unsavedData = false;
        }
        return unsavedData;
    }

    public boolean isClassProtected(CpoClass cpoClass) {
        String className = cpoClass.getName();
        if (this.protectedClasses.contains(className)) {
            return true;
        }
        for (String s : this.protectedClasses) {
            if (!className.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    private void exit() {
        if (this.checkUnsavedData("You have unsaved data, are you sure you wish to exit??")) {
            return;
        }
        System.exit(0);
    }

    public static void showException(Throwable e) {
        if (logger.isDebugEnabled()) {
            logger.debug("Exception caught", e);
        }
        JOptionPane.showMessageDialog(CpoUtil.getInstance(), new ExceptionPanel(e), "Exception Caught!", -1);
    }

    public static void showMessage(String message) {
        JOptionPane.showMessageDialog(CpoUtil.getInstance(), message);
    }

    public static void showErrorMessage(String message) {
        JOptionPane.showMessageDialog(CpoUtil.getInstance(), message, "Error", 0);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        Policy.setPolicy(new Policy(){

            @Override
            public PermissionCollection getPermissions(CodeSource codesource) {
                Permissions perms = new Permissions();
                perms.add(new AllPermission());
                return perms;
            }

            @Override
            public void refresh() {
            }
        });
        cpoUtil = new CpoUtil();
    }
}

