/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.util;

import org.synchronoss.cpo.MetaVisitor;
import org.synchronoss.cpo.meta.domain.CpoArgument;
import org.synchronoss.cpo.meta.domain.CpoAttribute;
import org.synchronoss.cpo.meta.domain.CpoClass;
import org.synchronoss.cpo.meta.domain.CpoFunction;
import org.synchronoss.cpo.meta.domain.CpoFunctionGroup;
import org.synchronoss.cpo.util.CpoArgumentNode;
import org.synchronoss.cpo.util.CpoAttributeNode;
import org.synchronoss.cpo.util.CpoClassNode;
import org.synchronoss.cpo.util.CpoFunctionGroupNode;
import org.synchronoss.cpo.util.CpoFunctionNode;
import org.synchronoss.cpo.util.CpoRootNode;
import org.synchronoss.cpo.util.CpoUtil;

public class JTreeMetaVisitor
implements MetaVisitor {
    protected CpoRootNode rootNode;
    protected CpoClassNode currentClassNode;
    protected CpoFunctionGroupNode currentFunctionGroupNode;
    protected CpoFunctionNode currentFunctionNode;

    public JTreeMetaVisitor(CpoRootNode rootNode) {
        this.rootNode = rootNode;
    }

    public void visit(CpoClass cpoClass) {
        CpoClassNode classNode = this.rootNode.getProxy().createClassNode(cpoClass);
        classNode.setProtected(CpoUtil.getInstance().isClassProtected(cpoClass));
        this.rootNode.add(classNode);
        this.currentClassNode = classNode;
    }

    public void visit(CpoAttribute cpoAttribute) {
        if (this.currentClassNode != null) {
            CpoAttributeNode attributeNode = this.rootNode.getProxy().createAttributeNode(cpoAttribute);
            this.currentClassNode.getAttributeLabelNode().add(attributeNode);
        }
    }

    public void visit(CpoFunctionGroup cpoFunctionGroup) {
        if (this.currentClassNode != null) {
            CpoFunctionGroupNode functionGroupNode = this.rootNode.getProxy().createFunctionGroupNode(cpoFunctionGroup);
            this.currentClassNode.getFunctionGroupLabelNode().add(functionGroupNode);
            this.currentFunctionGroupNode = functionGroupNode;
        }
    }

    public void visit(CpoFunction cpoFunction) {
        if (this.currentFunctionGroupNode != null) {
            CpoFunctionNode functionNode = this.rootNode.getProxy().createFunctionNode(cpoFunction);
            this.currentFunctionGroupNode.add(functionNode);
            this.currentFunctionNode = functionNode;
        }
    }

    public void visit(CpoArgument cpoArgument) {
        if (this.currentFunctionNode != null) {
            CpoArgumentNode argumentNode = this.rootNode.getProxy().createArgumentNode(cpoArgument);
            this.currentFunctionNode.add(argumentNode);
        }
    }
}

