/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.tree.TreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.GUID;
import org.synchronoss.cpo.core.cpoCoreMeta.StFunctionGroupType;
import org.synchronoss.cpo.util.CpoClassNode;
import org.synchronoss.cpo.util.CpoFunctionGroupNode;
import org.synchronoss.cpo.util.CpoRootNode;
import org.synchronoss.cpo.util.CpoUtil;
import org.synchronoss.cpo.util.CpoUtilClassLoader;
import org.synchronoss.cpo.util.TableSorter;
import org.synchronoss.cpo.util.TesterParamModel;
import org.synchronoss.cpo.util.TesterResultsModel;

public class TesterPanel
extends JPanel
implements ClipboardOwner {
    private static final long serialVersionUID = 1L;
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SS");
    private static SimpleDateFormat sdfDateOnly = new SimpleDateFormat("yyyy-MM-dd");
    private JComboBox connectionComboBox = new JComboBox();
    private JComboBox jComFunctionGroup = new JComboBox();
    private JTable jTableParam = new JTable();
    private JButton jButExec = new JButton();
    private JCheckBox jCheckPersist = new JCheckBox();
    private JComboBox jComClassOut = new JComboBox();
    private JTable jTableResults = new JTable();
    private CpoClassNode cpoClassNode;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public TesterPanel(CpoClassNode cpoClassNode) {
        this.cpoClassNode = cpoClassNode;
        try {
            this.connectionComboBox.setModel(new DefaultComboBoxModel<String>(cpoClassNode.getProxy().getConnectionList()));
            this.jbInit();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        Enumeration<TreeNode> enumFG = cpoClassNode.getFunctionGroupLabelNode().children();
        while (enumFG.hasMoreElements()) {
            this.jComFunctionGroup.addItem(enumFG.nextElement());
        }
        this.setTableCellSize();
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        JLabel jLabConnction = new JLabel("Connection:");
        this.add((Component)jLabConnction, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.connectionComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jButExec.setText("Execute");
        this.jButExec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TesterPanel.this.executeFunctionGroup();
            }
        });
        this.add((Component)this.jButExec, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabFunctionGroup = new JLabel("Function Group:");
        this.add((Component)jLabFunctionGroup, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jComFunctionGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TesterPanel.this.functionGroupActionPerformed();
            }
        });
        this.add((Component)this.jComFunctionGroup, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jCheckPersist.setText("Persist");
        this.jCheckPersist.setEnabled(false);
        this.jCheckPersist.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TesterPanel.this.checkPersistActionPerformed();
            }
        });
        this.add((Component)this.jCheckPersist, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabClassOut = new JLabel("Output Class: ");
        this.add((Component)jLabClassOut, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jComClassOut, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jTableParam.setPreferredScrollableViewportSize(new Dimension(600, 200));
        this.jTableParam.setCellSelectionEnabled(true);
        this.jTableParam.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isMetaDown()) {
                    TesterPanel.this.showMenu(e.getPoint());
                }
            }
        });
        JScrollPane jScrollParam = new JScrollPane();
        jScrollParam.getViewport().add((Component)this.jTableParam, null);
        this.add((Component)jScrollParam, new GridBagConstraints(0, 3, 4, 1, 0.5, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jTableResults.setPreferredScrollableViewportSize(new Dimension(300, 300));
        this.jTableResults.setCellSelectionEnabled(true);
        this.jTableResults.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                TesterPanel.this.keyTypedEvent(e);
            }
        });
        this.jTableResults.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isMetaDown()) {
                    TesterPanel.this.showSouthMenu(e.getPoint());
                }
            }
        });
        JScrollPane jScrollResults = new JScrollPane();
        jScrollResults.getViewport().add((Component)this.jTableResults, null);
        this.add((Component)jScrollResults, new GridBagConstraints(0, 4, 4, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void executeFunctionGroup() {
        String cpoClassName;
        int result;
        if (this.jTableParam.isEditing()) {
            int row = this.jTableParam.getEditingRow();
            int column = this.jTableParam.getEditingColumn();
            this.jTableParam.getCellEditor(row, column).stopCellEditing();
        }
        CpoUtil.getInstance().setStatusBarText("");
        if (!((TesterParamModel)this.jTableParam.getModel()).isTableFilledOut() && (result = JOptionPane.showConfirmDialog(this.getTopLevelAncestor(), "You need to completely fill out the Parameter values in the table before executing a Function Group!\nContinue Anyway or CANCEL?", "User Error", 2)) == 2) {
            return;
        }
        String cpoClassNameReturnType = cpoClassName = this.cpoClassNode.getUserObject().getName();
        CpoClassNode returnClassNode = this.cpoClassNode;
        CpoFunctionGroupNode cpoFunctionGroupNode = this.getSelectedCpoFunctionGroupNode();
        if (cpoFunctionGroupNode.getType().equals(StFunctionGroupType.LIST.toString())) {
            returnClassNode = (CpoClassNode)this.jComClassOut.getSelectedItem();
            cpoClassNameReturnType = returnClassNode.getUserObject().getName();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Class name tester will use: " + cpoClassName + " and " + cpoClassNameReturnType + " as the return type class");
        }
        try {
            Class<?> cpoClass = CpoUtilClassLoader.getInstance(this.getClass().getClassLoader()).loadClass(cpoClassName);
            Object cpoObject = cpoClass.newInstance();
            Object cpoObjectReturnType = CpoUtilClassLoader.getInstance(this.getClass().getClassLoader()).loadClass(cpoClassNameReturnType).newInstance();
            Method[] methods = cpoClass.getMethods();
            TesterParamModel ctpm = (TesterParamModel)this.jTableParam.getModel();
            Hashtable<Object, Object> parameterMap = ctpm.getParameterMap();
            for (Object obj : parameterMap.keySet()) {
                String key = (String)obj;
                String methodName = "set" + key.substring(0, 1).toUpperCase() + key.substring(1);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Method name looking for: " + methodName);
                }
                boolean found = false;
                for (Method method : methods) {
                    Class<?>[] paramTypes;
                    if (!method.getName().equals(methodName) || (paramTypes = method.getParameterTypes()).length != 1) continue;
                    method.invoke(cpoObject, this.getMethObjFrStr(paramTypes[0], (String)parameterMap.get(key)));
                    found = true;
                }
                if (found) continue;
                throw new CpoException("Could not find method: " + methodName);
            }
            Collection<?> result2 = this.cpoClassNode.getProxy().executeFunctionGroup((String)this.connectionComboBox.getSelectedItem(), cpoObject, cpoObjectReturnType, cpoFunctionGroupNode.getUserObject(), this.jCheckPersist.isSelected());
            TableSorter ts = new TableSorter(new TesterResultsModel(result2, returnClassNode));
            this.jTableResults.setModel(ts);
            ts.addMouseListenerToHeaderInTable(this.jTableResults);
            CpoUtil.getInstance().setStatusBarText("Query Executed! Rows Returned: " + result2.size());
            this.setColumnSizes(200);
        }
        catch (NoClassDefFoundError cdfe) {
            CpoUtil.showException(cdfe);
            CpoUtil.getInstance().setCustomClasspath("Need path to: web-common, wls-startup and log4j!");
        }
        catch (Exception ex) {
            for (Throwable t = ex; t != null; t = t.getCause()) {
                this.logger.error(ex.getMessage(), (Throwable)ex);
            }
            CpoUtil.showException(ex);
        }
    }

    private void setColumnSizes(int columnSize) {
        this.jTableResults.setAutoResizeMode(0);
        for (int i = 0; i < this.jTableResults.getColumnCount(); ++i) {
            this.jTableResults.getColumnModel().getColumn(i).setPreferredWidth(columnSize);
        }
    }

    private Object getMethObjFrStr(Class<?> cls, String param) throws ParseException {
        if (param.equalsIgnoreCase("null") || param.equals("")) {
            return null;
        }
        if (param.equalsIgnoreCase("guid")) {
            return GUID.getGUID();
        }
        try {
            if (cls == String.class) {
                return param;
            }
            if (cls == Integer.TYPE) {
                return Integer.valueOf(param);
            }
            if (cls == Integer.class) {
                return Integer.valueOf(param);
            }
            if (cls == Float.TYPE) {
                return Float.valueOf(param);
            }
            if (cls == Float.class) {
                return Float.valueOf(param);
            }
            if (cls == BigDecimal.class) {
                return new BigDecimal(param);
            }
            if (cls == BigInteger.class) {
                return new BigInteger(param);
            }
            if (cls == java.util.Date.class) {
                this.logger.debug("Found type Date");
                if (param.equalsIgnoreCase("sysdate")) {
                    return new java.util.Date();
                }
                if (param.length() == 10) {
                    return sdfDateOnly.parse(param);
                }
                return sdf.parse(param);
            }
            if (cls == Date.class) {
                this.logger.debug("Found type sql Date");
                if (param.equalsIgnoreCase("sysdate")) {
                    return new Date(new java.util.Date().getTime());
                }
                if (param.length() == 10) {
                    return new Date(sdfDateOnly.parse(param).getTime());
                }
                return new Date(sdf.parse(param).getTime());
            }
            if (cls == Timestamp.class) {
                this.logger.debug("Found type Timestamp");
                if (param.equalsIgnoreCase("sysdate")) {
                    return new Timestamp(new java.util.Date().getTime());
                }
                if (param.length() == 10) {
                    return new Timestamp(sdfDateOnly.parse(param).getTime());
                }
                return new Timestamp(sdf.parse(param).getTime());
            }
            if (cls == byte[].class) {
                return param.getBytes();
            }
        }
        catch (ParseException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        CpoUtil.showErrorMessage("Could not locate the type for param: " + param + " which is class: " + cls);
        return null;
    }

    private void keyTypedEvent(KeyEvent e) {
        int[] selectedRows = this.jTableResults.getSelectedRows();
        int[] selectedCols = this.jTableResults.getSelectedColumns();
        if (selectedRows.length < 1 || selectedCols.length < 1) {
            return;
        }
        Object valueO = this.jTableResults.getValueAt(selectedRows[0], selectedCols[0]);
        if (valueO == null) {
            return;
        }
        String value = valueO.toString();
        if (e.getKeyCode() == 65485 || e.getKeyCode() == 67 && e.isControlDown() || e.getKeyCode() == 67 && e.isMetaDown() || e.getKeyChar() == '\u0003') {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(value), this);
        }
    }

    @Override
    public void lostOwnership(Clipboard clip, Transferable trans) {
        this.logger.debug("Boohoo ...  clipboard lost ownership ...");
    }

    private void insertValueAt(String value) {
        int[] selectedRows = this.jTableParam.getSelectedRows();
        if (selectedRows.length != 1) {
            CpoUtil.getInstance().setStatusBarText("Select ONE Row");
            return;
        }
        this.jTableParam.setValueAt(value, selectedRows[0], TesterParamModel.COLUMN_PARAMETER);
    }

    private void insertValuesFromResults() {
        int[] selectedRows = this.jTableResults.getSelectedRows();
        if (selectedRows.length != 1) {
            CpoUtil.getInstance().setStatusBarText("Select ONE Row");
            return;
        }
        for (int i = 0; i < this.jTableResults.getColumnCount(); ++i) {
            String setterName = this.jTableResults.getColumnName(i);
            int setColumn = this.getParamRowForSetter(setterName);
            if (setColumn == -1) continue;
            String value = this.jTableResults.getValueAt(selectedRows[0], i) == null ? null : this.jTableResults.getValueAt(selectedRows[0], i).toString();
            this.jTableParam.setValueAt(value, setColumn, TesterParamModel.COLUMN_PARAMETER);
        }
    }

    private int getParamRowForSetter(String setter) {
        int returnVal = -1;
        for (int i = 0; i < this.jTableParam.getRowCount(); ++i) {
            if (!this.jTableParam.getValueAt(i, TesterParamModel.COLUMN_ATTRIBUTE_NAME).equals(setter)) continue;
            returnVal = i;
        }
        return returnVal;
    }

    private void showMenu(Point p) {
        JPopupMenu menu = new JPopupMenu();
        menu.setLabel("Tester Menu");
        JMenuItem jMenuSetSysdate = new JMenuItem("Set Sysdate");
        jMenuSetSysdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TesterPanel.this.insertValueAt(sdf.format(new java.util.Date()));
            }
        });
        menu.add(jMenuSetSysdate);
        JMenuItem jMenuSetNewGuid = new JMenuItem("Set New Guid");
        jMenuSetNewGuid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TesterPanel.this.insertValueAt(GUID.getGUID());
            }
        });
        menu.add(jMenuSetNewGuid);
        menu.show(this.jTableParam, (int)p.getX(), (int)p.getY());
    }

    private void showSouthMenu(Point p) {
        JPopupMenu menu = new JPopupMenu();
        menu.setLabel("Results Menu");
        JMenuItem jMenuPopulateNorth = new JMenuItem("Populate Query");
        jMenuPopulateNorth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TesterPanel.this.insertValuesFromResults();
            }
        });
        menu.add(jMenuPopulateNorth);
        menu.show(this.jTableResults, (int)p.getX(), (int)p.getY());
    }

    private void setTableCellSize() {
        if (this.jComFunctionGroup.getSelectedItem() != null) {
            this.jTableParam.setAutoResizeMode(0);
            this.jTableParam.getColumnModel().getColumn(0).setPreferredWidth(45);
            this.jTableParam.getColumnModel().getColumn(1).setPreferredWidth(45);
            this.jTableParam.getColumnModel().getColumn(2).setPreferredWidth(112);
            this.jTableParam.getColumnModel().getColumn(3).setPreferredWidth(112);
            this.jTableParam.getColumnModel().getColumn(4).setPreferredWidth(290);
        }
    }

    private void functionGroupActionPerformed() {
        if (((CpoFunctionGroupNode)this.jComFunctionGroup.getSelectedItem()).getType().equals(StFunctionGroupType.EXIST.toString())) {
            this.jCheckPersist.setEnabled(true);
        } else {
            this.jCheckPersist.setSelected(false);
            this.jCheckPersist.setEnabled(false);
        }
        if (((CpoFunctionGroupNode)this.jComFunctionGroup.getSelectedItem()).getType().equals(StFunctionGroupType.LIST.toString())) {
            CpoFunctionGroupNode cqgn = (CpoFunctionGroupNode)this.jComFunctionGroup.getSelectedItem();
            try {
                CpoRootNode cpoRootNode = cqgn.getParent().getParent().getParent();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("about to get classes for: " + cpoRootNode);
                }
                this.jComClassOut.removeAllItems();
                Enumeration<TreeNode> children = cpoRootNode.children();
                while (children.hasMoreElements()) {
                    this.jComClassOut.addItem(children.nextElement());
                }
                this.jComClassOut.setSelectedItem(cqgn.getParent().getParent());
            }
            catch (Exception ex) {
                CpoUtil.showException(ex);
            }
            this.jComClassOut.setEnabled(true);
        } else {
            this.jComClassOut.setEnabled(false);
        }
        this.jTableParam.setModel(new TesterParamModel((CpoFunctionGroupNode)this.jComFunctionGroup.getSelectedItem()));
        this.setTableCellSize();
    }

    private void checkPersistActionPerformed() {
        if (this.jCheckPersist.isSelected()) {
            try {
                CpoFunctionGroupNode selectedNode = (CpoFunctionGroupNode)this.jComFunctionGroup.getSelectedItem();
                CpoFunctionGroupNode node = this.getFunctionGroupNode(selectedNode.getGroupName(), StFunctionGroupType.CREATE.toString());
                if (node == null) {
                    node = this.getFunctionGroupNode(selectedNode.getGroupName(), StFunctionGroupType.UPDATE.toString());
                }
                if (node == null) {
                    JOptionPane.showMessageDialog(CpoUtil.getInstance(), "Can't locate a 'CREATE' or 'UPDATE' CPO Type with the Group Name of '" + selectedNode.getGroupName() + "'", "Sorry, no go", 1);
                    this.jCheckPersist.setSelected(false);
                    return;
                }
                this.jTableParam.setModel(new TesterParamModel(node));
            }
            catch (Exception ex) {
                CpoUtil.showException(ex);
            }
        } else {
            this.jTableParam.setModel(new TesterParamModel(this.getSelectedCpoFunctionGroupNode()));
        }
        this.setTableCellSize();
    }

    private CpoFunctionGroupNode getFunctionGroupNode(String groupName, String type) {
        Enumeration<TreeNode> e = this.cpoClassNode.getFunctionGroupLabelNode().children();
        while (e.hasMoreElements()) {
            CpoFunctionGroupNode node = (CpoFunctionGroupNode)e.nextElement();
            if ((groupName != null || node.getGroupName() != null) && (node.getGroupName() == null || groupName == null || !node.getGroupName().equals(groupName)) || !node.getType().equals(type)) continue;
            return node;
        }
        return null;
    }

    private CpoFunctionGroupNode getSelectedCpoFunctionGroupNode() {
        return (CpoFunctionGroupNode)this.jComFunctionGroup.getSelectedItem();
    }
}

