/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.meta.domain.CpoAttribute;
import org.synchronoss.cpo.meta.domain.CpoFunctionGroup;
import org.synchronoss.cpo.util.CoreAttributeTableModel;
import org.synchronoss.cpo.util.CpoAttributeLabelNode;
import org.synchronoss.cpo.util.CpoAttributeNode;
import org.synchronoss.cpo.util.CpoAttributeTableEditor;
import org.synchronoss.cpo.util.CpoClassNode;
import org.synchronoss.cpo.util.CpoNewAttributePanel;
import org.synchronoss.cpo.util.CpoNewClassPanel;
import org.synchronoss.cpo.util.CpoUtil;
import org.synchronoss.cpo.util.TableSorter;

public class CpoAttributePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JPanel buttonPanel = new JPanel();
    private JButton addButton = new JButton();
    private JButton addFromExpressionButton = new JButton();
    private JButton removeButton = new JButton();
    private CpoAttributeLabelNode cpoAttLabNode;
    private JTable jTableAttMap;
    private JScrollPane jScrollTable = new JScrollPane();
    private CoreAttributeTableModel model;
    private TableSorter ts;
    private JPopupMenu menu = new JPopupMenu();
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CpoAttributePanel(CpoAttributeLabelNode cpoAttLabelNode, CoreAttributeTableModel model) {
        this.cpoAttLabNode = cpoAttLabelNode;
        this.model = model;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            CpoUtil.showException(e);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.buttonPanel.setLayout(new FlowLayout(0, 0, 0));
        this.addButton.setText("New");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CpoAttributePanel.this.addNewAttribute();
            }
        });
        this.buttonPanel.add(this.addButton);
        this.addFromExpressionButton.setText("New From Expression");
        this.addFromExpressionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CpoAttributePanel.this.addAttrToClassFromExpression();
            }
        });
        this.buttonPanel.add(this.addFromExpressionButton);
        this.removeButton.setText("Remove");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CpoAttributePanel.this.removeAttribute();
            }
        });
        this.buttonPanel.add(this.removeButton);
        this.add((Component)this.buttonPanel, "North");
        this.ts = new TableSorter(this.model);
        this.jTableAttMap = new JTable(this.ts);
        this.ts.addMouseListenerToHeaderInTable(this.jTableAttMap);
        this.jTableAttMap.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    ListSelectionModel selectionModel = CpoAttributePanel.this.jTableAttMap.getSelectionModel();
                    int row = CpoAttributePanel.this.jTableAttMap.rowAtPoint(e.getPoint());
                    selectionModel.addSelectionInterval(row, row);
                    CpoAttributePanel.this.showMenu(e.getPoint());
                }
            }
        });
        this.jTableAttMap.setDefaultEditor(String.class, new CpoAttributeTableEditor(this.cpoAttLabNode.getProxy().getAllowableDataTypes()));
        this.jScrollTable.getViewport().add(this.jTableAttMap);
        this.add((Component)this.jScrollTable, "Center");
    }

    public void showMenu(Point point) {
        this.menu.removeAll();
        JMenuItem jMenuRemove = new JMenuItem("Remove");
        jMenuRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CpoAttributePanel.this.removeAttribute();
            }
        });
        this.menu.add(jMenuRemove);
        JMenuItem jMenuAdd = new JMenuItem("Add New Attribute");
        jMenuAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CpoAttributePanel.this.addNewAttribute();
            }
        });
        this.menu.add(jMenuAdd);
        JMenuItem jMenuAddAttrWithSql = new JMenuItem("Add New Attributes based on expression");
        jMenuAddAttrWithSql.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CpoAttributePanel.this.addAttrToClassFromExpression();
            }
        });
        this.menu.add(jMenuAddAttrWithSql);
        this.menu.show(this.jTableAttMap, (int)point.getX(), (int)point.getY());
    }

    public void addNewAttribute() {
        CpoClassNode ccn = this.cpoAttLabNode.getParent();
        CpoNewAttributePanel cnap = this.cpoAttLabNode.getNewAttributePanel();
        int result = JOptionPane.showConfirmDialog(this.getTopLevelAncestor(), cnap, "Add New Attribute", 2);
        this.logger.debug("Result: " + result);
        if (result == 0) {
            try {
                CpoAttribute newAttribute = cnap.createCpoAttribute();
                boolean added = this.cpoAttLabNode.getProxy().addAttribute(ccn, newAttribute);
                if (added) {
                    this.model.fireTableDataChanged();
                }
            }
            catch (CpoException ex) {
                CpoUtil.showException(ex);
            }
        }
    }

    private void addAttrToClassFromExpression() {
        CpoClassNode ccn = this.cpoAttLabNode.getParent();
        CpoNewClassPanel cncp = new CpoNewClassPanel(ccn.getProxy(), ccn.getUserObject().getName());
        int result = JOptionPane.showConfirmDialog(this.getTopLevelAncestor(), cncp, "Add New Attributes based on Expression", 2);
        if (result == 0) {
            try {
                List<CpoAttribute> attributes = this.cpoAttLabNode.getProxy().createAttributesFromExpression(cncp.getConnection(), cncp.getExpression());
                boolean added = this.cpoAttLabNode.getProxy().addAttributes(ccn, attributes);
                if (added) {
                    this.model.fireTableDataChanged();
                }
            }
            catch (Exception e) {
                CpoUtil.showException(e);
            }
        } else {
            CpoUtil.getInstance().setStatusBarText("Aborted Attribute Creation");
        }
    }

    private void removeAttribute() {
        int[] selectedRows = this.jTableAttMap.getSelectedRows();
        if (selectedRows.length < 1) {
            CpoUtil.showErrorMessage("Please select an attribute to remove.");
            return;
        }
        int[] trueRows = this.ts.getTrueRows(selectedRows);
        ArrayList<CpoAttributeNode> nodesToRemove = new ArrayList<CpoAttributeNode>();
        for (int i : trueRows) {
            CpoAttributeNode cpoAttributeNode = (CpoAttributeNode)this.cpoAttLabNode.getChildAt(i);
            Set<CpoFunctionGroup> functionGroups = cpoAttributeNode.getProxy().getFunctionGroupsUsingAttribute(cpoAttributeNode);
            if (!functionGroups.isEmpty()) {
                StringBuilder msg = new StringBuilder();
                msg.append(cpoAttributeNode.getUserObject().getJavaName());
                msg.append(" cannot be removed because it is used by function(s):");
                for (CpoFunctionGroup functionGroup : functionGroups) {
                    msg.append("\n");
                    msg.append(functionGroup);
                }
                CpoUtil.showErrorMessage(msg.toString());
                return;
            }
            nodesToRemove.add(cpoAttributeNode);
        }
        for (CpoAttributeNode node : nodesToRemove) {
            node.setRemove(true);
        }
        this.model.fireTableDataChanged();
    }
}

