/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.util;

import java.util.Arrays;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.synchronoss.cpo.meta.domain.CpoAttribute;
import org.synchronoss.cpo.util.CpoAttributeLabelNode;
import org.synchronoss.cpo.util.CpoAttributeNode;

public class CoreAttributeTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    protected CpoAttributeLabelNode cpoAttLabNode;

    public CoreAttributeTableModel(CpoAttributeLabelNode cpoAttLabNode) {
        this.cpoAttLabNode = cpoAttLabNode;
    }

    public List<String> getColumnNames() {
        return Arrays.asList("Attribute", "Data Name", "Data Type", "Transform Class", "Modified?");
    }

    public List<Class<?>> getColumnClasses() {
        Class[] columnClasses = new Class[]{String.class, String.class, String.class, String.class, String.class};
        return Arrays.asList(columnClasses);
    }

    @Override
    public int getRowCount() {
        return this.cpoAttLabNode.getChildCount();
    }

    @Override
    public int getColumnCount() {
        return this.getColumnNames().size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.getColumnNames().get(columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.getColumnClasses().get(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex < 4;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        CpoAttributeNode cpoAttributeNode = (CpoAttributeNode)this.cpoAttLabNode.getChildAt(rowIndex);
        CpoAttribute att = cpoAttributeNode.getUserObject();
        if (columnIndex == 0) {
            return att.getJavaName();
        }
        if (columnIndex == 1) {
            return att.getDataName();
        }
        if (columnIndex == 2) {
            return att.getDataType();
        }
        if (columnIndex == 3) {
            return att.getTransformClassName();
        }
        if (columnIndex == 4) {
            if (cpoAttributeNode.isNew()) {
                return "New";
            }
            if (cpoAttributeNode.isRemove()) {
                return "Removed";
            }
            if (cpoAttributeNode.isDirty()) {
                return "Changed";
            }
            return "";
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        String val = aValue.toString();
        CpoAttributeNode cpoAttributeNode = (CpoAttributeNode)this.cpoAttLabNode.getChildAt(rowIndex);
        if (columnIndex == 0) {
            cpoAttributeNode.setAttribute(val);
        } else if (columnIndex == 1) {
            cpoAttributeNode.setDataName(val);
        } else if (columnIndex == 2) {
            cpoAttributeNode.setDataType(val);
        } else if (columnIndex == 3) {
            cpoAttributeNode.setTransformClass(val);
        }
        this.fireTableDataChanged();
    }
}

