/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreePath;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.util.AbstractCpoNode;
import org.synchronoss.cpo.util.CpoBrowserTree;
import org.synchronoss.cpo.util.CpoClassNode;
import org.synchronoss.cpo.util.CpoRootNode;
import org.synchronoss.cpo.util.CpoUtil;
import org.synchronoss.cpo.util.Proxy;

public class CpoBrowserPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Proxy proxy;
    private BorderLayout borderLayout = new BorderLayout();
    private JScrollPane jScrollWest = new JScrollPane();
    private CpoBrowserTree jTreeBrowser = new CpoBrowserTree();
    private JSplitPane jSplitPane = new JSplitPane();
    private JPanel emptyPanel = new JPanel();

    public CpoBrowserPanel(Proxy proxy) throws CpoException {
        this.proxy = proxy;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            CpoUtil.showException(e);
        }
        this.jTreeBrowser.setModel(this.proxy.createTreeModel());
        this.jTreeBrowser.toggleClassnames();
        TreePath tp = new TreePath(this.jTreeBrowser.getRoot());
        this.jTreeBrowser.setSelectionPath(tp);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout);
        this.jSplitPane.add((Component)this.jScrollWest, "left");
        this.jSplitPane.add((Component)this.emptyPanel, "right");
        this.jScrollWest.setMinimumSize(new Dimension(300, 0));
        this.jScrollWest.setPreferredSize(new Dimension(300, 0));
        this.emptyPanel.setMinimumSize(new Dimension(400, 0));
        this.emptyPanel.setPreferredSize(new Dimension(400, 0));
        this.add((Component)this.jSplitPane, "Center");
        this.jScrollWest.getViewport().add(this.jTreeBrowser);
        this.jScrollWest.getViewport().setPreferredSize(new Dimension(200, 0));
        this.jTreeBrowser.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent tee) {
                Object pathComp = tee.getPath().getLastPathComponent();
                if (pathComp instanceof CpoClassNode && ((CpoClassNode)pathComp).isProtected()) {
                    CpoUtil.showMessage("This is a protected class.  Be careful what you do.");
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent tee) {
            }
        });
        this.jTreeBrowser.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent tse) {
                if (tse.isAddedPath()) {
                    JPanel panel;
                    AbstractCpoNode acn = (AbstractCpoNode)tse.getPath().getLastPathComponent();
                    Component rightComp = CpoBrowserPanel.this.jSplitPane.getRightComponent();
                    int divLoc = CpoBrowserPanel.this.jSplitPane.getDividerLocation();
                    if (rightComp != null) {
                        CpoBrowserPanel.this.jSplitPane.remove(rightComp);
                    }
                    if ((panel = acn.getPanelForSelected()) == null) {
                        panel = CpoBrowserPanel.this.emptyPanel;
                    }
                    CpoBrowserPanel.this.jSplitPane.setRightComponent(panel);
                    CpoBrowserPanel.this.jSplitPane.setDividerLocation(divLoc);
                }
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this.jTreeBrowser);
    }

    Proxy getProxy() {
        return this.proxy;
    }

    public void save(File file) {
        this.jTreeBrowser.save(file);
    }

    public boolean hasUnsavedData() {
        CpoRootNode root = (CpoRootNode)this.jTreeBrowser.getModel().getRoot();
        return root.isUnsaved();
    }
}

