/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.tree.TreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.meta.domain.CpoAttribute;
import org.synchronoss.cpo.parser.ExpressionParser;
import org.synchronoss.cpo.util.CoreArgumentTableModel;
import org.synchronoss.cpo.util.CpoArgumentNode;
import org.synchronoss.cpo.util.CpoAttributeNode;
import org.synchronoss.cpo.util.CpoClassNode;
import org.synchronoss.cpo.util.CpoFunctionNode;
import org.synchronoss.cpo.util.CpoUtil;

public class CpoFunctionPanel
extends JPanel {
    private static final int EXPRESSION_LINE_MAX_SIZE = 2000;
    private static final String expressionLineTooBigMsg = "The expression entered has lines containing more than 2000 characters.\nThis might cause some tools such as sql plus not to be able to execute it.\n\nTo solve this issue, add line breaks to the query.";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static int divLocation = -1;
    private static final long serialVersionUID = 1L;
    private CpoFunctionNode cpoFunctionNode;
    private CoreArgumentTableModel coreArgumentTM;
    private JLabel jLabName = new JLabel();
    private JTextField jTextName = new JTextField();
    private JLabel jLabExpression = new JLabel();
    private JTextArea jTextAExpression = new JTextArea();
    private JScrollPane jScrollExpression = new JScrollPane();
    private JTable jTableArgument;
    private JSplitPane jSplitPane = new JSplitPane(0);

    public CpoFunctionPanel(CpoFunctionNode cpoFunctionNode, CoreArgumentTableModel coreArgumentTableModel) {
        this.cpoFunctionNode = cpoFunctionNode;
        this.coreArgumentTM = coreArgumentTableModel;
        try {
            this.jbInit();
            if (divLocation != -1) {
                this.jSplitPane.setDividerLocation(divLocation);
            }
        }
        catch (Exception e) {
            CpoUtil.showException(e);
        }
        this.jTextName.setText(cpoFunctionNode.getName());
        this.jTextAExpression.setText(cpoFunctionNode.getExpression());
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.add((Component)this.jSplitPane, "Center");
        this.jSplitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                divLocation = CpoFunctionPanel.this.jSplitPane.getDividerLocation();
            }
        });
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new GridBagLayout());
        this.jLabName.setText("Name:");
        northPanel.add((Component)this.jLabName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jTextName.setMinimumSize(new Dimension(200, 20));
        this.jTextName.setPreferredSize(new Dimension(200, 20));
        this.jTextName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent ke) {
                CpoFunctionPanel.this.cpoFunctionNode.setName(CpoFunctionPanel.this.jTextName.getText());
            }
        });
        northPanel.add((Component)this.jTextName, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.jLabExpression.setText("Expression:");
        northPanel.add((Component)this.jLabExpression, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jTextAExpression.setLineWrap(true);
        this.jTextAExpression.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                CpoFunctionPanel.this.checkExpressionLength();
            }
        });
        this.jTextAExpression.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                CpoFunctionPanel.this.checkExpressionLength();
            }
        });
        this.jTextAExpression.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent ke) {
                CpoFunctionPanel.this.checkExpression();
            }
        });
        this.jTextAExpression.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isMetaDown()) {
                    CpoFunctionPanel.this.jTableArgument.editCellAt(0, 0);
                    if (CpoFunctionPanel.this.cpoFunctionNode.getExpression() != null) {
                        CpoFunctionPanel.this.showMenu(e.getPoint());
                    }
                }
            }
        });
        this.jScrollExpression.getViewport().add((Component)this.jTextAExpression, null);
        this.jScrollExpression.getViewport().setMinimumSize(new Dimension(200, 50));
        this.jScrollExpression.getViewport().setPreferredSize(new Dimension(200, 100));
        northPanel.add((Component)this.jScrollExpression, new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.jSplitPane.setTopComponent(northPanel);
        this.jTableArgument = new JTable(this.coreArgumentTM);
        this.coreArgumentTM.initTableEditors(this.jTableArgument);
        JScrollPane jScrollTable = new JScrollPane();
        jScrollTable.getViewport().add(this.jTableArgument);
        this.jSplitPane.setBottomComponent(jScrollTable);
    }

    private void checkExpressionLength() {
        String expression = this.jTextAExpression.getText();
        boolean hasBigChunk = false;
        for (String chunk : expression.split("\n")) {
            if (chunk.length() <= 2000) continue;
            hasBigChunk = true;
        }
        if (hasBigChunk) {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), expressionLineTooBigMsg, "Warning", 2);
        }
    }

    private void checkExpression() {
        try {
            int i;
            ExpressionParser expressionParser = this.cpoFunctionNode.getProxy().getExpressionParser(this.jTextAExpression.getText());
            int tokenCount = expressionParser.countArguments();
            int attRowCount = this.coreArgumentTM.getNonRemovedRows();
            if (tokenCount > attRowCount) {
                for (i = tokenCount; i > attRowCount; --i) {
                    this.coreArgumentTM.addNewRow();
                }
            }
            if (tokenCount < attRowCount) {
                for (i = attRowCount; i > tokenCount; --i) {
                    this.coreArgumentTM.removeNewRow();
                }
            }
            String newExpression = this.jTextAExpression.getText();
            this.cpoFunctionNode.setExpression(newExpression);
            CpoUtil.getInstance().setStatusBarText("Expression Length: " + newExpression.length());
        }
        catch (CpoException ex) {
            CpoUtil.showException(ex);
        }
    }

    private void showMenu(Point p) {
        JPopupMenu menu = new JPopupMenu();
        menu.removeAll();
        menu.setLabel("Expression Menu");
        JMenuItem jMenuAddParams = new JMenuItem("Add Expression Params Here");
        jMenuAddParams.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CpoFunctionPanel.this.insertSQLparams();
            }
        });
        menu.add(jMenuAddParams);
        JMenuItem jMenuAddAttrs = new JMenuItem("Add All Attributes Here");
        jMenuAddAttrs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CpoFunctionPanel.this.insertAllAttributes();
            }
        });
        menu.add(jMenuAddAttrs);
        JMenuItem jMenuGuessAttributes = new JMenuItem("Guess Attributes");
        jMenuGuessAttributes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CpoFunctionPanel.this.guessAttributes();
            }
        });
        menu.add(jMenuGuessAttributes);
        menu.show(this.jTextAExpression, (int)p.getX(), (int)p.getY());
    }

    private void insertSQLparams() {
        Enumeration<TreeNode> queryEnum = this.cpoFunctionNode.children();
        StringBuilder sbParams = new StringBuilder();
        while (queryEnum.hasMoreElements()) {
            CpoArgumentNode node = (CpoArgumentNode)queryEnum.nextElement();
            sbParams.append(node.getCpoAttribute().getDataName());
            sbParams.append(",");
        }
        this.jTextAExpression.insert(sbParams.toString().substring(0, sbParams.toString().length() - 1), this.jTextAExpression.getCaretPosition());
        this.checkExpression();
    }

    private void insertAllAttributes() {
        CpoClassNode classNode = this.cpoFunctionNode.getParent().getParent().getParent();
        if (classNode != null) {
            String sql = this.jTextAExpression.getText();
            boolean isInsert = sql.toUpperCase().startsWith("INSERT");
            try {
                boolean first = true;
                StringBuilder buf = new StringBuilder();
                Enumeration<TreeNode> e = classNode.getAttributeLabelNode().children();
                while (e.hasMoreElements()) {
                    CpoAttributeNode att = (CpoAttributeNode)e.nextElement();
                    String colName = att.getDataName();
                    if (!first) {
                        buf.append(", ");
                    }
                    buf.append(colName);
                    if (!isInsert) {
                        buf.append(" = ?");
                    }
                    first = false;
                }
                this.jTextAExpression.insert(buf.toString().substring(0, buf.toString().length()), this.jTextAExpression.getCaretPosition());
                this.checkExpression();
            }
            catch (Exception ex) {
                CpoUtil.showException(ex);
            }
        }
    }

    private void guessAttributes() {
        String query = this.jTextAExpression.getText().trim();
        Vector<String> errors = new Vector<String>();
        try {
            ExpressionParser expressionParser = this.cpoFunctionNode.getProxy().getExpressionParser(query);
            List colList = expressionParser.parse();
            if (colList == null || colList.isEmpty()) {
                return;
            }
            if (this.logger.isDebugEnabled()) {
                int count = 1;
                for (String col : colList) {
                    this.logger.debug("Column[" + count + "] = " + col);
                    ++count;
                }
            }
            HashMap<String, CpoAttribute> hash = new HashMap<String, CpoAttribute>();
            CpoClassNode classNode = this.cpoFunctionNode.getParent().getParent().getParent();
            if (classNode != null) {
                Enumeration<TreeNode> e = classNode.getAttributeLabelNode().children();
                while (e.hasMoreElements()) {
                    CpoAttributeNode att = (CpoAttributeNode)e.nextElement();
                    String dataName = att.getDataName();
                    if (dataName == null || att.getUserObject() == null) continue;
                    hash.put(dataName.toUpperCase(), att.getUserObject());
                }
            }
            int idx = 0;
            for (String col : colList) {
                CpoAttribute att = (CpoAttribute)hash.get(col);
                if (att != null) {
                    this.coreArgumentTM.setValueAt(att, idx, 1);
                } else {
                    errors.add(col);
                }
                ++idx;
            }
            if (!errors.isEmpty()) {
                StringBuilder buf = new StringBuilder();
                for (String s : errors) {
                    buf.append("\n");
                    buf.append(s);
                }
                JOptionPane.showMessageDialog(this.getTopLevelAncestor(), "Unable to guess the following fields: " + buf.toString(), "Warning", 2);
            }
        }
        catch (ParseException ex) {
            CpoUtil.showMessage(ex.getMessage());
        }
        catch (Exception ex) {
            CpoUtil.showException(ex);
        }
    }
}

