/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.meta.domain.CpoAttribute;
import org.synchronoss.cpo.util.CpoAttributeLabelNode;
import org.synchronoss.cpo.util.CpoUtil;

public class CpoNewAttributePanel
extends JPanel {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long serialVersionUID = 1L;
    protected JTextField jTextAtt = new JTextField();
    protected JTextField jTextDataName = new JTextField();
    protected JComboBox jComDataType;
    protected JTextField jTextTransform = new JTextField();
    protected CpoAttributeLabelNode cpoAttributeLabelNode;

    public CpoNewAttributePanel(CpoAttributeLabelNode cpoAttributeLabelNode) {
        this.cpoAttributeLabelNode = cpoAttributeLabelNode;
        this.jComDataType = new JComboBox<String>(cpoAttributeLabelNode.getProxy().getAllowableDataTypes());
        try {
            this.jbInit();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(382, 281));
        this.setLayout(new GridBagLayout());
        JLabel jLabAtt = new JLabel();
        jLabAtt.setText("Attribute:");
        this.add((Component)jLabAtt, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jTextAtt.setPreferredSize(new Dimension(100, 22));
        this.jTextAtt.setMinimumSize(new Dimension(100, 22));
        this.add((Component)this.jTextAtt, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabDataName = new JLabel();
        jLabDataName.setText("Data Name:");
        this.add((Component)jLabDataName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jTextDataName.setMinimumSize(new Dimension(100, 22));
        this.jTextDataName.setPreferredSize(new Dimension(100, 22));
        this.add((Component)this.jTextDataName, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabDataType = new JLabel();
        jLabDataType.setText("Data Type:");
        this.add((Component)jLabDataType, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jComDataType, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabTransform = new JLabel();
        jLabTransform.setText("Transform Class:");
        this.add((Component)jLabTransform, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jTextTransform.setMinimumSize(new Dimension(100, 22));
        this.jTextTransform.setPreferredSize(new Dimension(100, 22));
        this.add((Component)this.jTextTransform, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public CpoAttribute createCpoAttribute() throws CpoException {
        String javaName = this.jTextAtt.getText();
        if (this.cpoAttributeLabelNode.getParent().attributeExists(javaName)) {
            CpoUtil.showErrorMessage("An attribute with that name already exists.");
            return null;
        }
        CpoAttribute attribute = this.cpoAttributeLabelNode.getProxy().createCpoAttribute();
        attribute.setJavaName(javaName);
        attribute.setDataName(this.jTextDataName.getText());
        attribute.setDataType((String)this.jComDataType.getSelectedItem());
        attribute.setTransformClassName(this.jTextTransform.getText());
        return attribute;
    }
}

