/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.core.cpoCoreConfig.CtDataSourceConfig;
import org.synchronoss.cpo.jdbc.cpoJdbcConfig.CtJdbcConfig;
import org.synchronoss.cpo.jdbc.meta.JdbcCpoMetaDescriptor;
import org.synchronoss.cpo.meta.CpoMetaDescriptor;
import org.synchronoss.cpo.util.AbstractConnectionPanel;
import org.synchronoss.cpo.util.Proxy;
import org.synchronoss.cpo.util.jdbc.JdbcConnectionPanel;
import org.synchronoss.cpo.util.jdbc.JdbcProxy;

public enum SupportedType {
    Jdbc(JdbcCpoMetaDescriptor.class, JdbcProxy.class, CtJdbcConfig.class, JdbcConnectionPanel.class);

    protected static Logger logger;
    private Class<? extends CpoMetaDescriptor> metaDescriptorClass = null;
    private Class<? extends Proxy> proxyClass = null;
    private Class<? extends CtDataSourceConfig> dataSourceConfigClass = null;
    private Class<? extends AbstractConnectionPanel> connectionPanelClass = null;

    private SupportedType(Class<? extends CpoMetaDescriptor> metaDescriptorClass, Class<? extends Proxy> proxyClass, Class<? extends CtDataSourceConfig> dataSourceConfigClass, Class<? extends AbstractConnectionPanel> connectionPanelClass) {
        this.metaDescriptorClass = metaDescriptorClass;
        this.proxyClass = proxyClass;
        this.dataSourceConfigClass = dataSourceConfigClass;
        this.connectionPanelClass = connectionPanelClass;
    }

    public Class<? extends CpoMetaDescriptor> getMetaDescriptorClass() {
        return this.metaDescriptorClass;
    }

    public Class<? extends CtDataSourceConfig> getDataSourceConfigClass() {
        return this.dataSourceConfigClass;
    }

    public Class<? extends AbstractConnectionPanel> getConnectionPanelClass() {
        return this.connectionPanelClass;
    }

    public Proxy newProxyInstance() throws Exception {
        return this.proxyClass.newInstance();
    }

    public static SupportedType getTypeForMetaDescriptor(CpoMetaDescriptor metaDescriptor) throws CpoException {
        for (SupportedType type : SupportedType.values()) {
            if (!type.metaDescriptorClass.isAssignableFrom(metaDescriptor.getClass())) continue;
            return type;
        }
        throw new CpoException("Unknown meta descriptor");
    }

    public static SupportedType getTypeForConnection(CtDataSourceConfig dataSourceConfig) throws CpoException {
        for (SupportedType type : SupportedType.values()) {
            if (!type.dataSourceConfigClass.isAssignableFrom(dataSourceConfig.getClass())) continue;
            return type;
        }
        throw new CpoException("Unknown data source config");
    }

    static {
        logger = LoggerFactory.getLogger(SupportedType.class);
    }
}

