/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.util.jdbc;

import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import org.synchronoss.cpo.jdbc.JdbcCpoAttribute;
import org.synchronoss.cpo.jdbc.cpoJdbcMeta.CtJdbcArgument;
import org.synchronoss.cpo.meta.domain.CpoAttribute;
import org.synchronoss.cpo.util.CoreArgumentTableModel;
import org.synchronoss.cpo.util.CpoArgumentNode;
import org.synchronoss.cpo.util.CpoFunctionNode;
import org.synchronoss.cpo.util.jdbc.JdbcArgumentNode;

public class JdbcArgumentTableModel
extends CoreArgumentTableModel {
    public JdbcArgumentTableModel(CpoFunctionNode cpoFunctionNode) {
        super(cpoFunctionNode);
    }

    @Override
    public void initTableEditors(JTable table) {
        super.initTableEditors(table);
        JComboBox<String> jIOTypeBox = new JComboBox<String>();
        jIOTypeBox.addItem(CtJdbcArgument.Scope.IN.toString());
        jIOTypeBox.addItem(CtJdbcArgument.Scope.OUT.toString());
        jIOTypeBox.addItem(CtJdbcArgument.Scope.BOTH.toString());
        DefaultCellEditor editor = new DefaultCellEditor(jIOTypeBox);
        table.setDefaultEditor(JComboBox.class, editor);
    }

    @Override
    public List<String> getColumnNames() {
        return Arrays.asList("Seq Num", "Attribute", "Data Name", "Data Type", "Scope", "Type Info", "DB Table", "DB Column", "Transform Class", "Changed?");
    }

    @Override
    public List<Class<?>> getColumnClasses() {
        Class[] columnClasses = new Class[]{String.class, JdbcCpoAttribute.class, String.class, String.class, JComboBox.class, String.class, String.class, String.class, String.class, String.class};
        return Arrays.asList(columnClasses);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1 || columnIndex == 4 || columnIndex == 5;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        CpoArgumentNode cpoArgumentNode = (CpoArgumentNode)this.cpoFunctionNode.getChildAt(rowIndex);
        if (!(cpoArgumentNode instanceof JdbcArgumentNode)) {
            return null;
        }
        JdbcArgumentNode jdbcArgumentNode = (JdbcArgumentNode)cpoArgumentNode;
        JdbcCpoAttribute jdbcAttribute = jdbcArgumentNode.getCpoAttribute();
        if (columnIndex == 0) {
            return this.cpoFunctionNode.getIndex(cpoArgumentNode);
        }
        if (columnIndex == 1) {
            return cpoArgumentNode.getCpoAttribute();
        }
        if (columnIndex == 2) {
            return jdbcAttribute != null ? jdbcAttribute.getDataName() : null;
        }
        if (columnIndex == 3) {
            return jdbcAttribute != null ? jdbcAttribute.getDataType() : null;
        }
        if (columnIndex == 4) {
            return jdbcArgumentNode.getScope();
        }
        if (columnIndex == 5) {
            return jdbcArgumentNode.getTypeInfo();
        }
        if (columnIndex == 6) {
            return jdbcAttribute != null ? jdbcAttribute.getDbTable() : null;
        }
        if (columnIndex == 7) {
            return jdbcAttribute != null ? jdbcAttribute.getDbColumn() : null;
        }
        if (columnIndex == 8) {
            return jdbcAttribute != null ? jdbcAttribute.getTransformClassName() : null;
        }
        if (columnIndex == 9) {
            if (cpoArgumentNode.isNew()) {
                return "New";
            }
            if (cpoArgumentNode.isRemove()) {
                return "Removed";
            }
            if (cpoArgumentNode.isDirty()) {
                return "Changed";
            }
            return "";
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        CpoArgumentNode cpoArgumentNode = (CpoArgumentNode)this.cpoFunctionNode.getChildAt(rowIndex);
        if (!(cpoArgumentNode instanceof JdbcArgumentNode)) {
            return;
        }
        JdbcArgumentNode jdbcArgumentNode = (JdbcArgumentNode)cpoArgumentNode;
        if (columnIndex == 1) {
            jdbcArgumentNode.setCpoAttribute((CpoAttribute)((JdbcCpoAttribute)aValue));
        } else if (columnIndex == 4) {
            jdbcArgumentNode.setScope((String)aValue);
        } else if (columnIndex == 5) {
            jdbcArgumentNode.setTypeInfo((String)aValue);
        }
        this.fireTableDataChanged();
    }
}

