/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Properties;
import oracle.net.ano.Ano;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.AcceptPacket;
import oracle.net.ns.ClientProfile;
import oracle.net.ns.Communication;
import oracle.net.ns.ConnectPacket;
import oracle.net.ns.DataPacket;
import oracle.net.ns.MarkerPacket;
import oracle.net.ns.NetException;
import oracle.net.ns.NetInputStream;
import oracle.net.ns.NetOutputStream;
import oracle.net.ns.Packet;
import oracle.net.ns.RedirectPacket;
import oracle.net.ns.RefusePacket;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;
import oracle.net.nt.ConnOption;
import oracle.net.nt.NTAdapter;
import oracle.net.resolver.AddrResolution;

public class NSProtocol
implements Communication,
SQLnetDef {
    private static final boolean ACTIVATE_ANO = true;
    private AddrResolution addrRes;
    private SessionAtts sAtts = new SessionAtts(this, 65535, 65535);
    private MarkerPacket mkPkt;
    private DataPacket probePacket;
    private Packet packet;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_12:18:34_PDT_2010";
    public static final boolean TRACE = false;

    public NSProtocol() {
        this.sAtts.connected = false;
    }

    @Override
    public SessionAtts getSessionAttributes() {
        return this.sAtts;
    }

    @Override
    public void connect(String string, Properties properties) throws IOException, NetException {
        RefusePacket refusePacket;
        Object object;
        RedirectPacket redirectPacket;
        AcceptPacket acceptPacket;
        ConnectPacket connectPacket;
        Object object2;
        if (this.sAtts.connected) {
            throw new NetException(201);
        }
        if (string == null) {
            throw new NetException(208);
        }
        NVFactory nVFactory = new NVFactory();
        NVNavigator nVNavigator = new NVNavigator();
        NVPair nVPair = null;
        String string2 = null;
        this.addrRes = new AddrResolution(string, properties);
        String string3 = (String)properties.get("DISABLE_OOB");
        boolean bl = string3 != null && "true".equals(string3);
        String string4 = (String)properties.get("USE_ZERO_COPY_IO");
        boolean bl2 = true;
        if (string4 != null && "false".equals(string4)) {
            bl2 = false;
        }
        this.sAtts.traceId = (String)properties.get("T4CConnection.hashCode");
        if (this.addrRes.connection_revised) {
            string = this.addrRes.getTNSAddress();
            properties = this.addrRes.getUp();
        }
        this.sAtts.profile = new ClientProfile(properties);
        this.establishConnection(string);
        Object var15_11 = null;
        try {
            var15_11 = Class.forName("oracle.net.ano.Ano").newInstance();
            this.sAtts.anoEnabled = true;
        }
        catch (Exception exception) {
            this.sAtts.anoEnabled = false;
        }
        if (var15_11 != null) {
            ((Ano)var15_11).init(this.sAtts);
            this.sAtts.ano = var15_11;
            this.sAtts.anoEnabled = true;
        }
        block15: while (true) {
            object2 = null;
            connectPacket = new ConnectPacket(this.sAtts, !bl, bl2);
            this.packet = new Packet(this.sAtts, this.sAtts.getSDU());
            try {
                connectPacket.send();
                this.packet.receive();
            }
            catch (InterruptedIOException interruptedIOException) {
                throw interruptedIOException;
            }
            catch (IOException iOException) {
                this.packet.type = 4;
                object2 = iOException;
            }
            switch (this.packet.type) {
                case 2: {
                    acceptPacket = new AcceptPacket(this.packet);
                    break block15;
                }
                case 5: {
                    redirectPacket = new RedirectPacket(this.packet);
                    object = this.sAtts.cOption;
                    this.addrRes.connection_redirected = true;
                    this.sAtts.cOption.nt.disconnect();
                    this.sAtts = this.establishConnection(redirectPacket.getData());
                    this.sAtts.cOption.restoreFromOrigCoption((ConnOption)object);
                    break;
                }
                case 4: {
                    refusePacket = new RefusePacket(this.packet);
                    this.sAtts.cOption.nt.disconnect();
                    this.sAtts.cOption = null;
                    this.establishConnection(null);
                    if (this.sAtts.cOption != null) continue block15;
                    if (object2 != null) {
                        throw object2;
                    }
                    try {
                        NVPair nVPair2;
                        nVPair = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(refusePacket.getData()), "ERROR");
                        if (nVPair != null && (nVPair2 = nVNavigator.findNVPairRecurse(nVPair, "CODE")) != null) {
                            string2 = nVPair2.valueToString();
                        }
                    }
                    catch (NLException nLException) {
                        System.err.println(nLException.getMessage());
                    }
                    throw new NetException(string2 == null ? 206 : Integer.parseInt(string2), "");
                }
                case 11: {
                    if ((this.packet.flags & 8) != 8) continue block15;
                    this.sAtts.renegotiateSSLSession();
                    break;
                }
                default: {
                    this.sAtts.cOption.nt.disconnect();
                    throw new NetException(205);
                }
            }
        }
        this.setNetStreams();
        this.sAtts.connected = true;
        this.sAtts.nt.setReadTimeoutIfRequired(properties);
        object2 = (String)this.sAtts.nt.getOption(6);
        if (object2 != null && ((String)object2).equalsIgnoreCase("false")) {
            throw new NetException(405);
        }
        if (!this.sAtts.noAnoServices && this.sAtts.ano != null) {
            this.sAtts.ano.negotiation();
            object = (String)this.sAtts.nt.getOption(2);
            if (object != null && ((String)object).equals("TRUE")) {
                try {
                    Method method = this.sAtts.ano.getClass().getMethod("getEncryptionAlg", null);
                    if (method.invoke((Object)this.sAtts.ano, (Object[])null) != null) {
                        throw new NetException(406);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.packet = null;
        connectPacket = null;
        acceptPacket = null;
        redirectPacket = null;
        refusePacket = null;
    }

    @Override
    public void disconnect() throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        IOException iOException = null;
        try {
            this.sAtts.nsOutputStream.close();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        this.sAtts.connected = false;
        this.sAtts.cOption.nt.disconnect();
        if (iOException != null) {
            throw iOException;
        }
    }

    @Override
    public void sendBreak() throws IOException, NetException {
        if ((this.sAtts.negotiatedOptions & 0x400) == 1024) {
            this.sAtts.nt.sendUrgentByte(33);
            if ((this.sAtts.negotiatedOptions & 0x800) != 2048) {
                this.sendMarker(1);
            }
        } else {
            this.sendMarker(1);
        }
    }

    @Override
    public void sendInterrupt() throws IOException, NetException {
        if ((this.sAtts.negotiatedOptions & 0x400) == 1024) {
            this.sAtts.nt.sendUrgentByte(33);
            if ((this.sAtts.negotiatedOptions & 0x800) != 2048) {
                this.sendMarker(3);
            }
        } else {
            this.sendMarker(3);
        }
    }

    @Override
    public void sendReset() throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        this.sendMarker(2);
        while (this.sAtts.onBreakReset) {
            Packet packet = ((NetInputStream)this.sAtts.getInputStream()).getCurrentPacket();
            packet.receive();
            if (packet.type != 12) continue;
            this.mkPkt = new MarkerPacket(packet);
            if (this.mkPkt.data != 2) continue;
            this.sAtts.onBreakReset = false;
        }
        this.mkPkt = null;
    }

    @Override
    public NetInputStream getNetInputStream() throws NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        return this.sAtts.nsInputStream;
    }

    @Override
    public InputStream getInputStream() throws NetException {
        return this.getNetInputStream();
    }

    @Override
    public NetOutputStream getNetOutputStream() throws NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        return this.sAtts.nsOutputStream;
    }

    @Override
    public OutputStream getOutputStream() throws NetException {
        return this.getNetOutputStream();
    }

    private SessionAtts establishConnection(String string) throws NetException, IOException {
        this.sAtts.cOption = this.addrRes.resolveAndExecute(string);
        if (this.sAtts.cOption == null) {
            return null;
        }
        this.sAtts.nt = this.sAtts.cOption.nt;
        this.sAtts.ntInputStream = this.sAtts.cOption.nt.getInputStream();
        this.sAtts.ntOutputStream = this.sAtts.cOption.nt.getOutputStream();
        this.sAtts.setTDU(this.sAtts.cOption.tdu);
        this.sAtts.setSDU(this.sAtts.cOption.sdu);
        if (this.sAtts.attemptingReconnect) {
            this.sAtts.nsOutputStream.reinitialize(this.sAtts);
            this.sAtts.nsInputStream.reinitialize(this.sAtts);
            if (this.mkPkt != null) {
                this.mkPkt.reinitialize(this.sAtts);
            }
        } else {
            this.sAtts.nsOutputStream = new NetOutputStream(this.sAtts, 255);
            this.sAtts.nsInputStream = new NetInputStream(this.sAtts);
        }
        return this.sAtts;
    }

    private void setNetStreams() throws NetException, IOException {
        this.sAtts.nsOutputStream = new NetOutputStream(this.sAtts);
        this.sAtts.nsInputStream = new NetInputStream(this.sAtts);
    }

    private void sendMarker(int n2) throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        this.mkPkt = new MarkerPacket(this.sAtts, n2);
        this.mkPkt.send();
        this.mkPkt = null;
    }

    @Override
    public void setO3logSessionKey(byte[] byArray) throws NetException {
        if (byArray != null) {
            this.sAtts.ano.setO3logSessionKey(byArray);
        }
    }

    @Override
    public void setOption(int n2, Object object) throws NetException, IOException {
        if (n2 > 0 && n2 < 10) {
            NTAdapter nTAdapter = this.sAtts.getNTAdapter();
            nTAdapter.setOption(n2, object);
        }
    }

    @Override
    public Object getOption(int n2) throws NetException, IOException {
        if (n2 > 0 && n2 < 10) {
            NTAdapter nTAdapter = this.sAtts.getNTAdapter();
            return nTAdapter.getOption(n2);
        }
        return null;
    }

    @Override
    public void abort() throws NetException, IOException {
        NTAdapter nTAdapter = this.sAtts.getNTAdapter();
        if (nTAdapter != null) {
            nTAdapter.abort();
        }
    }

    @Override
    public String getEncryptionName() {
        String string = null;
        NTAdapter nTAdapter = this.sAtts.getNTAdapter();
        try {
            string = (String)nTAdapter.getOption(5);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null && this.sAtts.ano != null) {
            string = this.sAtts.ano.getEncryptionName();
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    public String getDataIntegrityName() {
        String string = "";
        if (this.sAtts.ano != null) {
            string = this.sAtts.ano.getDataIntegrityName();
        }
        return string;
    }

    @Override
    public String getAuthenticationAdaptorName() {
        String string = "";
        if (this.sAtts.ano != null) {
            string = this.sAtts.ano.getAuthenticationAdaptorName();
        }
        return string;
    }

    public void reconnectIfRequired(boolean bl) throws IOException {
        long l2 = System.currentTimeMillis();
        long l3 = l2 - this.sAtts.timestampLastIO;
        if (l3 > (long)this.sAtts.timeout) {
            this.reconnect(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect(boolean bl) throws IOException {
        try {
            String string = new String(this.sAtts.reconnectAddress);
            this.sAtts.attemptingReconnect = true;
            ConnOption connOption = this.sAtts.cOption;
            this.addrRes.connection_redirected = true;
            this.sAtts.cOption.nt.disconnect();
            this.establishConnection(string);
            this.sAtts.cOption.restoreFromOrigCoption(connOption);
            if (bl) {
                if (this.probePacket == null) {
                    this.probePacket = new DataPacket(this.sAtts, 26);
                } else {
                    this.probePacket.reinitialize(this.sAtts);
                }
                this.probePacket.send();
            }
        }
        finally {
            this.sAtts.attemptingReconnect = false;
        }
    }
}

